local turnsound = "situyl_zoom/situyl_zoom/situyl_zoom"

local basic_assets =
{
	Asset("ANIM", "anim/situyl_zoomin.zip"),
	Asset("ANIM", "anim/situyl_zoomin_swap.zip"),
	Asset("ATLAS", "images/situyl_zoomin.xml"),
	
	--Ч
	Asset("SOUNDPACKAGE", "sound/situyl_zoom.fev"),
    Asset("SOUND", "sound/situyl_zoom.fsb"),
}
local poison_assets =
{
	Asset("ANIM", "anim/situyl_zoomout.zip"),
	Asset("ANIM", "anim/situyl_zoomout_swap.zip"),
	Asset("ATLAS", "images/situyl_zoomout.xml"),
}

local function onfinished(inst)
	inst:Remove()
end

local function onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_object", "situyl_zoomin_swap", "situyl_zoomin_swap")
	owner.AnimState:Show("ARM_carry")
	owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner)
	owner.AnimState:Hide("ARM_carry")
	owner.AnimState:Show("ARM_normal")
end

--
local function basicattack(inst, attacker, target)
	tw_spawn(target, "statue_transition", nil, 1, 1, nil, {turnsound,0})
	if target.components.situyl_zoom and tw_isalive(target) then
		target.components.situyl_zoom:Apply(1)
	end
end

local function poisonattack(inst, attacker, target)
	tw_spawn(target, "statue_transition", nil, 1, 1, nil, {turnsound,0})
	if target.components.situyl_zoom and tw_isalive(target) then
		target.components.situyl_zoom:Apply(-1)
	end
end

-----------ʩ
--Ŵ
local function cantornado(staff, caster, target, pos)
    return tw_isalive(target) and target.components.situyl_zoom and target.components.situyl_zoom.current < 2
end

local function spawntornado(staff, target, pos)
    tw_spawn(target, "chesterlight", nil, 1, 1, nil, {turnsound,.7}, function(guy)
		guy:DoTaskInTime(0, function() guy:TurnOn() end)
		guy:DoTaskInTime(1, function() 
			guy:TurnOff() 
			if tw_isalive(target) and target.components.situyl_zoom then
				target.components.situyl_zoom:Apply(1)
			end
		end)
	end)
    staff.components.finiteuses:Use(1)
end

--С
local function cantornado2(staff, caster, target, pos)
    return tw_isalive(target) and target.components.situyl_zoom and target.components.situyl_zoom.current > -2
end

local function spawntornado2(staff, target, pos) 
	tw_spawn(target, "chesterlight", nil, 1, 1, nil, {turnsound,.7}, function(guy)
		guy:DoTaskInTime(0, function() guy:TurnOn() end)
		guy:DoTaskInTime(1, function() 
			guy:TurnOff() 
			if tw_isalive(target) and target.components.situyl_zoom then
				target.components.situyl_zoom:Apply(-1)
			end
		end)
	end)
    staff.components.finiteuses:Use(1)
end


local function commonfn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()

	MakeInventoryPhysics(inst)
	--MakeInventoryFloatable(inst, "idle_water", "idle")

	--inst:AddTag("sharp")

	--inst:AddComponent("weapon")
	--inst.components.weapon:SetDamage(25)

	--inst:AddComponent("tradable")
	inst:AddTag("nopunch")
	-------

	inst:AddComponent("finiteuses")
	inst.components.finiteuses:SetMaxUses(10)
	inst.components.finiteuses:SetUses(10)

	inst.components.finiteuses:SetOnFinished( onfinished )

	inst:AddComponent("inspectable")

	inst:AddComponent("equippable")
	inst.components.equippable:SetOnEquip( onequip )
	inst.components.equippable:SetOnUnequip( onunequip )
	
	--Ҽʩ
	inst:AddComponent("spellcaster")
    inst.components.spellcaster.canuseontargets = true
    inst.components.spellcaster.canusefrominventory = false
    --inst.components.spellcaster:SetSpellTestFn(cantornado)
    --inst.components.spellcaster:SetSpellFn(spawntornado)
    inst.components.spellcaster.castingstate = "castspell_tornado"
    --inst.components.spellcaster.actiontype = "SCIENCE"

	return inst
end

--Ŵ
local function basicfn(Sim)
	local inst = commonfn(Sim)

	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/situyl_zoomin.xml"
	inst.components.inventoryitem.imagename = "situyl_zoomin"

	inst.AnimState:SetBuild("situyl_zoomin")
	inst.AnimState:SetBank("situyl_zoomin")
	inst.AnimState:PlayAnimation("idle")
	--inst:AddTag("spear")
	if IsDLCEnabled(CAPY_DLC) then
		inst:AddComponent("floatable")
		inst.components.floatable.landanim = "idle" 
		inst.components.floatable.wateranim = "idle" 
	end
	
	--inst.components.weapon:SetOnAttack(basicattack)
	inst.components.spellcaster:SetSpellTestFn(cantornado)
    inst.components.spellcaster:SetSpellFn(spawntornado)
	--inst.speartype = "spear"

	return inst
end

--С
local function onequippoison(inst, owner)
	owner.AnimState:OverrideSymbol("swap_object", "situyl_zoomout_swap", "situyl_zoomout_swap")
	owner.AnimState:Show("ARM_carry")
	owner.AnimState:Hide("ARM_normal")
end
local function poisonfn(Sim)
	local inst = commonfn(Sim)

	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/situyl_zoomout.xml"
	inst.components.inventoryitem.imagename = "situyl_zoomout"

	inst.AnimState:SetBuild("situyl_zoomout")
	inst.AnimState:SetBank("situyl_zoomout")
	inst.AnimState:PlayAnimation("idle")
	
	if IsDLCEnabled(CAPY_DLC) then
		inst:AddComponent("floatable")
		inst.components.floatable.landanim = "idle" 
		inst.components.floatable.wateranim = "idle" 
	end

	--inst.components.weapon:SetOnAttack(poisonattack)
	inst.components.equippable:SetOnEquip(onequippoison)
	inst.components.spellcaster:SetSpellTestFn(cantornado2)
    inst.components.spellcaster:SetSpellFn(spawntornado2)
	--inst:AddTag("spear")

	--inst.speartype = "poison"

	return inst
end

return Prefab( "common/inventory/situyl_zoomin", basicfn, basic_assets),
	   Prefab( "common/inventory/situyl_zoomout", poisonfn, poison_assets)
	   