local UIAnim = require "widgets/uianim"
local Widget = require "widgets/widget"
local Text = require "widgets/text"

local veggie_meat = Class(Widget, function(self, owner)
	Widget._ctor(self, "veggie_meat")
	self.owner = owner

    self:SetPosition(0,0,0)

    self.point = 0

    self.anim = self:AddChild(UIAnim())
	self.anim:GetAnimState():SetBank("wet")
	self.anim:GetAnimState():SetBuild("veggie_meat")

    self.num = self:AddChild(Text(BODYTEXTFONT, 33))
    self.num:SetHAlign(ANCHOR_MIDDLE)
    self.num:SetPosition(5, -50, 0)

	self:StartUpdating()
end)

function veggie_meat:OnUpdate(dt)
	local newnum = self.owner.components.veggie_meat.current
	--local oldnum = self.point
	self.point = newnum
	--if newnum ~= oldnum then
		self.anim:GetAnimState():SetPercent("anim", newnum/100 * .99)
	--end
	
	if newnum >= 99 and newnum < 100 then
		newnum = 99
	end
	if newnum > 0 and newnum <= 1 then
		newnum = 1
	end

	self.num:SetString( tostring( math.ceil(newnum) ).."\%" )
end

return veggie_meat