#######################################################
##  Entrance

screen entrance:
    tag entrancemenu
    vbox xalign 0.02 yalign 0.01:
        if miko_location=="entrance":
            imagebutton idle "gui/talka_miko.png" hover "gui/talkb_miko.png" action Jump("miko_talk")
        if aki_location=="entrance":
            imagebutton idle "gui/talka_aki.png" hover "gui/talkb_aki.png" action Jump("aki_talk")
        if naoki_location=="entrance":
            imagebutton idle "gui/talka_naoki.png" hover "gui/talkb_naoki.png" action Jump("naoki_talk")
        imagebutton idle "gui/examinea.png" hover "gui/examineb.png" action Jump("entrance_explore")
        imagebutton idle "gui/movea.png" hover "gui/moveb.png" action Jump("entrance_move")

screen entrancemove:
    default tt = Tooltip("Entrance")
    vbox xalign 0.5 yalign 0.0:
        add "gui/movebar.png"
    vbox xalign 0.5 ypos 32:
        text tt.value size 28
        
    vbox xalign 0.02 yalign 0.6:
        imagebutton idle "gui/lobby_arrow01.png" hover "gui/lobby_arrow01b.png" action Jump("upstairsevents") hovered tt.Action("Upstairs")
    vbox xalign 0.225 yalign 0.5:
        imagebutton idle "gui/lobby_arrow02.png" hover "gui/lobby_arrow02b.png" action Jump("hallwayevents") hovered tt.Action("Hallway")
    
label entrancemenu:
    hide screen entranceexplore
    show screen entrance
    " "
    jump entrancemenu
    
label entrance_move: 
    hide screen entrance
    show screen entrancemove
    " "
    jump entrance_move
    
screen entranceexplore:
    imagemap:
        ground "bg/entrance.jpg" idle "bg/entrance.jpg" hover "bg/entrance.jpg"
        hotspot (263, 211, 148, 372) action Jump("entrance_fountain")
        hotspot (541, 219, 386, 221) action Jump("entrance_tree")
        hotspot (0, 221, 167, 290) action Jump("entrance_bamboo")
        hotspot (434, 45, 308, 103) action Jump("entrance_calligraphy")
        hotspot (232, 0, 73, 170) action Jump("entrance_office")
        
    vbox xalign 0.02 yalign 0.01:
        imagebutton idle "gui/donea.png" hover "gui/doneb.png" action Jump("entrancemenu")
        
label entrance_fountain:
    if limei_q05 and not limei_key:
        $ limei_key = True
        hide screen entranceexplore
        "The center of the fountain features a dragon and a tiger. Is that the space between mind and body that the puzzle box was referring to?"
        "I run my hand along the orb. Nothing."
        "Hm...Mr. Auten was trying to keep all of this secret, so..."
        "I look up at the camera on the ceiling and move around the fountain slowly until I'm hidden from view."
        "Sophia is going to kill me if she finds me messing with this thing."
        "I run my hand down the orb carefully until I feel a seam in glass."
        "I press it gently, and it moves to the side, revealing a thin metal rod twisted into an intricate pattern on one end."
        "Is this the key?"
        "I glance up just to make sure the camera isn't watching me before I take the key and slide it into my pocket."
        show screen entranceexplore
    elif limei_key:
        "I found a key in the glass orb between the dragon and tiger. I should take it to Li Mei."
    else:
        "It's a water fountain. The glass orb is lit by a light bulb, but it looks like there's a bowl in the middle. I'd guess that back in the day, it held oil for a flame."
    jump entrance_explore
    
label entrance_tree:
    "At first glance, it appears to be a peach tree, but all the peaches are actually lightbulbs. That's sort of interesting."
    jump entrance_explore
    
label entrance_bamboo:
    "It's live bamboo. I bet a panda would enjoy it."
    jump entrance_explore
    
label entrance_calligraphy:
    if not limei_q06:
        "Some sort of Chinese calligraphy. Too bad I can't read it."
    else:
        "\"No dust settles here.\" Maybe Mr. Auten really wanted to keep this place tidy?"
    jump entrance_explore
    
label entrance_office:
    "That's the door to Mr. Auten's office. I'm fairly certain that I'm not allowed in there."
    jump entrance_explore
    
label entrance_explore:
    hide screen entrance
    show screen entranceexplore
    " "
    jump entrance_explore

label entranceevents:
    hide screen upstairsmove
    hide screen hallwaymove
    scene entrance with dissolve
    if limei_q01 and kevin_q02 and miko_q01 and sophia_convo01 and not aki_convo01:
        jump aki01
    jump entrancemenu
    
    
#######################################################
##  Upstairs

screen upstairs:
    tag upstairsmenu
    vbox xalign 0.02 yalign 0.01:
        if miko_location=="upstairs":
            imagebutton idle "gui/talka_miko.png" hover "gui/talkb_miko.png" action Jump("miko_talk")
        imagebutton idle "gui/examinea.png" hover "gui/examineb.png" action Jump("upstairs_explore")
        imagebutton idle "gui/movea.png" hover "gui/moveb.png" action Jump("upstairs_move")

screen upstairsmove:
    default tt = Tooltip("Upstairs")
    vbox xalign 0.5 yalign 0.0:
        add "gui/movebar.png"
    vbox xalign 0.5 ypos 32:
        text tt.value size 28

    vbox xalign 0.9 yalign 0.6:
        imagebutton idle "gui/upperhallway_arrow01.png" hover "gui/upperhallway_arrow01b.png" action Jump("entranceevents") hovered tt.Action("Entrance")
    
label upstairsmenu:
    hide screen upstairsexplore
    show screen upstairs
    " "
    jump upstairsmenu
    
label upstairs_move:
    hide screen upstairs
    show screen upstairsmove
    " "
    jump upstairs_move

screen upstairsexplore:
    imagemap:
        ground "bg/upstairs.jpg" idle "bg/upstairs.jpg" hover "bg/upstairs.jpg"
        hotspot (452, 187, 170, 338) action Jump("upstairs_door")
        hotspot (0, 0, 339, 451) action Jump("upstairs_art")
        hotspot (718, 372, 121, 91) action Jump("upstairs_calligraphy")
        
    vbox xalign 0.02 yalign 0.01:
        imagebutton idle "gui/donea.png" hover "gui/doneb.png" action Jump("upstairsmenu")
    
label upstairs_explore:
    hide screen upstairs
    show screen upstairsexplore
    " "
    jump upstairs_explore
    
label upstairs_door:
    "That's the door to Mr. Auten's office. It's locked."
    jump upstairs_explore
    
label upstairs_art:
    "Some sort of art screen. It looks very old."
    jump upstairs_explore
    
label upstairs_calligraphy:
    if not limei_q06:
        "Calligraphy. Chinese, I assume."
    else:
        "According to Li Mei, that means \"No dust settles here.\" I'm sure it's a very deep and profound statement."
    jump upstairs_explore

label upstairsevents:
    hide screen entrancemove
    scene upstairs with dissolve
    jump upstairsmenu
    
    
#######################################################
##  Hallway
            
screen hallway:
    tag hallwaymenu
    
    vbox xalign 0.02 yalign 0.01:
        if kevin_location=="hallway":
            imagebutton idle "gui/talka_kevin.png" hover "gui/talkb_kevin.png" action Jump("kevin_talk")
        imagebutton idle "gui/examinea.png" hover "gui/examineb.png" action Jump("hallway_explore")
        imagebutton idle "gui/movea.png" hover "gui/moveb.png" action Jump("hallway_move")
        
screen hallwayexplore:
    imagemap:
        ground "bg/hallway.jpg" idle "bg/hallway.jpg" hover "bg/hallway.jpg"
        hotspot (29, 308, 71, 85) action Jump("hallway_box")
        hotspot (398, 365, 17, 23) action Jump("hallway_box")
        hotspot (460, 365, 6, 10) action Jump("hallway_box")
        hotspot (694, 350, 18, 32) action Jump("hallway_box")
        hotspot (347, 255, 32, 295) action Jump("hallway_art01")
        hotspot (443, 317, 15, 141) action Jump("hallway_art02")
        hotspot (635, 302, 18, 171) action Jump("hallway_art03")
        hotspot (717, 249, 31, 324) action Jump("hallway_art04")
        hotspot (576, 344, 25, 93) action Jump("hallway_vase")
        hotspot (598, 254, 13, 11) action Jump("hallway_camera")
        
    vbox xalign 0.02 yalign 0.01:
        imagebutton idle "gui/donea.png" hover "gui/doneb.png" action Jump("hallwaymenu")
        
label hallway_box:
    "It's a retina scanner. The door only unlocks if you have clearance. There's a keypad attached to it. I bet I could override the scanner if I knew the right codes."
    jump hallway_explore
    
label hallway_art01:
    "It's an old painting on a silk scroll. It appears to be a mountain of some sort."
    jump hallway_explore
    
label hallway_art02:
    "It's an old painting on a silk scroll. It appears to be a forest of some sort."
    jump hallway_explore
    
label hallway_art03:
    "It's an old painting on a silk scroll. It appears to be a cave of some sort."
    jump hallway_explore
    
label hallway_art04:
    "It's an old painting on a silk scroll. It appears to be an ocean of some sort."
    jump hallway_explore
    
label hallway_vase:
    "A vase with some sort of plant. The vase looks authentic, but the plant is definitely a fake."
    jump hallway_explore
    
label hallway_camera:
    "A security camera. It's enclosed in tinted plastic so I can't see which direction it's pointing in. Is it looking at me?"
    jump hallway_explore
        
label hallway_explore:
    hide screen hallway
    show screen hallwayexplore
    " "
    jump hallway_explore
    
screen hallwaymove:
    default tt = Tooltip("Hallway")
    vbox xalign 0.5 yalign 0.0:
        add "gui/movebar.png"
    vbox xalign 0.5 ypos 32:
        text tt.value size 28
    
    vbox xalign 0.8 yalign 0.63:
        imagebutton idle "gui/hallway_arrow01.png" hover "gui/hallway_arrow01b.png" action Jump("entranceevents") hovered tt.Action("Entrance")
    vbox xalign 0.25 yalign 0.63:
        imagebutton idle "gui/hallway_arrow02.png" hover "gui/hallway_arrow02b.png" action Jump("securityevents") hovered tt.Action("Security Room")
        
    if sophia_convo01:
        vbox xalign 0.435 yalign 0.52:
            imagebutton idle "gui/hallway_arrow03.png" hover "gui/hallway_arrow03b.png" action Jump("kitchenevents") hovered tt.Action("Kitchen")
    else:
        vbox xalign 0.435 yalign 0.52:
            imagebutton idle "gui/hallway_arrow03.png" hover "gui/hallway_arrow03b.png" action Jump("kitchenevents") hovered tt.Action("???")
            
    if bathroomvisit:
        vbox xalign 0.65 yalign 0.52:
            imagebutton idle "gui/hallway_arrow04.png" hover "gui/hallway_arrow04b.png" action Jump("bathroomevents") hovered tt.Action("Restroom")
    else:
        vbox xalign 0.65 yalign 0.52:
            imagebutton idle "gui/hallway_arrow04.png" hover "gui/hallway_arrow04b.png" action Jump("bathroomevents") hovered tt.Action("???")
        
    if mari_convo01 or explore01_livingroom:
        vbox xalign 0.587 yalign 0.48:
            imagebutton idle "gui/hallway_arrow05.png" hover "gui/hallway_arrow05b.png" action Jump("livingroomevents") hovered tt.Action("Living Room")
    else:
        vbox xalign 0.587 yalign 0.48:
            imagebutton idle "gui/hallway_arrow05.png" hover "gui/hallway_arrow05b.png" action Jump("livingroomevents") hovered tt.Action("???")
            
    if explore01_gallery or museumvisit or museum_visit:
        vbox xalign 0.475 yalign 0.48:
            imagebutton idle "gui/hallway_arrow06.png" hover "gui/hallway_arrow06b.png" action Jump("museumevents") hovered tt.Action("Museum")
    else:
        vbox xalign 0.475 yalign 0.48:
            imagebutton idle "gui/hallway_arrow06.png" hover "gui/hallway_arrow06b.png" action Jump("museumevents") hovered tt.Action("???")
            
    vbox xalign 0.535 yalign 0.58:
        imagebutton idle "gui/hallway_arrow07.png" hover "gui/hallway_arrow07b.png" action Jump("backstairsevents") hovered tt.Action("Staircase")
        
label hallway_move:
    hide screen hallway
    show screen hallwaymove
    " "
    jump hallway_move
    
label hallwaymenu:
    hide screen hallwayexplore
    show screen hallway
    " "
    jump hallwaymenu
    
label hallwayevents:
    hide screen entrancemove
    hide screen livingroommove
    hide screen museummove
    hide screen backstairsmove
    hide screen kitchenmove
    hide screen securitymove
    hide screen bathroommove
    scene hallway with dissolve
    if aki_convo01:
        if readbody and not liam_convo01:
            jump liam01
        elif aki_q01 and not liam_convo01:
            jump liam01
    elif ending=="vault":
        if marissa_alone:
            jump end_escape
        else:
            jump end_boring
    if endsoon > 1:
        if sophia_guess:
            jump end_sophialiam
        elif marissa_alone:
            jump end_escape
        else:
            jump end_boring
    elif endsoon > 0:
        $ endsoon += 1
    if sophia_q07 and kevin_q05 and limei_q01 and naoki_q01:
        $ endsoon += 1
    if not kevin_met:
        jump kevin01        
    jump hallwaymenu
    
    
#######################################################
##  Living Room
            
screen livingroom:
    tag livingroommenu
    
    vbox xalign 0.02 yalign 0.01:
        if marissa_location=="livingroom":
            imagebutton idle "gui/talka_marissa.png" hover "gui/talkb_marissa.png" action Jump("marissa_talk")
        if miko_location=="livingroom":
            imagebutton idle "gui/talka_miko.png" hover "gui/talkb_miko.png" action Jump("miko_talk")
        if liam_location=="livingroom":
            imagebutton idle "gui/talka_liam.png" hover "gui/talkb_liam.png" action Jump("liam_talk")
        imagebutton idle "gui/examinea.png" hover "gui/examineb.png" action Jump("livingroom_explore")
        imagebutton idle "gui/movea.png" hover "gui/moveb.png" action Jump("livingroom_move")
        
screen livingroomexplore:
    imagemap:
        ground "bg/livingroometc.jpg" idle "bg/livingroometc.jpg" hover "bg/livingroometc.jpg"
        hotspot (73, 310, 251, 102) action Jump("livingroom_table")
        hotspot (475, 291, 120, 123) action Jump("livingroom_tv")
        hotspot (456, 425, 75, 30) action Jump("livingroom_player")
        hotspot (523, 456, 34, 13) action Jump("livingroom_disc")
        hotspot (635,144,388, 214) action Jump("livingroom_outside")
        hotspot (4,243,13, 196) action Jump("livingroom_door")
        
    vbox xalign 0.02 yalign 0.01:
        imagebutton idle "gui/donea.png" hover "gui/doneb.png" action Jump("livingroommenu")
        
label livingroom_explore:
    hide screen livingroom
    show screen livingroomexplore
    " "
    jump livingroom_explore
    
label livingroom_door:
    "This door leads back into the main hallway."
    jump livingroom_explore
    
label livingroom_table:
    "A dining room table. It looks like it could host a lot of people, but judging from the dust in the middle, I doubt it's been used for a while."
    jump livingroom_explore
    
label livingroom_tv:
    "Two thousand channels, and still nothing on."
    jump livingroom_explore
    
label livingroom_player:
    "Some sort of combo disc player that reads all sorts of formats. It's empty."
    jump livingroom_explore
    
label livingroom_disc:
    "\"Benefits of Organ Reproduction.\" Looks like some sort of corporate presentation or informational video."
    jump livingroom_explore
    
label livingroom_outside:
    "The garden is made up of evergreens. I think those flowers are called rhododendrons. They're a fairly low maintenance plant."
    jump livingroom_explore
    
screen livingroommove:
    default tt = Tooltip("Living Room")
    vbox xalign 0.5 yalign 0.0:
        add "gui/movebar.png"
    vbox xalign 0.5 ypos 32:
        text tt.value size 28
        
    vbox xalign 0.01 yalign 0.42:
        imagebutton idle "gui/hallway_arrow03.png" hover "gui/hallway_arrow03b.png" action Jump("hallwayevents") hovered tt.Action("Hallway")
        
label livingroom_move:
    hide screen livingroom
    show screen livingroommove
    " "
    jump livingroom_move
    
label livingroommenu:
    hide screen livingroomexplore
    show screen livingroom
    " "
    jump livingroommenu
    
label livingroomevents:
    hide screen hallwaymove
    scene livingroom with dissolve
    if not mari_convo01:
        jump marissa01
    elif liam_convo01 and not liam_convo02:
        jump liam02
    elif liam_convo02 and mari_q02 and not liam_convo03:
        jump liam03
    jump livingroommenu
    
#######################################################
##  Museum
            
screen museum:
    tag museummenu
    
    vbox xalign 0.02 yalign 0.01:
        if limei_location=="museum":
            imagebutton idle "gui/talka_limei.png" hover "gui/talkb_limei.png" action Jump("limei_talk")
        imagebutton idle "gui/examinea.png" hover "gui/examineb.png" action Jump("museum_explore")
        imagebutton idle "gui/movea.png" hover "gui/moveb.png" action Jump("museum_move")
        
screen museumexplore:
    imagemap:
        ground "bg/museum.jpg" idle "bg/museum.jpg" hover "bg/museum.jpg"
        hotspot (704, 285, 116, 134) action Jump("museum_door")
        hotspot (730, 420, 134, 47) action Jump("museum_pottery")
        hotspot (460, 328, 155, 270) action Jump("museum_armor")
        hotspot (405, 365, 47, 57) action Jump("museum_pot")
        hotspot (40,71,284, 334) action Jump("museum_tapestry")
        hotspot (145,409,189, 73) action Jump("museum_plates")
        hotspot (918,373,103, 104) action Jump("museum_box")
        
    vbox xalign 0.02 yalign 0.01:
        imagebutton idle "gui/donea.png" hover "gui/doneb.png" action Jump("museummenu")
        
label museum_explore:
    hide screen museum
    show screen museumexplore
    ""
    jump museum_explore
    
label museum_door:
    "I'm not sure where that door leads. Outside, I guess? Either way, it's locked."
    jump museum_explore
    
label museum_pottery:
    "There are a lot of strange markings on this thing. According to the label, it's an oracle bone. I guess people tried to see the future with this?"
    jump museum_explore
    
label museum_armor:
    "Some old armor from the Qin Dynasty, if the label is to be believed. Looks like it's still in decent condition, so I guess it worked pretty well for whoever owned it previously."
    jump museum_explore
    
label museum_pot:
    "A very nice urn. It must have been expensive when it was first made. It's probably even more expensive now."
    jump museum_explore
    
label museum_tapestry:
    if limei_q04 or museum_visit:
        "Tortoise, dragon, phoenix, and tiger. Li Mei says they're from Chinese mythology."
    else:
        "A strange tapestry with some animals on them. There's a turtle and some bird. Not sure what the other two are."
    jump museum_explore
    
label museum_plates:
    "These plates have the same animals as the tapestry. I guess these creatures are really important."
    jump museum_explore
    
label museum_box:
    if kevin_q04 and not limei_q03:
        hide screen museumexplore
        jump limei_examinebox
    elif limei_q03:
        "It's a puzzle box. Mr. Auten was hiding something in here."
    else:
        "It's some sort of box. There's no label on it. I guess it's not that important."
    jump museum_explore
    
screen museummove:
    default tt = Tooltip("Museum")
    vbox xalign 0.5 yalign 0.0:
        add "gui/movebar.png"
    vbox xalign 0.5 ypos 32:
        text tt.value size 28
        
    vbox xalign 1.0 yalign 0.47:
        imagebutton idle "gui/hallway_arrow04.png" hover "gui/hallway_arrow04b.png" action Jump("hallwayevents") hovered tt.Action("Hallway")
        
label museum_move:
    hide screen museum
    show screen museummove
    " "
    jump museum_move
    
label museummenu:
    hide screen museumexplore
    show screen museum
    " "
    jump museummenu
    
label museumevents:
    hide screen hallwaymove
    scene museum with dissolve
    if not (explore01_gallery or museum_visit or museumvisit):
        $ museumvisit = True
        if not explore01_gallery:
            "Whoa. Guess I found where he keeps all his rich person stuff."
    if limei_key and not limei_q07:
        jump limei_key
    jump museummenu
    
#######################################################
##  Security
            
screen security:
    tag securitymenu
    
    vbox xalign 0.02 yalign 0.01:
        if kevin_location=="security":
            imagebutton idle "gui/talka_kevin.png" hover "gui/talkb_kevin.png" action Jump("kevin_talk")
        imagebutton idle "gui/examinea.png" hover "gui/examineb.png" action Jump("security_explore")
        imagebutton idle "gui/movea.png" hover "gui/moveb.png" action Jump("security_move")
        
label security_explore:
    hide screen security
    if kevin_location == "security":
        "I doubt Kevin would appreciate it if I poked around all of his stuff. I should probably wait for a time when he's not around."
        jump securitymenu
    else:
        show screen securityexplore
        " "
    jump security_explore
    
screen securityexplore:
    imagemap:
        ground "bg/security.jpg" idle "bg/security.jpg" hover "bg/security.jpg"
        hotspot (189, 465, 246, 553) action Jump("security_computer")
        hotspot (0, 265, 74, 82) action Jump("security_maps")
        hotspot (79, 264, 93, 86) action Jump("security_maps02")
        hotspot (79, 353, 90, 61) action Jump("security_maps03")
        hotspot (959, 251, 56, 185) action Jump("security_phone")
        hotspot (712, 443, 197, 87) action Jump("security_recorder")
        hotspot (347, 435, 94, 28) action Jump("security_keyboard")
        hotspot (449, 445, 24, 22) action Jump("security_mouse")
        hotspot (280, 410, 64, 148) action Jump("security_chair")
        hotspot (343, 512, 75, 45) action Jump("security_chair")
        hotspot (337, 560, 16, 48) action Jump("security_chair")
        hotspot (275, 610, 139, 42) action Jump("security_chair")
        hotspot (229, 257, 75, 64) action Jump("security_screen01")
        hotspot (225, 331, 78, 62) action Jump("security_screen02")
        hotspot (307, 254, 79, 67) action Jump("security_screen03")
        hotspot (308, 327, 78, 66) action Jump("security_screen04")
        hotspot (391, 248, 74, 62) action Jump("security_screen05")
        hotspot (391, 326, 76, 65) action Jump("security_screen06")
        hotspot (472, 232, 77, 67) action Jump("security_screen07")
        hotspot (476, 315, 75, 74) action Jump("security_screen08")
        hotspot (556, 201, 87, 80) action Jump("security_screen09")
        hotspot (560, 303, 86, 81) action Jump("security_screen10")
        hotspot (649, 160, 103, 97) action Jump("security_screen11")
        hotspot (655, 278, 101, 97) action Jump("security_screen12")
        hotspot (755, 86, 128, 133) action Jump("security_screen13")
        hotspot (766, 252, 130, 112) action Jump("security_screen14")
        
    vbox xalign 0.02 yalign 0.01:
        imagebutton idle "gui/donea.png" hover "gui/doneb.png" action Jump("securitymenu")
        
    
label security_maps:
    $ securitycount += 1
    "A map of the second floor. All that's there is Mr. Auten's office and a few bedrooms."
    jump security_explore
    
label security_maps02:
    $ securitycount += 1
    "A map of the first floor. I think I've been in all of these rooms."
    jump security_explore
    
label security_maps03:
    $ securitycount += 1
    "The basement. It's pretty small."
    jump security_explore
    
label security_phone:
    $ securitycount += 1
    "Wow, a phone that's actually attached to a wall. I guess if cell phones don't work here, you need a land line after all."
    jump security_explore
    
label security_recorder:
    $ securitycount += 1
    "Some sort of recording device. I assume it stores footage from the security cameras."
    jump security_explore
    
label security_keyboard:
    $ securitycount += 1
    "It's a normal computer keyboard."
    jump security_explore
    
label security_mouse:
    $ securitycount += 1
    "A computer mouse. It looks normal to me."
    jump security_explore
    
label security_chair:
    $ securitycount += 1
    "A fairly standard office chair."
    jump security_explore
    
label security_screen01:
    $ securitycount += 1
    "Someone's bedroom, I think. Looks nice and large."
    jump security_explore
    
label security_screen02:
    $ securitycount += 1
    "The road that leads to this house.  There are a lot of trees outside."
    jump security_explore
    
label security_screen03:
    $ securitycount += 1
    "A luxurious looking bedroom. I'm a bit envious; all I get is a couch in Aki's apartment."
    jump security_explore
    
label security_screen04:
    $ securitycount += 1
    "The main entrance."
    jump security_explore
    
label security_screen05:
    $ securitycount += 1
    if kevin_q04:
        "It's Mr. Auten's collection. I can't see all of the artifacts from this angle."
    else:
        "Mr. Auten's collection of expensive things that break easily."
    jump security_explore
    
label security_screen06:
    $ securitycount += 1
    "A bunch of lines of code. I can't understand any of it."
    jump security_explore
    
label security_screen07:
    $ securitycount += 1
    "That's the living room."
    jump security_explore
    
label security_screen08:
    $ securitycount += 1
    "A bunch of computer files. They're probably important."
    jump security_explore
    
label security_screen09:
    $ securitycount += 1
    if readbody:
        "Looks like a storage room of some sort."
    else:
        "It's the basement. I get the feeling I'm the only person who's been there in a while."
    jump security_explore
    
label security_screen10:
    $ securitycount += 1
    "The kitchen. Not much going on in there."
    jump security_explore
    
label security_screen11:
    $ securitycount += 1
    "I think that's the upstairs hallway."
    jump security_explore
    
label security_screen12:
    $ securitycount += 1
    "The downstairs hallway."
    jump security_explore
    
label security_screen13:
    $ securitycount += 1
    "The main staircase. Not much going on."
    jump security_explore
    
label security_screen14:
    $ securitycount += 1
    "The stairs leading to the basement. Looks like the coast is clear for now, but Kevin might be back at any minute."
    jump security_explore
    
label security_computer:
        $ securitypapers = True
        hide screen securityexplore
        "I kneel beside the computer to inspect it. It looks like it was custom built, but there's nothing suspicious about it."
        "As I stand, I notice a yellow bit of cardboard sandwiched between the computer and the glass desk."
        $ kan_eb = 5
        $ kan_eyes = 1
        $ kan_mouth = 2
        k "Hm...what's this?"
        "I pull it out gently. It's a folder stuffed with papers. This looks promising."
        #k "Hey, Naoki. Have a look at this."
        #show naoki a02 hopeful:
        #    zoom .8 xalign 0.5 ypos 50
        #with dissolve
        #n "What is it?"
        #k "I'm not entirely sure. Looks like a list of money transactions."
        #n "Do you think it's important?"
        #$ kan_mouth = 1
        #k "I don't know. Maybe-"
        #show naoki a02 panic with dissolve
        voice "voice/aki_256.ogg"
        v "Kan! Naoki! We're out of time. Get out of there!"
        "I roll up the papers quickly and stuff them under my shirt. Naoki and I make a mad dash for the door."
        scene hallway with dissolve
        "We burst out into the hallway, shut the door quickly behind us, then attempt a casual walk back into the lobby."
        scene entrance with dissolve
        "The casual walk turns out to be more of a pitiful swagger, but thankfully there's no one in the lobby to see us."
        "After a few minutes, Aki rejoins us."
        show aki a01 smirk:
            xalign 0.5 yalign 0.0
        with dissolve
        voice "voice/aki_192.ogg"
        a "So? Find anything?"
        "I show her and Naoki the papers that I discovered."
        show aki a01 thoughtful:
            xalign 0.1
        show naoki a01 neutral:
            xalign 0.8 yalign 0.0
        with dissolve
        voice "voice/aki_193.ogg"
        a "Hm...these numbers are pretty recent. I see a lot of references to other companies, but I'm not sure what they mean."
        k "Likewise."
        "Aki and Naoki both furrow their brows in concentration as they examine the papers."
        "Despite their wildly different personalities, they still reflect each other's actions."
        "Finally Aki sighs and hands the papers back to me."
        voice "voice/aki_194.ogg"
        a "I've got nothing."
        "I take the pages back from her and roll them up again. Maybe someone else can tell me what they mean."
        hide naoki with dissolve
        $ kevin_location = "security"
        $ naoki_location = "upstairs"
        jump aki_interrogate
    
screen securitymove:
    default tt = Tooltip("Security Room")
    vbox xalign 0.5 yalign 0.0:
        add "gui/movebar.png"
    vbox xalign 0.5 ypos 32:
        text tt.value size 28
    
    vbox xalign 0.01 yalign 0.47:
        imagebutton idle "gui/hallway_arrow02.png" hover "gui/hallway_arrow02b.png" action Jump("hallwayevents") hovered tt.Action("Hallway")
        
label security_move:
    if kevin_location == "basement":
        "I can't leave yet. Better keep exploring while I still have the chance."
        jump securitymenu
    hide screen security
    show screen securitymove
    " "
    jump security_move
    
label securitymenu:
    hide screen securityexplore
    show screen security
    " "
    jump securitymenu
    
label securityevents:
    hide screen hallwaymove
    if not kevin_convo02:
        jump kevin02
    scene security with dissolve
    if kevin_convo02 and not kevin_convo03:
        jump kevin03
    jump securitymenu
    
    
#######################################################
##  Kitchen
            
screen kitchen:
    tag kitchenmenu
    
    vbox xalign 0.02 yalign 0.01:
        if naoki_location=="kitchen":
            imagebutton idle "gui/talka_naoki.png" hover "gui/talkb_naoki.png" action Jump("naoki_talk")
        if sophia_location=="kitchen":
            imagebutton idle "gui/talka_sophia.png" hover "gui/talkb_sophia.png" action Jump("sophia_talk")
        imagebutton idle "gui/examinea.png" hover "gui/examineb.png" action Jump("kitchen_explore")
        imagebutton idle "gui/movea.png" hover "gui/moveb.png" action Jump("kitchen_move")
        
screen kitchenexplore:
    imagemap:
        ground "bg/kitchen.jpg" idle "bg/kitchen.jpg" hover "bg/kitchen.jpg"
        hotspot (812, 322, 62, 48) action Jump("kitchen_microwave")
        hotspot (678, 414, 108, 72) action Jump("kitchen_teapot")
        hotspot (334, 322, 38, 34) action Jump("kitchen_kettle")
        hotspot (883, 217, 140, 234) action Jump("kitchen_fridge")
        hotspot (255, 215, 47, 60) action Jump("kitchen_spoon")
        hotspot (387, 410, 81, 88) action Jump("kitchen_towel")
        hotspot (261, 487, 150, 80) action Jump("kitchen_towel")
        hotspot (0, 242, 68, 82) action Jump("kitchen_utensils")
        hotspot (0, 408, 91, 25) action Jump("kitchen_burner")
        hotspot (177, 371, 35, 26) action Jump("kitchen_pots")
        hotspot (248, 366, 36, 27) action Jump("kitchen_pots")
        hotspot (0, 454, 180, 205) action Jump("kitchen_recycling")
        hotspot (180, 260, 21, 16) action Jump("kitchen_can")
        hotspot (508, 176, 91, 289) action Jump("kitchen_door")
        
    vbox xalign 0.02 yalign 0.01:
        imagebutton idle "gui/donea.png" hover "gui/doneb.png" action Jump("kitchenmenu")
        
label kitchen_explore:
    hide screen kitchen
    show screen kitchenexplore
    " "
    jump kitchen_explore
    
label kitchen_door:
    "This door leads back into the hallway."
    jump kitchen_explore
    
label kitchen_microwave:
    "A microwave. It's very clean. Sophia really keeps things tidy around here."
    jump kitchen_explore
    
label kitchen_teapot:
    "There's hot tea in there. Naoki probably made it."
    jump kitchen_explore
    
label kitchen_kettle:
    "It's just a normal kettle. Nothing suspicious about that."
    jump kitchen_explore
    
label kitchen_fridge:
    "The fridge is pretty well stocked, but it's all pre-packaged food. I guess no one cooks around here."
    jump kitchen_explore
    
label kitchen_spoon:
    "A spoon with a hole in the bottom. Probably not too useful for serving soup, but perfect for straining pasta."
    jump kitchen_explore
    
label kitchen_towel:
    "It's a dish towel. It's about exciting as a limp towel."
    jump kitchen_explore
    
label kitchen_utensils:
    "Some spoons and a spatula. They're all a bit dusty."
    jump kitchen_explore
    
label kitchen_burner:
    "Looks like a gas stove. Commercial grade."
    jump kitchen_explore
    
label kitchen_pots:
    "It's empty."
    jump kitchen_explore
    
label kitchen_can:
    "A small jar of salt. Looking at how large the grains are, I'd guess kosher."
    jump kitchen_explore
    
label kitchen_recycling:
    "There's a recycling bin in here. It's about half full of glass and plastic bottles."
    jump kitchen_explore
    
screen kitchenmove:
    default tt = Tooltip("Kitchen")
    vbox xalign 0.5 yalign 0.0:
        add "gui/movebar.png"
    vbox xalign 0.5 ypos 32:
        text tt.value size 28
        
    vbox xalign 0.59 yalign 0.37:
        imagebutton idle "gui/hallway_arrow03.png" hover "gui/hallway_arrow03b.png" action Jump("hallwayevents") hovered tt.Action("Hallway")
        
label kitchen_move:
    hide screen kitchen
    show screen kitchenmove
    " "
    jump kitchen_move
    
label kitchenmenu:
    hide screen kitchenexplore
    show screen kitchen
    " "
    jump kitchenmenu
    
label kitchenevents:
    hide screen hallwaymove
    scene kitchen with dissolve
    if not sophia_convo01:
        jump sophia01
    jump kitchenmenu
    
#######################################################
##  Back Stairs
            
screen backstairs:
    tag backstairsmenu
    
    vbox xalign 0.02 yalign 0.01:
        imagebutton idle "gui/examinea.png" hover "gui/examineb.png" action Jump("backstairs_explore")
        imagebutton idle "gui/movea.png" hover "gui/moveb.png" action Jump("backstairs_move")
        
screen backstairsexplore:
    imagemap:
        ground "bg/staircase.jpg" idle "bg/staircase.jpg" hover "bg/staircase.jpg"
        hotspot (646, 311, 9, 28) action Jump("backstairs_box")
        hotspot (703, 111, 59, 57) action Jump("backstairs_webs")
        hotspot (618, 274, 26, 118) action Jump("backstairs_door")
        
    vbox xalign 0.02 yalign 0.01:
        imagebutton idle "gui/donea.png" hover "gui/doneb.png" action Jump("backstairsmenu")
        
label backstairs_explore:
    hide screen backstairs
    show screen backstairsexplore
    " "
    jump backstairs_explore
    
label backstairs_box:
    if readbody:
        "A retina scanner. It won't let me pass, since I'm just a guest."
    else:
        "A retina scanner. Sophia changed the settings so that it will unlock the door for me."
    jump backstairs_explore
    
label backstairs_door:
    if readbody:
        "It's locked."
    else:
        "The entrance to the basement."
    jump backstairs_explore
    
label backstairs_webs:
    "Some old cobwebs. Home for rich, reclusive spiders, I guess."
    jump backstairs_explore
    
screen backstairsmove:
    default tt = Tooltip("Staircase")
    vbox xalign 0.5 yalign 0.0:
        add "gui/movebar.png"
    vbox xalign 0.5 ypos 32:
        text tt.value size 28
        
    
    vbox xalign 0.17 yalign 0.3:
        imagebutton idle "gui/lobby_arrow01.png" hover "gui/lobby_arrow01b.png" action Jump("hallwayevents") hovered tt.Action("Hallway")
    vbox xalign 0.68 yalign 0.42:
        imagebutton idle "gui/backstairs_arrow02.png" hover "gui/backstairs_arrow02b.png" action Jump("cellarevents") hovered tt.Action("Cellar")
        
label backstairs_move:
    hide screen backstairs
    show screen backstairsmove
    " "
    jump backstairs_move
    
label backstairsmenu:
    hide screen backstairsexplore
    show screen backstairs
    " "
    jump backstairsmenu
    
label backstairsevents:
    hide screen hallwaymove
    hide screen cellarmove
    scene staircase with dissolve
    jump backstairsmenu
    
#######################################################
##  Cellar

screen cellar:
    tag cellarmenu
    
    vbox xalign 0.02 yalign 0.01:
        imagebutton idle "gui/examinea.png" hover "gui/examineb.png" action Jump("cellar_explore")
        imagebutton idle "gui/movea.png" hover "gui/moveb.png" action Jump("cellar_move")
        
screen cellarmove:
    default tt = Tooltip("Cellar")
    vbox xalign 0.5 yalign 0.0:
        add "gui/movebar.png"
    vbox xalign 0.5 ypos 32:
        text tt.value size 28
        
    vbox xalign 0.97 yalign 0.4:
        imagebutton idle "gui/hallway_arrow01.png" hover "gui/hallway_arrow01b.png" action Jump("backstairsevents") hovered tt.Action("Staircase")

label cellarevents:
    hide screen backstairsmove
    if readbody:
        "It's locked. Guess there's no hope of going in there."
        jump backstairsmenu
    else:
        scene basement b with dissolve
        if not cellar01:
            jump cellar_enter
        jump cellarmenu
        
label cellar_enter:
    $ cellar01 = True
    "The door actually opened! I guess Sophia hasn't changed my permissions from before. Cool."
    jump cellarmenu
    
label cellarmenu:
    hide screen cellarexplore
    show screen cellar
    " "
    jump cellarmenu
    
screen cellarexplore:
    imagemap:
        ground "bg/basement01b.jpg" idle "bg/basement01b.jpg" hover "bg/basement01b.jpg"
        hotspot (561, 264, 126, 148) action Jump("cellar_switchbox")
        hotspot (0, 195, 218, 155) action Jump("cellar_box01")
        hotspot (418, 356, 80, 207) action Jump("cellar_box02")
        hotspot (0, 349, 419, 294) action Jump("cellar_box03")
        hotspot (772, 59, 50, 59) action Jump("cellar_lights")
        
    vbox xalign 0.02 yalign 0.01:
        imagebutton idle "gui/donea.png" hover "gui/doneb.png" action Jump("cellarmenu")
        
label cellar_box01:
    "Hm...nothing in this box."
    jump cellar_explore
    
label cellar_box02:
    if not basementpapers:
        $ basementpapers = True
        hide screen cellarexplore
        "Whoa, this box is full of papers. They all look pretty old."
        "Hm...experiment results? I don't understand what any of this is about."
        "Maybe I should ask someone trustworthy. I'll take a few of these pages and leave the rest here for now."
        show screen cellarexplore
    else:
        "This box has a lot of old papers with data about some experiment. I already have some of them with me. I'll leave the rest here for now."
    jump cellar_explore
    
label cellar_box03:
    "This box is empty..."
    jump cellar_explore
    
label cellar_switchbox:
    "I can turn off the house's power from here. I probably shouldn't, though."
    jump cellar_explore
    
label cellar_lights:
    "The emergency lights. They're not on right now."
    jump cellar_explore
    
label cellar_explore:
    hide screen cellar
    show screen cellarexplore
    " "
    jump cellar_explore
    
label cellar_move:
    hide screen cellar
    show screen cellarmove
    " "
    jump cellar_move
    
#######################################################
##  Bathroom

screen bathroom:
    tag bathroommenu
    
    vbox xalign 0.02 yalign 0.01:
        if marissa_location=="bathroom":
            imagebutton idle "gui/talka_marissa.png" hover "gui/talkb_marissa.png" action Jump("marissa_talk")
        imagebutton idle "gui/examinea.png" hover "gui/examineb.png" action Jump("bathroom_explore")
        imagebutton idle "gui/movea.png" hover "gui/moveb.png" action Jump("bathroom_move")
        
screen bathroommove:
    default tt = Tooltip("Restroom")
    vbox xalign 0.5 yalign 0.0:
        add "gui/movebar.png"
    vbox xalign 0.5 ypos 32:
        text tt.value size 28
        
    vbox xalign 0.03 yalign 0.4:
        imagebutton idle "gui/hallway_arrow02.png" hover "gui/hallway_arrow02b.png" action Jump("hallwayevents") hovered tt.Action("Hallway")
        
screen bathroomexplore:
    imagemap:
        ground "bg/bathroom.jpg" idle "bg/bathroom.jpg" hover "bg/bathroom.jpg"
        hotspot (93, 368, 22, 112) action Jump("bathroom_soap")
        hotspot (38, 143, 51, 47) action Jump("bathroom_lamp")
        hotspot (372, 180, 28, 33) action Jump("bathroom_lamp02")
        hotspot (634, 167, 388, 197) action Jump("bathroom_divider")
        hotspot (809,366,108,160) action Jump("bathroom_lamp03")
        hotspot (755,530,267,237) action Jump("bathroom_chair")
        hotspot(951,440,71,87) action Jump("bathroom_chair")
        hotspot(379,327,91,51) action Jump("bathroom_towels")
        hotspot(89,150,247,214) action Jump("bathroom_mirror")
        hotspot(184,368,119,80) action Jump("bathroom_sink")
        hotspot(321,376,96,38) action Jump("bathroom_sink")
        
    vbox xalign 0.02 yalign 0.01:
        imagebutton idle "gui/donea.png" hover "gui/doneb.png" action Jump("bathroommenu")
        
label bathroom_soap:
    "A soap dispenser. According to the label, it's evergreen scented, but it just smells like soap to me."
    jump bathroom_explore
    
label bathroom_lamp:
    "A lamp. It uses ones of those compact fluorescent light bulbs."
    jump bathroom_explore
    
label bathroom_lamp02:
    "A lamp. The bulb uses a lower wattage than an incandescent bulb. Aki would probably attempt some sort of \"Mr. Watten\" joke at this point."
    jump bathroom_explore
    
label bathroom_lamp03:
    "A lamp. The body is made out of porcelain."
    jump bathroom_explore
    
label bathroom_divider:
    "A bathroom stall with a toilet in it. This place is a lot like a public restroom. I wonder if Mr. Auten used to accept a lot of guests."
    jump bathroom_explore
    
label bathroom_chair:
    "This chair is sadly not as comfortable as it looks."
    jump bathroom_explore
    
label bathroom_towels:
    "I guess you're supposed to dry your hands on these towels. Where exactly am I supposed to put the towel after that?"
    jump bathroom_explore
    
label bathroom_mirror:
    "Hmm...there's a space between the frame and the wall, so it's not a two-way mirror. I can't believe I'm checking for this. Old habits die hard, I guess."
    jump bathroom_explore
    
label bathroom_sink:
    "A sink with a porcelain basin."
    jump bathroom_explore

label bathroomevents:
    hide screen hallwaymove
    scene bathroom with dissolve
    if not bathroomvisit:
        $ bathroomvisit = True
        "Oh. A restroom. Weird. This looks like he built this place with visitors in mind. I wonder what changed."
    if endsoon > 0 and marissa_alone:
        $ endsoon = 1
    if marissa_location == "bathroom" and not mari_convo02:
        jump marissa02
    elif mari_convo02 and not mari_convo03:
        jump marissa03
    jump bathroommenu
    
label bathroommenu:
    hide screen bathroomexplore
    show screen bathroom
    " "
    jump bathroommenu
    
label bathroom_explore:
    hide screen bathroom
    show screen bathroomexplore
    " "
    jump bathroom_explore
    
label bathroom_move:
    hide screen bathroom
    show screen bathroommove
    " "
    jump bathroom_move
                                    
    
    
#######################################################
##  Office   

screen officeexplore:
    imagemap:
        ground "bg/office02.jpg" idle "bg/office02.jpg" hover "bg/office02.jpg"
        hotspot (247, 385, 80, 29) action Jump("office_newspaper")
        hotspot (446, 236, 95, 70) action Jump("office_books")
        hotspot (448, 314, 46, 60) action Jump("office_books")
        hotspot (495, 327, 90, 102) action Jump("office_chair")
        hotspot (640, 361, 48, 32) action Jump("office_phone")
        hotspot(44,40,97,384) action Jump("office_scroll")
        hotspot(192,54,93,321) action Jump("office_scroll")
        hotspot(875,38,95,330) action Jump("office_scroll")
        hotspot(803,369,90,95) action Jump("office_globe")
        hotspot(443,140,334,79) action Jump("office_shelves")
        hotspot(691,220,85,180) action Jump("office_shelves")
        hotspot(620,398,154,138) action Jump("office_drawers")
        hotspot(536,527,115,115) action Jump("office_auten")
        hotspot(652,557,161,123) action Jump("office_auten")
        hotspot(375,301,52,112) action Jump("office_cognac")
        hotspot(427,382,23,35) action Jump("office_cognac")
        hotspot(327,316,47,58) action Jump("office_computer")
        
    vbox xalign 0.02 yalign 0.01:
        imagebutton idle "gui/donea.png" hover "gui/doneb.png" action Jump("afteroffice")
        
label office_explore:
    show screen officeexplore
    " "
    jump office_explore
    
label office_newspaper:
    "Today's newspaper."
    jump office_explore
    
label office_books:
    "A lot of books. I think it's an encyclopedia set."
    jump office_explore
    
label office_chair:
    "A very comfortable looking chair befitting an executive officer."
    jump office_explore
    
label office_phone:
    "A phone that's actually plugged into the wall. I suppose a land line is still more secure and reliable."
    jump office_explore
    
label office_cognac:
    $ cognacfound = True
    "Some sort of alcohol. I'd guess cognac by the color. The ice in the glass hasn't melted yet, which means Mr. Auten was drinking this right before he died. Maybe he was poisoned!"
    jump office_explore
    
label office_scroll:
    "A fancy scroll with Chinese calligraphy on it. I have no idea what it says."
    jump office_explore
    
label office_globe:
    "I wonder why people instinctively search for their home whenever they see a map. Maybe we're searching for a feeling of belonging. Well, I found Edgewater, for what it's worth."
    jump office_explore
    
label office_shelves:
    "A bunch of shelves. It's just Naoki's memory, so I can't see what's inside them."
    jump office_explore
    
label office_drawers:
    "Some drawers. Too bad I can't get a look inside."
    jump office_explore
    
label office_computer:
    "Mr. Auten's computer. The screen is dark."
    jump office_explore
    
label office_auten:
    "If I were in the real office, I'd be able to read Mr. Auten's final moments. Unfortunately, I'm not in the real office. Judging by his skin color, I'd agree with Detective Gurski. This guy was poisoned."
    jump office_explore
