label end_boring:
    $ save_name = "Empty Ending"
    "I pace back and forth in the hallway slowly, attempting to piece together the puzzle."
    "I feel like I'm close to something, but I just can't put my finger on it..."
    play sound "sfx/alarm.ogg"
    "My thoughts are interrupted by the sound of sirens. Looks like the police are finally here."
    "All this investigation, and I still haven't figured out who the killer is?"
    "Oh well. I guess really should just leave it to the professionals. My part in this case is over."
    jump credits

label end_escape:
    $ save_name = "A Sinking Feeling"
    play music "music/darkness.ogg"
    "My stomach lurches as soon as I step into the hallway."
    "Oh no..."
    "I spin around, looking down the stretch of doors, but I don't see anything."
    "What is it? Who..."
    "The bathroom. It has to be in there. I rush to the bathroom door and throw it open."
    scene bathroom02 with dissolve
    #hide screen menubuttons
    $ renpy.pause()
    #show screen menubuttons
    "As soon as I enter the bathroom, my stomach does another flip."
    "This is not the scene I was hoping for..."
    "The mirror in the bathroom has been shattered by a single blow. Lines of red trickle slowly down the glass."
    "A body has been hastily tossed into one of the bathroom stalls. I approach, and recoil at the sight."
    "It's Marissa."
    "Shards of glass are embedded in her forehead, and blood drips slowly down her face."
    "The blood hasn't dried yet. That means she must have died recently."
    "I kneel beside her and touch her hand. As soon as my fingertips touch her palm, my mind is flooded with her final thoughts."
    scene black with dissolve
    "I'm struggling, but whoever is holding me is stronger than I am."
    "I twist around and open my mouth to scream, but I feel my head being forced forward."
    "The last thing I see is my reflection rushing towards me. In the mirror, I see the blur of my assailant reflected as well."
    "Kevin."
    "A sharp pain rips through my head, and then...nothing."
    scene bathroom02 with dissolve
    play music "music/advance.ogg"
    "As soon as I return to reality I stand and run to the lobby."
    scene entrance with dissolve
    $ kan_eb = 5
    $ kan_eyes = 1
    $ kan_mouth = 3
    k "Detective Gurski! Aki!"
    show aki a02 surprised:
        zoom .8 xalign 0.2 ypos 30
    show mikolaj a01 surprised:
        zoom .9 xalign 0.9 ypos 20
    with dissolve
    voice "voice/aki_195.ogg"
    a "Whoa, Kan! What's up?"
    "I stop to catch my breath."
    k "It's Marissa. She's been killed."
    show aki a02 worried with dissolve
    voice "voice/aki_196.ogg"
    a "What?"
    $ kan_eb = 6
    k "In the bathroom! It was-"
    play sound "sfx/alarm.ogg"
    "Our conversation is interrupted by a shrill beeping noise."
    show mikolaj a01 surprised03 with dissolve
    voice "voice/miko_133.ogg"
    m "What IS that?"
    "Upstairs, I hear the pounding of footsteps. Liam races down the stairs, his eyes lit with excitement. Naoki follows behind him, looking confused."
    hide aki
    hide mikolaj
    show liam a01 excited:
        zoom .9 xalign 0.5 ypos 30
    with dissolve
    voice "voice/liam_088.ogg"
    liam "Hey, can we finally go now?"
    show mikolaj a03 glare:
        zoom 0.8 xalign 1.0 yalign 0.0
    voice "voice/miko_134.ogg"
    m "What? No."
    show liam a01 whine with dissolve
    voice "voice/liam_089.ogg"
    liam "But we're coming out of lockdown. That beeping noise means that all the doors are going to be unlocked!"
    show aki a03 worried:
        zoom 0.8 xpos -50 ypos 30
    voice "voice/aki_197.ogg"
    a "Unlocked? Oh no..."
    scene hallway with dissolve
    "We race down the hallway to the security room. The doors hang wide open."
    scene security with dissolve
    "Kevin is nowhere to be seen."
    "Li Mei appears in the doorway. She looks scared."
    show limei a02 scared:
        xalign 0.5 yalign 0.0
    with dissolve
    voice "voice/limei_092.ogg"
    l "Kevin ran out through the museum. I tried to stop him, but he had a knife."
    show limei a01 troubled with dissolve
    voice "voice/limei_093.ogg"
    l "I'm sorry."
    "Aki shakes her head and places a hand on Li Mei's shoulder."
    show aki a03 worried:
        zoom 0.8 xpos -50 ypos -50
    with dissolve
    voice "voice/aki_198.ogg"
    a "No, it's okay. You did the right thing."
    "Even as she says that, her face tightens. She's clearly not happy."
    "Unfortunately, Naoki appears behind Li Mei with more bad news."
    hide aki
    hide limei
    show naoki a02 worried:
        xalign 0.5 yalign 0.0
    with dissolve
    voice "voice/naoki_129.ogg"
    n "Liam's gone, too. He made a bolt for the front door as soon as we turned around. Detective Gurski went after him, but..."
    hide naoki
    show aki a01 angry:
        xalign 0.5 yalign 0.0
    with dissolve
    voice "voice/aki_199.ogg"
    a "Argh!"
    "Aki smashes her fist into the keyboard and I'm fairly certain I hear the sound of plastic snapping."
    voice "voice/aki_200.ogg"
    a "How could we have been so stupid?"
    show naoki a03 worried:
        zoom 0.9 xalign 1.0 yalign 0.0
    with dissolve
    voice "voice/naoki_130.ogg"
    n "Onee..."
    "Naoki watches helplessly while Aki fumes."
    hide naoki with dissolve
    voice "voice/aki_201.ogg"
    a "Stupid, stupid, stupid!"
    $ kan_eyes = 2
    $ kan_mouth = 11
    k "There was nothing we could have done..."
    show aki a01 angry02 with dissolve
    voice "voice/aki_202.ogg"
    a "Nothing? Well, that's not true."
    "Aki snorts through her nose."
    show aki a02 defeated with dissolve
    voice "voice/aki_203.ogg"
    a "We had everything, Kan, but we didn't piece it together fast enough. We should have known, and now look!"
    voice "voice/aki_204.ogg"
    a "Marissa's dead and two of our suspects have run away. Surely we could have stopped at least some of this."
    "Aki sighs, and her shoulders sink."
    voice "voice/aki_205.ogg"
    a "We're going to be in so much trouble. I don't know if..."
    "Her rage has disappeared, replaced by a sense of broken defeat."
    voice "voice/aki_206.ogg"
    a "We're done here. Let's just wait for the police."
    show aki a02 defeated02 with dissolve
    voice "voice/aki_207.ogg"
    a "There's nothing we can do anymore."
    if limei_key:
        $ kan_mouth = 2
        k "Hey, it's not a total loss."
        "I reach into my pocket and run my finger slowly along the edge of the SD card."
        show aki a02 curious with dissolve
        voice "voice/aki_208.ogg"
        a "What are you talking about?"
        $ kan_eb = 1
        k "It's-"
        "I'm interrupted by the sound of sirens."
        voice "voice/aki_209.ogg"
        a "Looks like the police are here."
        "Aki gives me a knowing look."
        show aki a01 neutral with dissolve
        voice "voice/aki_210.ogg"
        v "We'll talk about this later."
    jump credits
    
    
label end_deadkevin:
    k "Let's take this to Detective Gurski."
    "Sophia nods in agreement."
    scene entrance with dissolve
    "The two of us hurry down the hall and into the main lobby where we find Detective Gurski and Aki talking with each other."
    show aki a02 surprised:
        zoom .72 xalign 0.0 yalign 1.0
    show mikolaj a01 surprised:
        zoom .8  xalign 1.06 yalign -0.9
    with dissolve
    voice "voice/aki_211.ogg"
    a "Whoa, you two look like you're in a hurry."
    k "Yeah, I think we have our key piece of evidence!"
    "I hold up the bottle for Detective Gurski and Aki to see."
    show mikolaj a02 surprised02 with dissolve
    voice "voice/miko_135.ogg"
    m "And what is it?"
    show sophia a01 worried:
        zoom .73 xalign 0.45 yalign 1.0
    with dissolve
    voice "voice/sophia_156.ogg"
    s "It's the poison!"
    show sophia a01 evasive with dissolve
    voice "voice/sophia_157.ogg"
    s "Or...what's left of it, at least."
    k "It'll be easier if I just explain to you who did it."
    show aki a01 neutral
    show mikolaj a01 lecturing
    with dissolve
    voice "voice/miko_136.ogg"
    m "Fair enough. So who did it?"
    jump guesskiller
    
label guesskiller:
    menu:
        "Who killed Mr. Auten?"
        "\"It was Mr. Auten.\"" if not guess_auten:
            $ guess_auten = True
            k "It was Mr. Auten."
            voice "voice/miko_137.ogg"
            m "You mean suicide?"
            voice "voice/aki_212.ogg"
            a "Are you sure about that?"
            k "It had to have been. He locked himself in his office, then took some poison."
            voice "voice/miko_138.ogg"
            m "But why? I know I said it was a possibility, but I've gotta be honest - it's not a very big one."
            voice "voice/miko_139.ogg"
            m "Unless you have proof?"
            k "Uh..."
            voice "voice/aki_213.ogg"
            a "Kan, why would he call us here to speak with us, then kill himself?"
            k "Maybe, because..."
            k "..."
            k "Okay, maybe I didn't think this through all the way."
            voice "voice/miko_140.ogg"
            m "I'll say."
        "\"It was Liam.\"" if not guess_liam:
            $ guess_liam = True
            k "It was Liam."
            k "Mr. Auten was going to cut him out of the will, so he killed him before it happened."
            voice "voice/miko_141.ogg"
            m "So there's at least motive. What about means and opportunity?"
            k "He snuck into Mr. Auten's study and poisoned his drink."
            voice "voice/aki_214.ogg"
            a "But how? Liam's not allowed access into the study in the first place. Don't you remember?"
            k "Oh, right."
            voice "voice/miko_142.ogg"
            m "Are you sure you thought this through?"
        "\"It was Kevin.\"":
            k "It was Kevin."
            show aki a02 surprised with dissolve
            voice "voice/aki_215.ogg"
            a "The IT guy?"
            show mikolaj a01 neutral with dissolve
            voice "voice/miko_143.ogg"
            m "But how did he do it?"
            k "He poisoned Mr. Auten's cognac, most likely."
            k "He wanted it to look like someone from the outside poisoned it before it even arrived at the house, so he picked something that Mr. Auten would lock up in the office."
            voice "voice/miko_144.ogg"
            m "How'd he get into the office? I thought no one was allowed in."
            k "That may be true for Sophia and Liam, but Kevin controls all the security in the house."
            k "I bet he has a master code that can open any door."
            voice "voice/miko_145.ogg"
            m "Is that true?"
            voice "voice/sophia_158.ogg"
            s "Yes, he's never used the master code, but it does exist."
            voice "voice/miko_146.ogg"
            m "So he had means and opportunity. What about a motive?"
            menu:
                "Why did he do it?"
                "\"He did it for fun.\"":
                    k "He did it for fun."
                    voice "voice/aki_216.ogg"
                    a "What?"
                    k "He wanted to kill Mr. Auten because he thought it would be fun."
                    voice "voice/miko_147.ogg"
                    m "Well that's not a very strong motive to go off of. Are you sure about that?"
                    k "I guess not..."
                "\"He did it on accident.\"":
                    k "He did it on accident."
                    voice "voice/miko_148.ogg"
                    m "On accident?"
                    k "I don't think he meant to kill Mr. Auten at all."
                    voice "voice/aki_217.ogg"
                    a "There's no way he accidentally snuck into the study and poured poison into his drink."
                    voice "voice/miko_149.ogg"
                    m "This had to have been pre-meditated."
                "\"He did it for revenge.\"":
                    k "He did it for revenge."
                    voice "voice/aki_218.ogg"
                    a "Revenge? For what?"
                    if securitypapers:
                        "I hold up the papers I found in the security room."
                        k "Destroying his family's business, of course."
                        k "We- um...I found these in the security room."
                        "I hand the papers to Detective Gurski and he riffles through them, scanning each page briefly with his eyes."
                        voice "voice/miko_150.ogg"
                        m "What am I looking at?"
                        k "Proof of ownership. Mr. Auten owned quite a few loan agencies under assumed names."
                        k "He gave out student loans to families like Kevin's, then changed the interest rate without warning, putting them into more debt than they could handle."
                        k "The debt that he supposedly rescued Kevin's family from was one that he created himself."
                        voice "voice/aki_219.ogg"
                        a "So Kevin would bear a grudge against Mr. Auten for cheating his family and using him!"
                        voice "voice/miko_151.ogg"
                        m "That's a good enough motive for me, and he's the only person with the means to do it."
                        k "Sophia found this in the incinerator. We think he carried the poison in this bottle and then tried to destroy the evidence."
                        voice "voice/miko_152.ogg"
                        m "Meaning that we'll probably find his fingerprints all over it."
                        stop music
                        play sound "sfx/alarm.ogg"
                        "A frantic beeping noise interrupts our discussion."
                        play music "music/advance.ogg"
                        voice "voice/miko_153.ogg"
                        m "What is that?"
                        voice "voice/sophia_162.ogg"
                        s "The house is coming out of lock down. Kevin must be unlocking all the doors!"
                        "I groan."
                        $ save_name = "Kevin's Escape"
                        k "Of course! He can see us! I'm holding his stupid murder weapon in my hand! He probably knows we've got him figured out."
                        voice "voice/aki_220.ogg"
                        a "But Kevin isn't going to leave through the front. We'd never let him past us."
                        voice "voice/aki_221.ogg"
                        a "Sophia, what other exits are there?"
                        voice "voice/sophia_163.ogg"
                        s "There's an emergency door in the museum-"
                        "Detective Gurski and Aki exchange horrified glances."
                        voice "voice/aki_222.ogg"
                        a "Li Mei!"
                        voice "voice/miko_154.ogg"
                        m "Is there any way to lock all the doors again?"
                        voice "voice/sophia_164.ogg"
                        s "U-um...there's a panic box upstairs that-"
                        voice "voice/miko_155.ogg"
                        m "Don't explain it. Just go!"
                        scene hallway with dissolve
                        "Sophia turns and dashes up the stairs while the rest of us race towards the museum."
                        play sound "sfx/beep.ogg"
                        "Detective Gurski grabs the handle on the door and pulls, but the lock by the door beeps stubbornly."
                        play sound "sfx/knock02.ogg"
                        "He pounds on it with his fist."
                        with hpunch
                        voice "voice/miko_156.ogg"
                        m "Kevin! We know you're in there!"
                        "No response."
                        voice "voice/miko_157.ogg"
                        m "KEVIN!"
                        "Aki glances at Naoki and nods. He nods in return before punching in a string of numbers into the box beside the door."
                        play sound "sfx/beep.ogg"
                        "The box rewards us with a friendly beep and a click."
                        scene museum with hpunch
                        "Detective Gurski kicks the door open, and we rush in."
                        voice "voice/kevin_104.ogg"
                        kev "Don't move!"
                        show end01bg
                        show end01:
                            xalign 0.2 yalign 1.0
                            linear 5.0 xalign 0.65
                        show museumcover
                        with wipedown
                        "Kevin stands across the room from us, one hand firmly on Li Mei's shoulder, and the other holding a knife to her throat."
                        voice "voice/miko_158.ogg"
                        m "Kevin...it's okay."
                        "Detective Gurski holds his hands up for Kevin to see."
                        voice "voice/miko_159.ogg"
                        m "We're just going to talk."
                        voice "voice/kevin_105.ogg"
                        kev "What if I don't want to talk?"
                        "Kevin shakes his head vehemently."
                        voice "voice/kevin_106.ogg"
                        kev "I'm not stupid!"
                        voice "voice/miko_160.ogg"
                        m "No. You're very intelligent. You should know that Sophia's locking the doors, and there's nowhere to go."
                        voice "voice/miko_161.ogg"
                        m "So why don't you just put that knife down and let us talk?"
                        "Kevin's gaze darts back and forth between us and the exit."
                        voice "voice/kevin_107.ogg"
                        kev "Y-you're lying..."
                        "Aki steps forward slowly, hands held into the air."
                        voice "voice/aki_223.ogg"
                        a "Kevin, please. Just let her go."
                        "Kevin's expression softens for a brief moment, but he doesn't release Li Mei."
                        voice "voice/kevin_108.ogg"
                        kev "You think I'm going to give up my only bargaining chip?"
                        "He presses the tip of the knife to Li Mei's neck. A small bead of blood appears where the knife has punctured her skin. It runs down the side of her neck slowly, leaving a single crimson trail on her pale skin."
                        "Li Mei's body shudders, and her eyes grow dull."
                        scene museum
                        show end01bbg
                        show end01blimei:
                            zoom .8 xalign 0.2 yalign 1.0
                            linear 1.0 zoom 1.0 xalign 0.6
                        show end01bkevin:
                            zoom 1.2 xalign 0.8 yalign 1.0
                            linear 1.0 zoom 1.0 xalign 0.4
                        show museumcover
                        with wipedown
                        "In a single, fluid motion, she snatches the knife from Kevin's hand and spins around, pushing him to the ground."
                        "Without hesitation, she raises the knife above her head and sinks the blade into his back."
                        with hpunch
                        voice "voice/kevin_109.ogg"
                        kev "Agh-"
                        "Kevin stares at Li Mei with muted disbelief. His entire body begins to shake, and he collapses to the ground."
                        scene museum bw blur with dissolve
                        play music "music/subterranean.ogg"
                        "Blood pours from his cut, seeping into his clothes and creeping across the floor, and I find myself unable to do anything."
                        "My body is frozen in shock. The world around me is fuzzy. Distant."
                        voice "voice/miko_162.ogg"
                        "I see Detective Gurski kneeling beside Kevin. He's shouting something at Naoki, but I can't understand what he's saying."
                        "Aki rushes forward and wraps her arms around Li Mei. This is the first time I've seen Aki look so frightened..."
                        "Li Mei stares at Kevin's motionless body as if she's never seen him before."
                        "The knife in her hand slips from her fingers and falls to the floor with a dull clatter."
                        "This can't be happening. There's no way this is happening. I can hear my own heart pounding against my ribcage as blood rushes through my head."
                        "The world is starting to grow even fuzzier. I feel ill. I clutch at my stomach and stumble a few paces back."
                        "Kevin is dying, and my kansei is soaking up every moment of it. I struggle to remain standing, but it's useless."
                        scene black with dissolve
                        "As I fall forward, the world around me turns black."
                        $ persistent.kevindead = True
                        jump credits
                    else:
                        $ kan_eyes = 3
                        $ kan_mouth = 11
                        $ kan_eb = 6
                        k "I uh...I don't know."
            $ kan_eyes = 2
            $ kan_mouth = 6
            $ kan_eb = 6
            k "But we have some physical evidence! Sophia and I found it!"
            "Sophia holds up the water bottle for Detective Gurski to inspect."
            k "Sophia found this in the incinerator. We think he carried the poison in this bottle and then tried to destroy the evidence."
            "Detective Gurski leans down to inspect the bottle."
            m "We'll likely find the fingerprints of whoever used this, and we'll be able to test the contents for poison."
            $ kan_mouth = 3
            k "Exactly!"
            m "Well, it's something alright, but without a motive, you can't say for sure that it was Kevin."
            $ kan_mouth = 1
            k "Yeah..."
            m "I think you've done enough. The police should be here soon, so just sit tight until they arrive. We'll get to the bottom of this."
            k "Yeah. Sure."
            "This isn't exactly how I wanted things to end, but at least I managed to find something..."
            jump credits
        "\"It was Sophia.\"" if not guess_sophia:
            $ guess_sophia = True
            k "It was Sophia."
            show sophia a02 surprised with dissolve
            voice "voice/sophia_159.ogg"
            s "What are you talking about?"
            k "You're his personal assistant, which means you had access to his office."
            voice "voice/sophia_160.ogg"
            s "But I don't! Mr. Auten wouldn't even let me enter!"
            k "Yes you do! You got us in earlier, didn't you?"
            voice "voice/miko_163.ogg"
            m "After we reset the power. She wouldn't be able to do it on her own."
            voice "voice/sophia_161.ogg"
            s "And I would never kill Mr. Auten! He was my husband's only chance to live!"
            k "Y-yeah...I guess so, huh?"
            voice "voice/miko_164.ogg"
            m "Are you done with your wild theories yet?"
        "\"It was Marissa.\"" if not guess_marissa:
            $ guess_marissa = True
            k "It was Marissa."
            voice "voice/aki_225.ogg"
            a "The reporter?"
            "Detective Gurski frowns. He doesn't look convinced."
            k "She must have poisoned his drink during their interview!"
            voice "voice/aki_226.ogg"
            a "When? He was speaking with her the entire time. She wouldn't have gotten the chance to do anything."
            k "Oh, right. Hm..."
    jump guesskiller
    
label end_solvecase:
    $ save_name = "Kevin's Threat"
    "As soon as I touch the SD card, I hear a series of high pitched beeps."
    hide cg03 with dissolve
    play sound "sfx/alarm.ogg"
    play music "music/advance.ogg"
    $ kan_eb = 6
    $ kan_eyes = 2
    $ kan_mouth = 11
    k "Uh oh."
    hide limei
    show kevin a02 surprised:
        xalign 0.5 yalign 0.0
    with dissolve
    "The door bursts open and Kevin rushes in."
    "I grab the SD card and stuff it into my back pocket before whirling around to face him."
    "Kevin slams the door shut and spins around, jumping in surprise as soon as he sees me."
    voice "voice/kevin_110.ogg"
    kev "Since when-?"
    "He glances up at the camera mounted on the ceiling and lets out a frustrated sigh."
    show kevin a01 annoyed with dissolve
    voice "voice/kevin_111.ogg"
    kev "Right."
    "Li Mei touches my arm gently and whispers."
    show limei a03 evasive:
        zoom 0.8 xalign 0.0 ypos -80
    with dissolve
    voice "voice/limei_094.ogg"
    l "He's panicking."
    hide limei with dissolve
    k "Kevin...what's going on? What's all the beeping for?"
    "I take a step towards him, but he reaches into his back pocket and pulls out a knife."
    show kevin a02 angry with dissolve
    voice "voice/kevin_112.ogg"
    kev "Stay there!"
    "He rushes past me, keeping the knife pointed at my throat. With his free hand, he grabs Li Mei and pulls her towards himself with a rough tug."
    scene museum
    show end01bg
    show end01:
        xalign 0.2 yalign 1.0
        linear 5.0 xalign 0.65
    show museumcover
    with vpunch
    $ kan_mouth = 3
    k "What are you doing?"
    "I move slowly away from Kevin, never taking my eyes off of him."
    voice "voice/kevin_113.ogg"
    kev "I have to get out of here."
    $ kan_mouth = 1
    k "The door's locked."
    voice "voice/kevin_114.ogg"
    kev "Not for long."
    "He laughs, but it sounds more like a pained wheeze."
    voice "voice/kevin_115.ogg"
    kev "We're coming out of a lock down. In a few seconds, the doors will unlock, and I'll be home free."
    "Something in my brain clicks."
    $ kan_eb = 5
    $ kan_eyes = 1
    $ kan_mouth = 11
    k "You're the one who poisoned Mr. Auten! You're the only one who could have!"
    "Kevin laughs, a strange mix of fear and derision."
    voice "voice/kevin_116.ogg"
    kev "Yeah, you're kinda slow to the party. Your friends already figured that out."
    "He waves the knife at me again, but I don't move."
    voice "voice/aki_227.ogg"
    v "Kan! Kevin is the murderer!"
    "Despite my current predicament, I find myself rolling my eyes."
    "This information would have been a lot more useful about ten seconds ago..."
    voice "voice/aki_228.ogg"
    v "Hang in there! We're coming to get you."
    $ kan_mouth = 2
    $ kan_eyes = 2
    $ kan_eb = 6
    k "Kevin. Dude. Why?"
    voice "voice/kevin_117.ogg"
    kev "WHY? Are you kidding?"
    "He moves towards the exit as quickly as he can, but Li Mei isn't cooperating. Her body hangs limp, and he's forced to drag her towards the door."
    voice "voice/kevin_118.ogg"
    kev "He took advantage of my family. He ruined their lives, and it's my fault. I had to-"
    $ kan_eb = 3
    $ kan_mouth = 5
    k "No, you didn't!"
    k "You're so short sighted! Did you even think any of this through at all?"
    play sound "sfx/knock02.ogg"
    "We're interrupted by a pounding on the door."
    with hpunch
    voice "voice/miko_165.ogg"
    m "Kevin! Kevin, we know you're in there!"
    "Kevin puts his finger to his lips, motioning for the two of us to be silent."
    $ kan_mouth = 11
    k "Detective! He has a knife, and he's got Li Mei!"
    "Kevin glares at me. The pounding on the door stops. Did they give up?"
    "I hear a soft beeping noise. Sounds like they're trying to override the retina detector. I don't think Kevin's noticed, yet."
    "Kevin moves slowly towards the exit, eyes darting between me and the door. I move towards Kevin, but his grip on Li Mei tightens."
    voice "voice/limei_095.ogg"
    l "Kangai, don't."
    "Li Mei's voice is only a whisper, but the fear in her eyes looks more like concern for me than for her own well being."
    "Kevin stumbles a few paces back, dragging Li Mei along with him. He's already breathing heavily. It's obvious he's not used to anything physically strenuous."
    "Still, the look in his eyes promises that he's not going down without at least attempting to put that knife in someone's chest."
    "I take a step forward, and he moves one step towards the exit."
    "I take another step forward and Kevin swings the knife at me. It whistles through the air, and I try to jump out of the way."
    "My ankle twists under my weight, and I stumble forward."
    $ kan_eb = 6
    k "Agh-"
    if miko_trust > 33:
        voice "voice/miko_166.ogg"
        m "Alex!"
    with hpunch
    "The door bursts open, but Detective Gurski and Aki freeze as soon as they see the situation."
    $ kan_eb = 2
    $ kan_mouth = 2
    k "I'm fine..."
    "I hold my hand up, motioning for Gurski and Aki to stay at a distance."
    "I switch my gaze back and forth between Kevin's eyes and the knife in his hand. There's got to be an opening..."
    "Detective Gurski and Aki still stand in the doorway, not daring to move. Kevin keeps his knife trained on me."
    "Out of the corner of my eye, I see Aki blink."
    "Suddenly, Kevin's body shivers. He looks around wildly, as if he's in a daze, and the hand holding the knife goes limp."
    scene end02bg
    play sound "sfx/punch.ogg"
    show end02kevin:
        xalign 0.1 yalign 1.0 zoom 1.0
        linear 2.5 xalign -0.1 yalign 1.05 zoom 0.95
    show end02kan:
        zoom 1.1 xalign 1.4 yalign 0.0
        linear 0.5 zoom 1.0 xalign 1.0 yalign 0.9
    show white:
        alpha 0.0
        linear 0.1 alpha 1.0
        linear 0.1 alpha 0.0
    with hpunch
    voice "voice/kevin_119.ogg"
    kev "Agh-!"
    "Without hesitation, I race forward and swing my arm."
    "My fist meets his face, and he stumbles back."
    "He drops the knife, and it falls to the ground with a clatter."
    "Detective Gurski moves in quickly, grabbing Kevin's free hand and expertly twisting his arm behind his back."
    stop music fadeout 1.0
    "He gives me a grudging smile."
    scene museum
    show mikolaj a02 smirk:
        xalign 0.5 yalign 0.0
    with dissolve
    voice "voice/miko_167.ogg"
    m "Not bad, kid."
    "I release Kevin and allow Gurski to take over."
    play music "music/dialogue.ogg"
    hide mikolaj
    show limei a02 worried:
        xalign 0.5 yalign 0.0
    with dissolve
    "As soon as I do, Li Mei runs to me and takes my hand."
    "I look down at her and give her a reassuring smile."
    $ kan_eb = 1
    $ kan_eyes = 2
    $ kan_mouth = 2
    k "It's okay. Kevin won't hurt you anymore."
    show limei a02 worried02 with dissolve
    "She smiles back at me. She looks grateful, but there's something about her eyes that still reflects fear."
    "She's not afraid of Kevin, though. So..."
    "Before I can ask, she gives my hand a small squeeze."
    show limei a01 happy with dissolve
    voice "voice/limei_096.ogg"
    l "Thank you."
    "Out of the corner of my eye, I see Aki watching the scene with a satisfied look in her eyes."
    hide limei
    show aki a01 smirk:
        xalign 0.5 yalign 0.0
    with dissolve
    "I approach her and lean casually against the wall beside her."
    $ kan_eyes = 3
    $ kan_eb = 5
    $ kan_mouth = 7
    k "So...that little panic attack that Kevin had just a moment ago..."
    show aki a01 grin with dissolve
    voice "voice/aki_229.ogg"
    v "You can thank me later."
    "She flashes her usual confident smile."
    $ kan_mouth = 1
    $ kan_eyes = 2
    $ kan_eb = 1
    k "You know, you blink every time you do it. Not very subtle."
    "I poke her arm, as if somehow that will help me get my point across. I'm not sure why I'm teasing her. I guess I'm curious to see her reaction."
    show aki a02 casual with dissolve
    voice "voice/aki_230.ogg"
    a "And you pass out every time you use your kansei."
    $ kan_mouth = 6
    $ kan_eyes = 6
    k "Okay, you have a point."
    show aki a02 neutral with dissolve
    voice "voice/aki_231.ogg"
    a "I could teach you how to control it, if you want. How to stay conscious."
    voice "voice/aki_232.ogg"
    a "It'll take a while for you to get it right, but I get the feeling you'll be stuck with us for a while."
    "She leans against the wall next to me. Her smile is softer now. More genuine."
    show aki a01 friendly with dissolve
    voice "voice/aki_233.ogg"
    a "I hope you don't mind."
    "I laugh and shake my head."
    $ kan_eyes = 2
    $ kan_mouth = 1
    k "No, I don't mind."
    "I tilt my head back and gaze thoughtfully at the ceiling."
    "After all these years of running, it might be nice to finally take a break."
    $ persistent.goodend = True
    $ ending = "goodend"
    jump credits
    
label credits:
    window hide
    $ HideInterface()
    play music "music/sneaking.ogg"
    scene black with fade
    show credits "Produced by sakevisual":
        xalign .16 yalign .5
    with dissolve
    $ renpy.pause(.7)
    hide credits with dissolve
    show guimiko:
        xalign 0.95 yalign 1.0 alpha 0.0
        linear 2.0 alpha 1.0
        pause 3.0
        linear 2.0 alpha 0.0
    show guiaki:
        xalign 0.95 yalign 1.0 alpha 0.0
        pause 5.0
        linear 2.0 alpha 1.0
        pause 3.0
        linear 2.0 alpha 0.0
    show guinaoki:
        xalign 0.95 yalign 1.0 alpha 0.0
        pause 10.0
        linear 2.0 alpha 1.0
        pause 3.0
        linear 2.0 alpha 0.0
    show guilimei:
        xalign 0.95 yalign 1.0 alpha 0.0
        pause 15.0
        linear 2.0 alpha 1.0
        pause 3.0
        linear 2.0 alpha 0.0
    show credits "Scenario, Programming:\n {size=28}Ayu Sakata{/size}\n\nArt, Character Design:\n {size=28}M. Beatriz Garcia{/size}\n\nMusic Composition:\n {size=28}Marc Conrad Tabula{/size}\n\nCast:\n{size=28} Girl...................................Mindy Owen\n Aki........................................Apphia Yu\n Naoki............................Micah Solusod\n Li Mei............................Cherami Leigh\n Sophia.........................Karen Hayman\n Marissa...............Melissa D. Johnson\n Mr. Auten....................R Bruce Elliott\n Liam......................................Matt Alan\n Kevin...........................Zach Holzman\n Chance........................Kira Buckland{/size}\n\nOpening Song:\n{size=28} \"Escape\" by Aural Wave{/size}\n\nEnvironment Art:\n {size=28}Sandra Lane{/size}\n\nProofreading:\n {size=28}Dennis Elliot{/size}\n\nPowered by Ren'py\n\nThank you for playing!":
        xpos 0.05 ypos 768
        linear 22 ypos -1200
    $ renpy.pause(22)
    hide credits
    with dissolve
    #$ _window_during_transitions = True
    #show screen menubuttons
    window show
    if ending =="vault":
        call end_vault from _call_end_vault
    elif ending == "goodend":
        call end_debrief from _call_end_debrief
    return
    
label end_debrief:
    $ save_name = "Aftermath"
    scene apartment with dissolve
    play music "music/dialogue02.ogg"
    "The trip to the Auten estate was only yesterday, but somehow it feels like it's been longer than that."
    "Maybe it was the hours of interrogation from the police that came after Aki and Detective Gurski solved the case."
    "Or maybe it was the uncomfortable atmosphere when Aki and Detective Gurski actually had to share credit for solving the case."
    "Maybe it's just the strange feeling of nostalgia. Everything felt so familiar - piecing together people's lives, the adrenaline rush..."
    "It's the first time I've felt real in three years."
    show aki a01 casual:
        xalign 0.5 yalign 0.0
    with dissolve
    voice "voice/aki_234.ogg"
    a "Hopefully today isn't as eventful as yesterday."
    "Aki stretches and throws herself on the couch."
    show aki a02 grin with dissolve
    voice "voice/aki_235.ogg"
    a "I feel like celebrating our mission accomplished by doing absolutely nothing."
    $ kan_eb = 4
    $ kan_eyes = 2
    $ kan_mouth = 1
    k "Mission accomplished? But your client is dead."
    show aki a01 apologetic with dissolve
    voice "voice/aki_236.ogg"
    a "Huh, good point."
    show aki a01 casual with dissolve
    voice "voice/aki_237.ogg"
    a "Well, either way, we don't have any work today. We might as well enjoy it."
    "The words have barely escaped Aki's lips when there's a firm knock at the door. Aki looks at Li Mei."
    "The petite girl runs to the door and stands on her toes to peer through the eyehole."
    "When she turns around, she doesn't look pleased."
    show aki a01 evasive:
        zoom 0.8 xalign 0.1 ypos 30
    show limei a02 displeased:
        zoom 0.8 xalign 0.8 ypos 60
    with dissolve
    voice "voice/limei_097.ogg"
    l "Detective."
    show aki a01 rolleyes with dissolve
    voice "voice/aki_238.ogg"
    a "Great."
    "Aki takes her time unlocking the door. Finally, she makes a great show of opening it."
    hide limei
    show mikolaj a01 neutral:
        zoom 0.9 xalign 1.0 ypos 20
    show aki a01 innocent
    with dissolve
    voice "voice/aki_239.ogg"
    a "Well, hello, Miko. What brings you to this corner of the world?"
    show mikolaj a01 smirk with dissolve
    voice "voice/miko_169.ogg"
    m "Oh, I don't know. I guess I just assumed that you'd want to know what happened with Kevin."
    show aki a01 neutral with dissolve
    $ kan_eb = 5
    $ kan_mouth = 2
    k "What happened?"
    show mikolaj a01 neutral with dissolve
    voice "voice/miko_170.ogg"
    m "We found his prints on the bottle that Sophia brought us."
    voice "voice/miko_171.ogg"
    m "Once we showed him, he pled guilty. He added liquid nicotine to Mr. Auten's cognac and simply waited for him to drink it."
    show mikolaj a01 lecturing with dissolve
    voice "voice/miko_172.ogg"
    m "When you showed up that day, Mr. Auten had a panic attack, and he went to the bottle for comfort. It wound up killing him instead."
    hide aki
    show naoki a01 blunt:
        zoom 0.8 xalign 0.1 ypos 50
    with dissolve
    voice "voice/naoki_136.ogg"
    n "What's going to happen to Mr. Auten's estate, now?"
    show mikolaj a02 worried with dissolve
    voice "voice/miko_173.ogg"
    m "Hard to say. Technically, it belongs to Liam, but we're having trouble finding him."
    k "Why? Where'd he go?"
    show mikolaj a01 neutral with dissolve
    voice "voice/miko_174.ogg"
    m "He ran off during all the confusion. Guess he didn't want to be arrested for his own crimes."
    "Aki looks severely displeased."
    hide naoki
    show aki a01 glare:
        zoom 0.8 xalign 0.1 ypos 50
    with dissolve
    voice "voice/aki_240.ogg"
    a "So he's still out there somewhere?"
    show mikolaj a01 lecturing with dissolve
    voice "voice/miko_175.ogg"
    m "Don't worry. We'll find him."
    "He smiles pointedly at Aki."
    show mikolaj a01 smirk with dissolve
    voice "voice/miko_176.ogg"
    m "We always do."
    "She flashes him her trademark grin."
    show aki a01 grin with dissolve
    voice "voice/aki_241.ogg"
    a "You don't have to tell me, Officer."
    "Gurski laughs."
    voice "voice/miko_177.ogg"
    m "Well, I'll be seeing you kids around. Try to stay out of trouble, okay?"
    show aki a01 happy with dissolve
    voice "voice/aki_242.ogg"
    a "Anything you say, sir."
    "From the smile on Aki's face, I get the feeling that's not a pledge we're going to be able to keep."
    "Then again, looking at Gurski's expression, I'm fairly certain he doesn't expect us to keep it, either."
    "Staying here might not be so bad after all. For the first time in a long time, I'm looking forward to what tomorrow will bring."
    #hide screen menubuttons
    scene black with dissolve
    centered "Well done! You solved the case!"
    centered "You've also unlocked some bonus content as a reward for your hard work."
    centered "Check the main menu screen to see what you've unlocked!"
    return
    
label end_sophialiam:
    $ save_name = "Sophia Trapped"
    "Li Mei is standing outside the security room, eyes shut and hand pressed against the door."
    "As soon as she hears me, she looks up. Her eyes are wide with fear."
    show limei a01 thinking:
        xalign 0.5 yalign 0.0
    with dissolve
    $ kan_eb = 5
    $ kan_mouth = 2
    $ kan_eyes = 1
    k "What's wrong?"
    show limei a01 worried with dissolve
    voice "voice/limei_098.ogg"
    l "Sophia is in here. She is scared."
    k "What happened?"
    voice "voice/limei_099.ogg"
    l "I don't know."
    "I grab the door handle and pull. The door doesn't budge."
    $ kan_eb = 1
    k "Go get Aki."
    "Li Mei nods and runs down the hallway."
    hide limei with dissolve
    $ kan_mouth = 3
    k "Sophia! Sophia, are you in there?"
    "I pound on the door, hoping for a response."
    show kevin a01 panic:
        zoom 0.9 xalign 0.5 yalign 0.0
    with dissolve
    voice "voice/kevin_120.ogg"
    kev "Kangai!"
    "Kevin rushes up to me. He looks out of breath."
    $ kan_mouth = 1
    $ kan_eb = 5
    $ kan_eyes = 1
    k "What's going on?"
    voice "voice/kevin_121.ogg"
    kev "It's Liam! He went nuts and tried to kill us both!"
    $ kan_mouth = 2
    k "Both?"
    voice "voice/kevin_122.ogg"
    kev "Sophia's in there. He locked her in there, and she's hurt! I can't-"
    "He pauses for another breath."
    show kevin a02 panic with dissolve
    voice "voice/kevin_123.ogg"
    kev "I can't open it without your help. The basement downstairs. You've gotta turn off the power!"
    $ kan_eb = 1
    $ kan_eyes = 2
    k "Sure."
    scene basement b with dissolve
    "I turn and race towards the basement. I pause for a second to let my eyes adjust to the dim lighting before I open the switch box."
    "As I open the panel, the basement door slams shut behind me."
    "I run towards the door and pull on the handle, but it doesn't budge."
    $ kan_eb =6
    $ kan_mouth = 3
    k "Kevin! Kevin, what's going on?"
    "I pound on the door with my fists, hoping to attract someone's attention."
    $ kan_eyes = 1
    k "Hey, I'm trapped down here! I'm in the basement!"
    "I press my ear against the door, but I can't hear anything outside."
    "I grab the handle and pull it again, but the door doesn't even budge."
    "Again, I slam my fist into the door, but it's useless."
    k "HEY! SOMEONE LET ME OUT!"
    "I have to get everyone's attention somehow."
    scene basement dark with dissolve
    "I run back to the circuit box and flip all the switches. The lights in the basement immediately shut off."
    "I stand in the dark room, straining to hear something, anything."
    "Any clue that someone knows I'm down here. I hear some shouting, but it's so muffled that I can't even tell who's speaking."
    voice "voice/aki_243.ogg"
    v "Kan, turn the power back on. I'm sending Naoki to get you."
    scene basement b with dissolve
    "With a sigh of relief, I turn the power back on. Looks like my message was received after all."
    "I hear a beeping noise, and the basement door slides open."
    scene hallway
    show naoki a02 surprised:
        xalign 0.5 yalign 0.0
    with dissolve
    "I stumble out and nearly run in to Naoki."
    k "What happened to Kevin?"
    show naoki a02 nervous with dissolve
    voice "voice/naoki_131.ogg"
    n "Um...he's gone."
    k "What?"
    "Naoki looks at me apologetically."
    voice "voice/naoki_132.ogg"
    n "All the doors in the house unlocked. Kevin and Liam are both gone."
    k "And Sophia..?"
    show naoki a02 worried with dissolve
    voice "voice/naoki_133.ogg"
    n "She's not doing well. Someone hit her on the head pretty hard. Aki's trying to stop the bleeding, but..."
    k "I'm sorry. I could have stopped this. I should have stopped this."
    show naoki a01 sad with dissolve
    voice "voice/naoki_134.ogg"
    n "It's not your fault. You can't blame yourself for the actions of others."
    k "So what now?"
    "Naoki sighs and turns slowly."
    voice "voice/naoki_135.ogg"
    n "Wait for the police to show up, I guess."
    "I watch him trudge up the stairs, and I follow reluctantly."
    "He's right. There's nothing else I can do now."
    jump credits

label end_vault:
    $ save_name = "What the Card Holds"
    scene apartment with fade
    play music "music/dialogue02.ogg" fadein 1.0
    "As soon as we arrive back at the apartment, Aki locks the front door and turns to face Li Mei and I."
    show aki a02 excited:
        xalign 0.5 yalign 0.0
    with dissolve
    voice "voice/aki_244.ogg"
    a "So? Did you find anything?"
    $ kan_eb = 6
    $ kan_eyes = 2
    $ kan_mouth = 11
    k "Well, yeah...but I'm not exactly sure what it is."
    "I pull out the SD card from my back pocket."
    show aki a02 surprised:
        zoom .75 xalign 0.2 yalign 1.0
    show naoki a02 surprised03:
        zoom .75 xalign 0.8 yalign 1.0
    with dissolve
    voice "voice/naoki_137.ogg"
    n "Where did you find that?"
    $ kan_eb = 1
    $ kan_mouth = 1
    k "The museum. Mr. Auten went to great lengths to keep this hidden."
    show aki a01 grin with dissolve
    voice "voice/aki_245.ogg"
    a "Then we'd better have a look at it!"
    $ kan_eb = 6
    $ kan_eyes = 3
    $ kan_mouth = 8
    k "I don't know...don't you think we should hand this over to Detective Gurski?"
    show aki a01 surprised with dissolve
    voice "voice/aki_246.ogg"
    a "Why would we do that?"
    show aki a01 smirk with dissolve
    voice "voice/aki_247.ogg"
    a "If it's important, we'll let him know about it eventually."
    show aki a01 casual with dissolve
    voice "voice/aki_248.ogg"
    a "Besides, it's not like the police would have found that, anyway, so they're not missing out on anything."
    k "Um...I guess so..."
    show aki a02 smirk with dissolve
    voice "voice/aki_249.ogg"
    a "So what are we waiting for? Let's have a look at this!"
    scene end03bg
    show end03limei:
        zoom 0.95 xalign 1.0 yalign 1.0
        linear 1.0 zoom 1.0 xalign 0.9
    show end03aki:
        zoom 0.95 xalign 1.3 yalign 1.0
        linear 1.0 zoom 1.0 xalign 1.0
    show end03kan:
        zoom 1.05 xalign 0.1 yalign 1.0
        linear 1.0 zoom 1.0 xalign 0.3
    show end03naoki:
        zoom 1.1 xalign -0.3 yalign 1.0
        linear 1.0 zoom 1.0 xalign 0.0
    show end03comp:
        xalign 1.0 yalign 1.4
        linear 1.0 yalign 1.0
    with dissolve
    play music "music/subterranean.ogg"
    "She pops the SD card into their computer and we wait patiently for the data to load."
    "I click through the files quickly, and we scan the contents of each one as they load."
    "Most of it looks like little more than complicated formulas and diagrams to me. Something about breaking down certain types of tissue, it seems."
    voice "voice/naoki_138.ogg"
    n "A lot of this is pretty complicated stuff."
    voice "voice/aki_250.ogg"
    a "No kidding. It looks like Mr. Auten's been working on some sort of secret project for quite some time."
    "Suddenly, things start to fall into place. His office was private so that no one would see him working!"
    "When he was done, he'd hide his progress in the vault in the museum. No one would even guess anything was there."
    "Whatever this project was, it must have meant a lot to him."
    voice "voice/aki_251.ogg"
    a "Oh hey, a video file."
    "I double click, and the file pops open."
    "A pixellated video fills the screen."
    voice "voice/aki_252.ogg"
    a "Wow. Lousy camera quality..."
    "Aki frowns and resizes the video, but it doesn't do much to improve the quality."
    "From what I can make out, the video appears to be of a young man walking down a bare, white, hallway."
    voice "voice/naoki_139.ogg"
    n "Where was this taken?"
    voice "voice/aki_253.ogg"
    a "It looks like security camera footage. The angle is very high."
    voice "voice/naoki_140.ogg"
    n "So Mr. Auten was spying on someone? That's creepy."
    "The video zooms in on the young man's face, and an uneasy feeling settles in my stomach."
    n "..."
    "Aki stares at the screen, then back at me."
    voice "voice/aki_254.ogg"
    a "Kan...this guy in the video..."
    voice "voice/aki_255.ogg"
    a "That's you."
    $ persistent.sdcard = True
    return
