label limeiprocess:
    hide screen omake
    scene limei01
    $ renpy.pause()
    scene limei02
    $ renpy.pause()
    scene limei03
    $ renpy.pause()
    scene limei04
    $ renpy.pause()
    return

init python:

        # Construct a new gallery object.
        gg = Gallery()
        
        gg.idle_border = "gui/gallerythumb_idle.png"
        gg.hover_border = "gui/gallerythumb_hover.png"
        gg.locked_button = "gui/gallerythumb_locked.png"
        
        gg.button("cg01button")
        gg.condition("persistent.cg01")
        gg.image("cg/cg01full.jpg")
        
        gg.button("cg02button")
        gg.condition("persistent.puzzlebox")
        gg.image("cg/cg03full.jpg")
        gg.image("cg/cg03bfull.jpg")
        gg.image("cg/cg03cfull.jpg")
        
        gg.button("cg04button")
        gg.condition("persistent.liamtrip")
        gg.image("cg/cg04full.jpg")
        
        gg.button("cg05button")
        gg.condition("persistent.clue")
        gg.image("cg/cluefull.jpg")
        
        gg.button("cg06button")
        gg.condition("persistent.kevindead")
        gg.image("cg/end01full.jpg")
        
        gg.button("cg07button")
        gg.condition("persistent.kevindead")
        gg.image("cg/end01bfull.jpg")
        
        gg.button("cg08button")
        gg.condition("persistent.sdcard")
        gg.image("cg/end03cgfull.jpg")
        
        gg.button("cg09button")
        gg.condition("persistent.goodend")
        gg.image("cg/end02full.jpg")
        
        gg.button("cg10button")
        gg.condition("persistent.epilogue")
        gg.image("cg/epiloguefull.jpg")
        
        
        gg.button("sketch01button")
        gg.condition("persistent.sdcard")
        gg.image("extra/castsketches.jpg")
        
        gg.button("sketch02button")
        gg.condition("persistent.kevindead")
        gg.image("extra/newsketches.jpg")
        
        gg.button("sketch03button")
        gg.condition("persistent.goodend")
        gg.image("extra/kanstyle.jpg")
        
        gg.button("extra/chibis_thumb.jpg")
        gg.condition("persistent.goodend")
        gg.image("extra/chibis.jpg")
        
        
screen gallery:

    # Ensure this replaces the main menu.
    tag menu

    # The background.
    add "gui/menubg02.jpg"

    # A grid of buttons.
    grid 3 4:
        xsize 650
        ysize 740
        xfill True
        yfill True
        xalign 0.1
        yalign 0.0

        # Call make_button to show a particular button.
        add gg.make_button("cg01button", "cg/cg01full_thumb.jpg", xalign=0.5, yalign=0.5, xsize=208, ysize=158)
        add gg.make_button("cg02button", "cg/cg03full_thumb.jpg", xalign=0.5, yalign=0.5, xsize=208, ysize=158)
        add gg.make_button("cg04button", "cg/cg04full_thumb.jpg", xalign=0.5, yalign=0.5, xsize=208, ysize=158)
        
        add gg.make_button("cg05button", "cg/cluefull_thumb.jpg", xalign=0.5, yalign=0.5, xsize=208, ysize=158)
        add gg.make_button("cg06button", "cg/end01full_thumb.jpg", xalign=0.5, yalign=0.5, xsize=208, ysize=158)
        add gg.make_button("cg07button", "cg/end01bfull_thumb.jpg", xalign=0.5, yalign=0.5, xsize=208, ysize=158)
        
        add gg.make_button("cg08button", "cg/end03cgfull_thumb.jpg", xalign=0.5, yalign=0.5, xsize=208, ysize=158)
        add gg.make_button("cg09button", "cg/end02full_thumb.jpg", xalign=0.5, yalign=0.5, xsize=208, ysize=158)
        add gg.make_button("cg10button", "cg/epiloguefull_thumb.jpg", xalign=0.5, yalign=0.5, xsize=208, ysize=158)
        
        add gg.make_button("sketch01button", "extra/castsketches_thumb.jpg", xalign=0.5, yalign=0.5, xsize=208, ysize=158)
        add gg.make_button("sketch02button", "extra/newsketches_thumb.jpg", xalign=0.5, yalign=0.5, xsize=208, ysize=158)
        add gg.make_button("sketch03button", "extra/kanstyle_thumb.jpg", xalign=0.5, yalign=0.5, xsize=208, ysize=158)


    textbutton "Return" action Return() background "gui/mainmenubulletidle.png" hover_background "gui/mainmenubullet.png" left_padding 65 top_padding 10 text_color "#ffffff" xalign 0.9 yalign 0.1

        
init python:

    # Step 1. Create a MusicRoom instance.
    mr = MusicRoom(fadeout=1.0)

    # Step 2. Add music files.
    mr.add("music/suspicions02.ogg", always_unlocked=True)
    mr.add("music/dialogue.ogg")
    mr.add("music/ritzy.ogg")
    mr.add("music/sneaking.ogg")
    mr.add("music/subterranean.ogg")
    mr.add("music/dialogue02.ogg")
    mr.add("music/darkness.ogg")
    mr.add("music/advance.ogg")


# Step 3. Create the music room screen.
screen music_room:

    tag menu
    
    add "gui/musicroom.jpg"
    
    imagebutton idle "gui/music_pause_idle.jpg" hover "gui/music_pause_hover.jpg" selected_idle "gui/music_play_idle.jpg" selected_hover "gui/music_play_hover.jpg" action PauseAudio("music", value="toggle") xpos 135 ypos 550
    bar value AudioPositionValue(channel='music', update_interval=0.1) left_gutter 13 right_gutter 0 thumb None xmaximum 310 left_bar "gui/music_bar_left.jpg" right_bar "gui/music_bar_right.jpg" xpos 170 ypos 550
        
    
    hbox:
        
        xalign 0.2
        yalign 0.5
        
        spacing 10

        vbox:
        
            spacing 10

            # The buttons that play each track.
            textbutton "Suspicions II" action mr.Play("music/suspicions02.ogg") background Frame("gui/minibar.png",16,16) hover_background Frame("gui/minibar_b.png",16,16) insensitive_background Frame("gui/minibar_c.png",16,16) xsize 180
            textbutton "Dialogue" action mr.Play("music/dialogue.ogg") background Frame("gui/minibar.png",16,16) hover_background Frame("gui/minibar_b.png",16,16) insensitive_background Frame("gui/minibar_c.png",16,16) xsize 180
            textbutton "Ritzy" action mr.Play("music/ritzy.ogg") background Frame("gui/minibar.png",16,16) hover_background Frame("gui/minibar_b.png",16,16) insensitive_background Frame("gui/minibar_c.png",16,16) xsize 180
            textbutton "Sneaking" action mr.Play("music/sneaking.ogg") background Frame("gui/minibar.png",16,16) hover_background Frame("gui/minibar_b.png",16,16) insensitive_background Frame("gui/minibar_c.png",16,16) xsize 180
            
        vbox:
            spacing 10
            textbutton "Subterranean" action mr.Play("music/subterranean.ogg") background Frame("gui/minibar.png",16,16) hover_background Frame("gui/minibar_b.png",16,16) insensitive_background Frame("gui/minibar_c.png",16,16) xsize 180
            textbutton "Dialogue II" action mr.Play("music/dialogue02.ogg") background Frame("gui/minibar.png",16,16) hover_background Frame("gui/minibar_b.png",16,16) insensitive_background Frame("gui/minibar_c.png",16,16) xsize 180
            textbutton "Darkness" action mr.Play("music/darkness.ogg") background Frame("gui/minibar.png",16,16) hover_background Frame("gui/minibar_b.png",16,16) insensitive_background Frame("gui/minibar_c.png",16,16) xsize 180
            textbutton "Advance" action mr.Play("music/advance.ogg") background Frame("gui/minibar.png",16,16) hover_background Frame("gui/minibar_b.png",16,16) insensitive_background Frame("gui/minibar_c.png",16,16) xsize 180
 
        null height 20


        null height 20

        # The button that lets the user exit the music room.
    textbutton "Return" action Return() xalign 0.02 yalign 0.95 background "gui/mainmenubulletidle.png" hover_background "gui/mainmenubullet.png" left_padding 65 top_padding 10 text_color "#ffffff"

    # Start the music playing on entry to the music room.
    on "replace" action mr.Play()

    # Restore the main menu music upon leaving.
    on "replaced" action Play("music", "music/suspicions02.ogg")
        
screen omake:
    tag menu
    add "gui/menubg02.jpg"
    vbox xalign 0.5 yalign 0.17:
        spacing 10
        hbox:
            spacing 10
            if persistent.goodend:
                imagebutton idle "extra/epilogue_thumb.jpg" hover "extra/epilogue_thumb.jpg" action Replay("epilogue",locked=False)
            else:
                imagebutton idle "gui/locked_thumb.jpg"
                
            if persistent.sdcard:    
                imagebutton idle "extra/director_thumb.jpg" hover "extra/director_thumb.jpg" action ShowMenu("directorsnotes")
            else:
                imagebutton idle "gui/locked_thumb.jpg"
        hbox:
            spacing 10
            if persistent.kevindead:
                imagebutton idle "extra/limei_thumb.jpg" hover "extra/limei_thumb.jpg" action Replay("limeiprocess",locked=False)
            else:
                imagebutton idle "gui/locked_thumb.jpg"
            if persistent.op:
                imagebutton idle "extra/op_thumb.jpg" hover "extra/op_thumb.jpg" action Replay("playop",locked=False)
            else:
                imagebutton idle "gui/locked_thumb.jpg"
            
    textbutton "Return" action Return() xalign 0.5 yalign 0.8 background "gui/mainmenubulletidle.png" hover_background "gui/mainmenubullet.png" left_padding 65 top_padding 10 text_color "#ffffff"

    
label playop:
    $ renpy.movie_cutscene("kanop.ogv")
    return
    
    
##############################################################################
# Director's Notes
#
screen directorsnotes:
    
    tag menu
    add "extra/directorsnotes.jpg"
    
    imagebutton idle "extra/dnotes_idle.jpg" hover "extra/dnotes_hover.jpg" xpos 344 ypos 620 action ShowMenu("outtakes") 
    textbutton ("Return") action ShowMenu("main_menu") xalign 0.3 yalign 0.95 background "gui/mainmenubulletidle.png" hover_background "gui/mainmenubullet.png" left_padding 65 top_padding 10 text_color "#ffffff"
    
    #imagebutton idle "gui/button_thankyou_idle.jpg" hover "gui/button_thankyou_hover.jpg" action ShowMenu("outtakes") xpos 368  ypos 617
    
    #textbutton "Return" action ShowMenu("main_menu") xalign 0.97 yalign 0.98
    
screen outtakes:
    tag menu

    add "extra/outtakes.jpg"   
    
    
    #imagebutton idle "gui/music_pause_idle.jpg" hover "gui/music_pause_hover.jpg" selected_idle "gui/music_play_idle.jpg" selected_hover "gui/music_play_hover.jpg" action PauseAudio("music", value="toggle") xpos 595 ypos 350
    if renpy.music.is_playing(channel='voice'):
        imagebutton idle "gui/music_pause_idle.jpg" hover "gui/music_pause_hover.jpg" selected_idle "gui/music_play_idle.jpg" selected_hover "gui/music_play_hover.jpg" action PauseAudio("voice", value="toggle") xpos 575 ypos 350
    else:
        imagebutton idle "gui/music_play_idle.jpg" hover "gui/music_play_hover.jpg" action Play("voice", "extra/outtakes.ogg") xpos 575 ypos 350
    bar value AudioPositionValue(channel='voice', update_interval=0.1) left_gutter 1 right_gutter 0 thumb None xmaximum 310 left_bar "gui/music_bar_left.jpg" right_bar "gui/music_bar_right.jpg" xpos 610 ypos 350
    
    on "replace" action Stop("music")
    
    on "replaced" action [Stop("voice"),Play("music", "music/suspicions02.ogg")]
    
    textbutton "Return" action ShowMenu("main_menu") xalign 0.95 yalign 0.96 background "gui/mainmenubulletidle.png" hover_background "gui/mainmenubullet.png" left_padding 65 top_padding 10 text_color "#ffffff"
    