//=============================================================================
// kkdEventOp.js
// Version: 0.10(2016/5/23)
//=============================================================================
/*:ja
 * @plugindesc イベントページの出現条件にスクリプトを追加と、イベントの範囲を拡張
 * @author 唐傘ドール
 * @help
 * **注釈に書き込んでください
 * 注意:
 *  注釈が一番上に来るようにしてください
 *  一行ずつ書き込んでください。
 *  複数行に対応していません。
 *
 * **イベントページの出現条件に、スクリプトを追加する
 * <script:text>
 *
 * <script:$gameVariables.value(10) == 10>
 * 
 *
 * **イベントの範囲を拡張する
 * <range:[id, x, y]>
 * *id  
 * SQUARE = x,yを中心に四角く判定
 * CROSS = x,yを中心に十字方向へ判定
 * BOX = x,yを起点に四角に判定
 *
 * <range:[id,n]>
 * *id  
 * HOR = 右へnマス判定
 * VER = 下へnマス判定
 *
 */

(function() {
	// すべてコメントなら真
	Game_Event.prototype.check_comment_all = function() {
	    var list = this.list();
	    return list.every(function(event) {
	    	return event.code == 108 || event.code == 408 || event.code == 0;
	    });
	};
	//  実行内容が空か否かを判定
	Game_Event.prototype.check_comment = function() {
	    var list = this.list();
	    return !list || list.length <= 1 || this.check_comment_all();
	};
	
	// 
	Game_Event.prototype.findProperPageIndex = function() {
	    var pages = this.event().pages;
	    for (var i = pages.length - 1; i >= 0; i--) {
	        if (this.meetsConditions(i)) {
	            return i;
	        }
	    }
	    return -1;
	};

	Game_Event.prototype.meetsConditions = function(page) {
	    var list = this._conditions[page];
	    if(!list || list.length === 0){ return true; }
	    var con = [this.conditions1, this.conditions2, this.conditions3, this.conditions4, this.conditions5, this.conditions6];
	    return list.every(function(e){
			return con[e[0]].call(this, e[1]);
		}, this);

	};
	
	Game_Event.prototype.initialize = function(mapId, eventId) {
	    Game_Character.prototype.initialize.call(this);
	    this._mapId = mapId;
	    this._eventId = eventId;
	    this.locate(this.event().x, this.event().y);
	    this.conditions_init();
	    this.refresh();
	};
	
	Game_Event.prototype.conditions_init = function() {
		this._meta_ex = [];
		this._conditions = [];
		this.event().pages.forEach(function(page, id){
			this.conditions_mark(page, id);
		}, this);
	};
	

	Game_Event.prototype.conditions_mark = function(page, id) {
		this._conditions[id] = [];
		var conditions = this._conditions[id];
	    var c = page.conditions;
	    if (c.switch1Valid) {
	        conditions.push([0, c.switch1Id]);
	    }
	    if (c.switch2Valid) {
	        conditions.push([0, c.switch2Id]);
	    }
	    if (c.variableValid) {
	        conditions.push([1, [c.variableId, c.variableValue]]);
	    }
	    if (c.selfSwitchValid) {
	         conditions.push([2, c.selfSwitchCh]);
	    }
	    if (c.itemValid) {
	        conditions.push([3, c.itemId]);
	    }
	    if (c.actorValid) {
	    	conditions.push([4, c.actorId]);
	    }
	    var list = page.list;
	    this._meta_ex[id] = this._meta_ex[id] || {};
	    for(var i = 0; i < list.length; i++){
	    	var event = list[i];
	    	if(event.code == 0){
	    	}else if(event.code == 108 || event.code == 408){
	    		var data = event.parameters[0].match(/<(.+?):(.+)>/);
	    		if(data){
	    			var text = RegExp.$1;
	    			if(text === "script"){
	    				conditions.push([5, RegExp.$2]);
	    			}else{
	    				this._meta_ex[id][text] = RegExp.$2;
	    			}
	    			continue;
	    		}
	    		data = event.parameters[0].match(/<(\s+?)>/);
	    		if(data){
	    			this._meta_ex[id][item] = true;
	    		}
	    	}else{
	    		break;
	    	}
	    };

	};
	
	Game_Event.prototype.conditions1 = function(data) {
		return $gameSwitches.value(data);
	};
	
	Game_Event.prototype.conditions2 = function(data) {
		return $gameVariables.value(data[0]) >= data[1];
	};
	
	Game_Event.prototype.conditions3 = function(data) {
		var key = [this._mapId, this._eventId, data];
		var c= $gameSelfSwitches.value(key) === true;
		return c;
	};
	Game_Event.prototype.conditions4 = function(data) {
		var item = $dataItems[data];
		return $gameParty.hasItem(item);
	};
	Game_Event.prototype.conditions5 = function(data) {
		var actor = $gameActors.actor(data);
		return $gameParty.members().contains(actor);
	};
	Game_Event.prototype.conditions6 = function(data) {
		return eval(data);
	};
	
	
	///
	// ★座標十字範囲内一致判定
	Game_Character.prototype.cross_pos = function(x, y, get_x, get_y) {
	    return (Math.abs(x - this.x) <= get_x && y == this.y) || (Math.abs(y - this.y) <= get_y && x == this.x);
	};
	// ★座標範囲内一致判定
	Game_Character.prototype.range_pos = function(x, y, get_x, get_y) {
	    return Math.abs(x - this.x) <= get_x && Math.abs(y - this.y) <= get_y;
	};
	// ★範囲チェック　起点から右へ
	Game_Character.prototype.line_x = function(x, y, get_x) {
		var ix = x - this.x;
	    return ix > -1 && ix <= get_x && y == this.y;
	};
	// ★範囲チェック　起点から下へ
	Game_Character.prototype.line_y = function(x, y, get_y) {
		var iy = y - this.y;
	    return iy > -1 && iy <= get_y && x == this.x;
	};
	// ★座標範囲内一致判定
	Game_Character.prototype.box_pos = function(x, y, get_x, get_y) {
		var cx = x - this.x;
		var cy = y - this.y;
	    return cx <= get_x && cx >= 0 && cy <= get_y && cy >= 0;
	};
	// ★十字・範囲  指定座標に存在するイベントの配列取得
	Game_Event.prototype.events_range_xy = function(x, y) {
		if(this._pageIndex === -1){ return false; }
		var data = this._meta_ex[this._pageIndex]["range"];
		if(!data){ return; }
		const CROSS = 0, SQUARE = 1, HOR = 2, VER = 3, BOX = 4;
		var item = eval(data);
		switch (item[0]) {
	    case 0:
	   		return this.cross_pos(x, y, item[1], item[2]);
	    case 1: 
	    	return this.range_pos(x, y, item[1], item[2]);
	    case 2:
	    	return this.line_x(x, y, item[1]);
	    case 3:
	    	return this.line_y(x, y, item[1]);
	    case 4: 
	    	return this.box_pos(x, y, item[1], item[2]);
	    };
	};
	
	Game_Map.prototype.events_range_xy = function(x, y) {
	    return this.events().filter(function(event) {
	        return event.events_range_xy(x, y);
	    });
	};

    
    // ● マップイベントの起動
    Game_Player.prototype.start_map_event_range_xy = function(x, y, triggers, normal) {
    	var flag = false;
	    $gameMap.events_range_xy(x, y).forEach(function(event) {
	    	if (event.isTriggerIn(triggers) && event.isNormalPriority() === normal) {
	    		event.start();
	    		flag = true;
	    	}
	    });
	    return flag;
	};
    // ● 同位置のイベント起動判定
    var old_checkEventTriggerHere = Game_Player.prototype.checkEventTriggerHere;
    Game_Player.prototype.checkEventTriggerHere = function(triggers) {
	    if(this.start_map_event_range_xy(this.x, this.y, [1,2], false)){
	    	return true;
	    }
	    old_checkEventTriggerHere.call(this, triggers);
	};
	
	// ● 正面のイベント起動判定
	var old_checkEventTriggerThere = Game_Player.prototype.checkEventTriggerThere;
	Game_Player.prototype.checkEventTriggerThere = function(triggers) {
	    if (this.canStartLocalEvents()) {
	        var direction = this.direction();
	        var x1 = this.x;
	        var y1 = this.y;
	        var x2 = $gameMap.roundXWithDirection(x1, direction);
	        var y2 = $gameMap.roundYWithDirection(y1, direction);
		    if(this.start_map_event_range_xy(x2, y2, triggers, true)){
		    	return true;
		    }
	    }
	    old_checkEventTriggerThere.call(this, triggers);
	};
	
	// ● 接触イベントの起動判定
	var old_checkEventTriggerTouch = Game_Player.prototype.checkEventTriggerTouch;
	Game_Player.prototype.checkEventTriggerTouch = function(x, y) {
	    if (this.canStartLocalEvents()) {
		    if(this.start_map_event_range_xy(x, y, [1,2], true)){
		    	return true;
		    }
	    }
	    old_checkEventTriggerTouch.call(this, x, y);
	};
})();
