
function CreateGrants()

	CreateManufactury();
	CreateJeanProduction();
	CreateCottonPlantation();
	CreateCottonProduction();
end


function CreateManufactury()

	Objective.CreateGrant			( "Grant_Manufactury", 2000, 15000 )
		
	Objective.CreateGrant			( "Grant_Manufactury_ManufacturyRoom", 0, 0 )
	Objective.SetParent				( "Grant_Manufactury" )
	Objective.RequireRoom			( "Manufactury", true )
	
	Objective.CreateGrant			( "Grant_Manufactury_SewingStationNumber", 0, 0 )
	Objective.SetParent				( "Grant_Manufactury" )
	Objective.RequireObjects		( "SewingStation", 8 )
	
	Objective.CreateGrant			( "Grant_Manufactury_ProgramPassed", 0, 0 )
	Objective.SetParent				( "Grant_Manufactury" )
	Objective.Requires				( "ReformPassed", "ManufacturyInduction", 5 )
end

function CreateJeanProduction()

	Objective.CreateGrant			( "Grant_Jean_Production", 5000, 15000 )
	
	Objective.CreateGrant			( "Grant_Jean_Production_ManufacturyAssigned", 0, 0 )
	Objective.SetParent				( "Grant_Jean_Production")
	Objective.Requires				( "PrisonerJobs", "Manufactury", 8 )
	
	Objective.CreateGrant			( "Grant_Jean_Production_JeanProduction", 0, 5000 )
	Objective.SetParent				( "Grant_Jean_Production")
	Objective.RequireManufactured 	( "Jeans", 40 )
end
	
function CreateCottonPlantation()

	Objective.CreateGrant			( "Grant_CottonPlantation", 2000, 15000 )
		
	Objective.CreateGrant			( "Grant_CottonPlantation_CottonPlantationRoom", 0, 0 )
	Objective.SetParent				( "Grant_CottonPlantation" )
	Objective.RequireRoom			( "CottonPlantation", true )
	
	Objective.CreateGrant			( "Grant_CottonPlantation_CottonSeedsNumber", 0, 0 )
	Objective.SetParent				( "Grant_CottonPlantation" )
	Objective.RequireObjects		( "CottonSeeds", 12 )
	
	Objective.CreateGrant			( "Grant_CottonPlantation_ProgramPassed", 0, 0 )
	Objective.SetParent				( "Grant_CottonPlantation" )
	Objective.Requires				( "ReformPassed", "Plantation", 5 )
end

function CreateCottonProduction()

	Objective.CreateGrant			( "Grant_Cotton_Production", 5000, 25000 )
	
	Objective.CreateGrant			( "Grant_Cotton_Production_CottonPlantationAssigned", 0, 0 )
	Objective.SetParent				( "Grant_Cotton_Production")
	Objective.Requires				( "PrisonerJobs", "CottonPlantation", 8 )
	
	Objective.CreateGrant			( "Grant_Cotton_Production_CottonProduction", 0, 5000 )
	Objective.SetParent				( "Grant_Cotton_Production")
	Objective.RequireManufactured 	( "ClothSpool", 40 )
end