
function Create()

    Object.SetProperty( "Age", 0.0);  
    
    local vegType = "RawCotton";
    Object.SetProperty("VegType", vegType );
    
    Object.SetProperty("SubType", 1);
    Object.SetProperty("NeedsTending", false);
end


function Update( timePassed )

    local ourX = Object.GetProperty("Pos.x");
    local ourY = Object.GetProperty("Pos.y");
    local material = Object.GetMaterial( ourX, ourY );
    
    if material ~= "Farmland" then
        Object.SetProperty("Tooltip", "tooltip_seeds_compost");
        return;
    end      
    
    local maxAge = 720.0;
    
    if Object.GetProperty("NeedsTending") then       
        Object.CreateJob("TendCotton");
        Object.SetProperty("Tooltip", "tooltip_seeds_needtending");
        return;
    end    
    
    Object.SetProperty("Tooltip", "");  
        
    local age = Object.GetProperty("Age");    
    age = age + timePassed;    
    Object.SetProperty( "Age", age );
    
    local subType = 0;
    if age < maxAge * 0.33 then
        subType = 1;    
    elseif age < maxAge * 0.66 then
        subType = 2;    
    else
        subType = 3;
    end
    
    local currentSubtype = Object.GetProperty("SubType");
    if currentSubtype ~= subType then
        Object.SetProperty("SubType", subType);    
    end
    
    if age > maxAge then
		local name = Object.Spawn( Object.GetProperty("VegType"), ourX, ourY );
        
        if name ~= nil then
            local velX = -1.0 + math.random() + math.random();
            local velY = -1.0 + math.random() + math.random();
            
            Object.ApplyVelocity(name, velX, velY);
        end
        local name = Object.Spawn( Object.GetProperty("VegType"), ourX, ourY );
        
        if name ~= nil then
            local velX = -1.0 + math.random() + math.random();
            local velY = -1.0 + math.random() + math.random();
            
            Object.ApplyVelocity(name, velX, velY);
        end
		local name = Object.Spawn( Object.GetProperty("VegType"), ourX, ourY );
        
        if name ~= nil then
            local velX = -1.0 + math.random() + math.random();
            local velY = -1.0 + math.random() + math.random();
            
            Object.ApplyVelocity(name, velX, velY);
        end
        Object.SetProperty( "Age", 0 );
        Object.SetProperty( "NeedsTending", true );
        Object.SetProperty( "SubType", 1 );    
    end

end

function JobComplete_TendCotton()

    Object.SetProperty("NeedsTending", false);    

end

