//=============================================================================
// T_shakeWindow.js
//=============================================================================
//Copyright (c) 2016 Trb
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
//
//twitter https://twitter.com/Trb_surasura
/*:
 * @plugindesc ウインドウを揺らす制御文字を追加するプラグイン
 * @author Trb
 * @version 1.00 2016/5/30 初版
 *          1.01 2016/6/5  他の制御文字が無効になってしまっていた不具合を修正
 * 
 * @help 文章中に制御文字 \S[任意の値] と書くとウインドウが揺れます。
 * 任意の値は揺れの強さです。好きな数字を入れて下さい。
 * 制御文字1回につき16フレーム揺れ、複数並べると揺れ時間を延長できます。
 * 
 * <記述例>
 * 「\S[10]\S[10]ぎゃーーーー！バケモンだーーーー！」
 * ・・・10の強さで32フレーム揺れる
 * 
 */
(function () {

    var baseCount = 16;//制御文字1つにつき何フレーム揺らすかの値
    var speed = 4;//揺れる速度
    //上の2つを変更してカスタマイズできますが、基本的にbaseCountの値はspeed*2の倍数にして下さい。
    //そうしないと揺れ始めが若干不自然に見えてしまうことがあります。
    //(ややこしいのでパラメータからは設定できないようにしました)

	
    var Window_Base_processEscapeCharacter = Window_Base.prototype.processEscapeCharacter;
    Window_Base.prototype.processEscapeCharacter = function(code, textState) {
        Window_Base_processEscapeCharacter.apply(this,arguments);
        switch(code){
        case 'S'://制御文字を追加 (もし他の制御文字系プラグインと被ってしまった場合、ここを'A'でも'B'でも好きな文字に変えればいいです)
            this.startShakeWindow(this.obtainEscapeParam(textState));
            break;
        }
    };




    Window_Base.prototype.startShakeWindow = function(power) {
        if(!this.baseX){//初回実行時の処理
            this.baseX = this.x;//ウインドウの初期位置を取得しておく
            this.shakeCount = 0;//シェイクカウントの初期化
        }
        this.shakeCount += baseCount;//シェイクカウントを加算
        this.shakePower = power;//シェイクの強さを設定
    };

    var Window_Base_update = Window_Base.prototype.update;
    Window_Base.prototype.update = function() {
        Window_Base_update.call(this);
        if(this.shakeCount > 0){//シェイクカウントが0以上の時
            this.shakeCount -= 1;
            //xの値を操作する
            this.x = this.baseX + Math.sin(Math.PI * this.shakeCount / speed) * this.shakePower;
        };
    };

})();