/*
* Radius loot part of the mod.
* Feel free to edit/redistribute.
*/

function AL_LootInRadius()
{
	var EntitiesFound : array<CGameplayEntity>;
	var i : int;
	var MaxContainers : int;
	var NumberOfContainers : int;
	var TempStoreOption : bool;
	var ContainerNum : int;
	var container : W3Container;
		
	// Check if this feature is enabled
	if( !AL_EnableRadiusLoot() )
		return;
	
	// Does not work in combat
	if( thePlayer.IsInCombat() )
		return;
		
	// Find containers in a range
	FindGameplayEntitiesInRange( 
		EntitiesFound, // array to store values
		thePlayer, // center of search box
		AL_RadiusLootMaxDistance(), // maximum distance
		600);// maximum objects
	
	// we initialize variables
	NumberOfContainers = EntitiesFound.Size();
	MaxContainers = AL_RadiusLootMaxContainersAtOnce();
	
	// Ensure max containers is positive
	if(MaxContainers <= 0)
		MaxContainers = 1;
		
	ContainerNum = 0;
	
	// we now parse the containers
	for( i = 0; i < NumberOfContainers; i += 1)
	{
		// we ignore some containers
		if( (W3Container) EntitiesFound[i] )
		{
			container = (W3Container) EntitiesFound[i];
			
			container.OnInteraction("Container", thePlayer);
			
			if(container.IsEmpty())
				ContainerNum += 1;
			
			// We have to close the popup if it's opened
			theGame.ClosePopup('LootPopup');
			
			if(ContainerNum >= MaxContainers)
				return;
		}
	}
}