﻿//=============================================================================
// TMVplugin - コモンイベントキー
// 作者: tomoaky (http://hikimoki.sakura.ne.jp/)
// Version: 1.0
// 最終更新日: 2016/03/15
//=============================================================================

/*:
 * @plugindesc 任意のキーにコモンイベントを設定し、マップシーンで
 * ショートカットキーとして利用できるようにします。
 *
 * @author tomoaky (http://hikimoki.sakura.ne.jp/)
 *
 * @param commonKey0
 * @desc ０キーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKey1
 * @desc １キーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKey2
 * @desc ２キーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKey3
 * @desc ３キーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKey4
 * @desc ４キーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKey5
 * @desc ５キーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKey6
 * @desc ６キーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKey7
 * @desc ７キーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKey8
 * @desc ８キーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKey9
 * @desc ９キーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyA
 * @desc Ａキーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyB
 * @desc Ｂキーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyC
 * @desc Ｃキーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyD
 * @desc Ｄキーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyE
 * @desc Ｅキーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyF
 * @desc Ｆキーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyG
 * @desc Ｇキーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyH
 * @desc Ｈキーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyI
 * @desc Ｉキーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyJ
 * @desc Ｊキーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyK
 * @desc Ｋキーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyL
 * @desc Ｌキーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyM
 * @desc Ｍキーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyN
 * @desc Ｎキーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyO
 * @desc Ｏキーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyP
 * @desc Ｐキーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyQ
 * @desc Ｑキーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyR
 * @desc Ｒキーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyS
 * @desc Ｓキーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyT
 * @desc Ｔキーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyU
 * @desc Ｕキーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyV
 * @desc Ｖキーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyW
 * @desc Ｗキーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyX
 * @desc Ｘキーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyY
 * @desc Ｙキーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyZ
 * @desc Ｚキーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyF1
 * @desc Ｆ１キーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyF2
 * @desc Ｆ２キーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyF3
 * @desc Ｆ３キーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyF4
 * @desc Ｆ４キーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyF5
 * @desc Ｆ５キーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyF6
 * @desc Ｆ６キーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyF7
 * @desc Ｆ７キーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyF8
 * @desc Ｆ８キーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyF9
 * @desc Ｆ９キーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyF10
 * @desc Ｆ１０キーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyF11
 * @desc Ｆ１１キーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @param commonKeyF12
 * @desc Ｆ１２キーで起動するコモンイベント番号
 * 初期値: 0（ 1 以上で有効）
 * @default 0
 *
 * @help
 * 注意:
 *   MVの標準機能、または他のプラグインで使用しているキーを使うと
 *   競合によるエラーの原因になります。
 *
 * プラグインコマンドはありません。
 * 
 */

var Imported = Imported || {};
Imported.TMCommonEventKey = true;

(function() {

  var parameters = PluginManager.parameters('TMCommonEventKey');
  var commonKeyCodes = {48: '0', 49: '1', 50: '2', 51: '3', 52: '4',
                        53: '5', 54: '6', 55: '7', 56: '8', 57: '9',
                        65: 'A', 66: 'B', 67: 'C', 68: 'D', 69: 'E',
                        70: 'F', 71: 'G', 72: 'H', 73: 'I', 74: 'J',
                        75: 'K', 76: 'L', 77: 'M', 78: 'N', 79: 'O',
                        80: 'P', 81: 'Q', 82: 'R', 83: 'S', 84: 'T',
                        85: 'U', 86: 'V', 87: 'W', 88: 'X', 89: 'Y',
                        90: 'Z',
                        112: 'F1', 113: 'F2',  114: 'F3',  115: 'F4',
                        116: 'F5', 117: 'F6',  118: 'F7',  119: 'F8',
                        120: 'F9', 121: 'F10', 122: 'F11', 123: 'F12'};
  var commonKeys = {};
  var keys = Object.keys(commonKeyCodes);
  for (var i = 0, len = keys.length; i < len; i++) {
    var key = keys[i];
    var name = 'commonKey' + commonKeyCodes[key];
    var commonEventId = +parameters[name];
    if (commonEventId > 0) {
      Input.keyMapper[key] = name;
      commonKeys[name] = commonEventId;
    }
  }

  //-----------------------------------------------------------------------------
  // Scene_Map
  //
  
  var _Scene_Map_updateScene = Scene_Map.prototype.updateScene;
  Scene_Map.prototype.updateScene = function() {
    _Scene_Map_updateScene.call(this);
    if (!SceneManager.isSceneChanging() && !$gamePlayer.isMoving() &&
        !$gameMap.isEventRunning()) {
      var keys = Object.keys(commonKeys);
      for (var i = 0, len = keys.length; i < len; i++) {
        var key = keys[i];
        if (Input.isTriggered(key)) {
          $gameTemp.reserveCommonEvent(commonKeys[key]);
          break;
        }
      }
    }
  };

})();
