﻿## This file contains some of the options that can be changed to customize
## your Ren'Py game. It only contains the most common options... there
## is quite a bit more customization you can do.
##
## Lines beginning with two '#' marks are comments, and you shouldn't
## uncomment them. Lines beginning with a single '#' mark are
## commented-out code, and you may want to uncomment them when
## appropriate.

init -1 python hide:

    ## Should we enable the use of developer tools? This should be
    ## set to False before the game is released, so the user can't
    ## cheat using developer tools.

    config.developer = False

    ## These control the width and height of the screen.

    config.screen_width = 1920
    config.screen_height = 1080

    ## This controls the title of the window, when Ren'Py is
    ## running in a window.

    config.window_title = u"One Night Stand"

    # These control the name and version of the game, that are reported
    # with tracebacks and other debugging logs.
    config.name = "One Night Stand"
    config.version = "0.0"
    
    config.window_icon = "icon.ico"
    config.windows_icon = "icon.ico"
    

    #########################################
    # Themes

    ## We then want to call a theme function. theme.roundrect is
    ## a theme that features the use of rounded rectangles.
    ##
    ## The theme function takes a number of parameters that can
    ## customize the color scheme.

    theme.marker(
        ## Theme: Marker
        ## Color scheme: Ice Queen

        ## The color of an idle widget face.
        widget = "#ffffff",

        ## The color of a focused widget face.
        widget_hover = "#b29a91",

        ## The color of the text in a widget.
        widget_text = "#ffffff",

        ## The color of the text in a selected widget. (For
        ## example, the current value of a preference.)
        widget_selected = "#6c544b",

        ## The color of a disabled widget face.
        disabled = "#6c544b",

        ## The color of disabled widget text.
        disabled_text = "#6c544b",

        ## The color of informational labels.
        label = "#6c544b",
        
        ## The color of a frame containing widgets.
        frame = "#ffffff",
        
        ## The background of the main menu. This can be a color
        ## beginning with '#', or an image filename. The latter
        ## should take up the full height and width of the screen.
        mm_root = "mainmenulogo",

        ## The background of the game menu. This can be a color
        ## beginning with '#', or an image filename. The latter
        ## should take up the full height and width of the screen.
        gm_root = "mainmenubg",

        ## If this is True, the in-game window is rounded. If False,
        ## the in-game window is square.
        rounded_window = False,

        ## And we're done with the theme. The theme will customize
        ## various styles, so if we want to change them, we should
        ## do so below.
        )


    #########################################
    ## These settings let you customize the window containing the
    ## dialogue and narration, by replacing it with an image.

    ## The background of the window. In a Frame, the two numbers
    ## are the size of the left/right and top/bottom borders,
    ## respectively.

    style.window.background = Frame("thoughtbox", 12, 12)

    ## Margin is space surrounding the window, where the background
    ## is not drawn.

    style.window.left_margin = 0
    style.window.right_margin = 0
    style.window.top_margin = 0
    style.window.bottom_margin = 0

    ## Padding is space inside the window, where the background is
    ## drawn.

    style.window.left_padding = 0
    style.window.right_padding = 0
    style.window.top_padding = 0
    style.window.bottom_padding = 0

    ## This is the minimum height of the window, including the margins
    ## and padding.

    style.window.yminimum = 231
    style.window.yalign = 0.5
    style.window.xalign = 0.5
    
    #########################################
    
    ## Button styles
    
    style.menu_choice_button.background = "images/button_off.png"
    style.menu_choice_button.hover_background = "bgiggle"
    
    style.menu_choice_button.yminimum = 190
    style.menu_choice_button.xminimum = 444

    style.menu_choice_button.xpos = 0
    style.menu_choice_button.ypos = 0
    
    #style.menu_choice.xpos = 0
    #style.menu_choice.ypos = 0
    
    style.menu_choice.color = "#6c544b"
    style.menu_choice.hover_color = "#6c544b"
    
    style.menu_choice.size = 40
    
    ## Main Menu Buttons
    
    style.mainmenu_choice_button.background = "images/mm_button1.png"
    style.mainmenu_choice_button.hover_background = "mm_bgiggle"
    style.mainmenu_choice_button.selected_background = "images/mm_button_on.png"
    
    style.mainmenu_choice_button.yminimum = 128
    style.mainmenu_choice_button.xminimum = 300

    style.mainmenu_choice_button.xpos = 0
    style.mainmenu_choice_button.ypos = 0
    
    style.mainmenu_choice.xanchor = 0.5
    style.mainmenu_choice.yanchor = 0.5
    style.mainmenu_choice.xpos = 0.5
    style.mainmenu_choice.ypos = 0.5
    
    style.mainmenu_choice.color = "#6c544b"
    style.mainmenu_choice.hover_color = "#6c544b"
    
    style.mainmenu_choice.size = 40
    
    ## Save load button style
    
    config.thumbnail_width = 365
    config.thumbnail_height = 205

    style.file_picker = Style(style.menu_frame)

    style.file_picker.background = None
    
    style.file_picker.size = 30

    style.file_picker.top_margin = 0
    style.file_picker.left_margin = 0
    style.file_picker.right_margin = 0
    style.file_picker.bottom_margin = 0

    #style.file_picker_nav_button.xalign = 0.5

    #style.file_picker_nav_button = Style(style.small_button)
    #style.file_picker_nav_button_text = Style(style.small_button_text)

    #style.file_picker_button = Style(style.large_button)
    #style.file_picker_text = Style(style.large_button_text)


    #########################################
    ## This lets you change the placement of the main menu.

    ## The way placement works is that we find an anchor point
    ## inside a displayable, and a position (pos) point on the
    ## screen. We then place the displayable so the two points are
    ## at the same place.

    ## An anchor/pos can be given as an integer or a floating point
    ## number. If an integer, the number is interpreted as a number
    ## of pixels from the upper-left corner. If a floating point,
    ## the number is interpreted as a fraction of the size of the
    ## displayable or screen.

    # style.mm_menu_frame.xpos = 0.5
    # style.mm_menu_frame.xanchor = 0.5
    # style.mm_menu_frame.ypos = 0.75
    # style.mm_menu_frame.yanchor = 0.5


    #########################################
    ## These let you customize the default font used for text in Ren'Py.

    ## The file containing the default font.

    style.default.font = "IHATCS__.TTF"

    ## The default size of text.

    style.default.size = 44
    style.default.color = "#6c544b"

    ## Note that these only change the size of some of the text. Other
    ## buttons have their own styles.


    #########################################
    ## These settings let you change some of the sounds that are used by
    ## Ren'Py.

    ## Set this to False if the game does not have any sound effects.

    config.has_sound = True

    ## Set this to False if the game does not have any music.

    config.has_music = True

    ## Set this to True if the game has voicing.

    config.has_voice = False

    ## Sounds that are used when button and imagemaps are clicked.

    style.button.activate_sound = "sounds/button.wav"
    style.imagemap.activate_sound = "sounds/item.wav"

    ## Sounds that are used when entering and exiting the game menu.

    config.enter_sound = "sounds/button.wav"
    config.exit_sound = "sounds/button.wav"

    ## A sample sound that can be played to check the sound volume.

    config.sample_sound = "sounds/notification.wav"

    ## Music that is played while the user is at the main menu.

    # config.main_menu_music = "main_menu_theme.ogg"


    #########################################
    ## Help.

    ## This lets you configure the help option on the Ren'Py menus.
    ## It may be:
    ## - A label in the script, in which case that label is called to
    ##   show help to the user.
    ## - A file name relative to the base directory, which is opened in a
    ##   web browser.
    ## - None, to disable help.
    config.help = None


    #########################################
    ## Transitions.

    ## Used when entering the game menu from the game.
    config.enter_transition = dissolve

    ## Used when exiting the game menu to the game.
    config.exit_transition = dissolve

    ## Used between screens of the game menu.
    config.intra_transition = dissolve

    ## Used when entering the game menu from the main menu.
    config.main_game_transition = dissolve

    ## Used when returning to the main menu from the game.
    config.game_main_transition = dissolve

    ## Used when entering the main menu from the splashscreen.
    config.end_splash_transition = dissolve

    ## Used when entering the main menu after the game has ended.
    config.end_game_transition = dissolve

    ## Used when a game is loaded.
    config.after_load_transition = dissolve

    ## Used when the window is shown.
    config.window_show_transition = dissolve

    ## Used when the window is hidden.
    config.window_hide_transition = dissolve

    ## Used when showing NVL-mode text directly after ADV-mode text.
    config.adv_nvl_transition = dissolve

    ## Used when showing ADV-mode text directly after NVL-mode text.
    config.nvl_adv_transition = dissolve

    ## Used when yesno is shown.
    config.enter_yesno_transition = dissolve

    ## Used when the yesno is hidden.
    config.exit_yesno_transition = dissolve

    ## Used when entering a replay
    config.enter_replay_transition = dissolve

    ## Used when exiting a replay
    config.exit_replay_transition = dissolve

    ## Used when the image is changed by a say statement with image attributes.
    config.say_attribute_transition = dissolve

    #########################################
    ## This is the name of the directory where the game's data is
    ## stored. (It needs to be set early, before any other init code
    ## is run, so the persistent information can be found by the init code.)
python early:
    config.save_directory = "One Night Stand-1456828533"

init -1 python hide:
    #########################################
    ## Default values of Preferences.

    ## Note: These options are only evaluated the first time a
    ## game is run. To have them run a second time, delete
    ## game/saves/persistent

    ## Should we start in fullscreen mode?

    config.default_fullscreen = False

    ## The default text speed in characters per second. 0 is infinite.

    config.default_text_cps = 40

    ## The default auto-forward time setting.

    config.default_afm_time = 10

    #########################################
    ## NVL
    
     ## ------ Framed (adjustable) NVL box ---------
    #style.nvl_window.background = Frame("blank.png", 0, 0)  
    
    ## ---- No Frame (non-adjustable) Nvl Box------
    style.nvl_window.background = "blank.png"    
    
    ## margins ------------------------------------
    # Changes the shape of the BOX.

    style.nvl_window.top_margin = 100
    style.nvl_window.bottom_margin = 100
    style.nvl_window.left_margin = 300
    style.nvl_window.right_margin = 300
    
    ## padding ---------------------------------
    # Changes the placement of the TEXT.

    style.nvl_window.top_padding = 0
    style.nvl_window.bottom_padding = 0
    style.nvl_window.left_padding = 0
    style.nvl_window.right_padding = 0
    
    ## Interblock spacing: ------------------
    # The space between Blocks of paragraphs. 

    style.nvl_vbox.box_spacing = 35
    
    ## SLIDER
    
    style.pref_slider.left_bar = "images/slider_full.png"
    style.pref_slider.right_bar = "images/slider_empty.png"
    style.pref_slider.ymaximum = 47
    style.pref_slider.xmaximum = 625


## This section contains information about how to build your project into
## distribution files.
init python:

    ## The name that's used for directories and archive files. For example, if
    ## this is 'mygame-1.0', the windows distribution will be in the
    ## directory 'mygame-1.0-win', in the 'mygame-1.0-win.zip' file.
    build.directory_name = "One_Night_Stand-1.0"

    ## The name that's uses for executables - the program that users will run
    ## to start the game. For example, if this is 'mygame', then on Windows,
    ## users can click 'mygame.exe' to start the game.
    build.executable_name = "One_Night_Stand"

    ## If True, Ren'Py will include update information into packages. This
    ## allows the updater to run.
    build.include_update = False

    ## File patterns:
    ##
    ## The following functions take file patterns. File patterns are case-
    ## insensitive, and matched against the path relative to the base
    ## directory, with and without a leading /. If multiple patterns match,
    ## the first is used.
    ##
    ##
    ## In a pattern:
    ##
    ## /
    ##     Is the directory separator.
    ## *
    ##     Matches all characters, except the directory separator.
    ## **
    ##     Matches all characters, including the directory separator.
    ##
    ## For example:
    ##
    ## *.txt
    ##     Matches txt files in the base directory.
    ## game/**.ogg
    ##     Matches ogg files in the game directory or any of its subdirectories.
    ## **.psd
    ##    Matches psd files anywhere in the project.

    ## Classify files as None to exclude them from the built distributions.

    build.classify('**~', None)
    build.classify('**.bak', None)
    build.classify('**/.**', None)
    build.classify('**/#**', None)
    build.classify('**/thumbs.db', None)

    ## To archive files, classify them as 'archive'.

    # build.classify('game/**.png', 'archive')
    # build.classify('game/**.jpg', 'archive')

    ## Files matching documentation patterns are duplicated in a mac app
    ## build, so they appear in both the app and the zip file.

    build.documentation('*.html')
    build.documentation('*.txt')
    
    
    