﻿# This file is in the public domain. Feel free to modify it as a basis
# for your own screens.

# Note that many of these screens may be given additional arguments in the
# future. The use of **kwargs in the parameter list ensures your code will
# work in the future.

##############################################################################
# Say
#
# Screen that's used to display adv-mode dialogue.
# http://www.renpy.org/doc/html/screen_special.html#say
screen say(who, what, side_image=None, two_window=False):

    # Decide if we want to use the one-window or two-window variant.
    if not two_window:

        # The one window variant.
        window:
            xalign 0.5

            id "window"

            has vbox:
                style "say_vbox"

            if who:
                text who id "who"

            text what id "what"

    else:

        # The two window variant.
        vbox:
            style "say_two_window_vbox"

            if who:
                window:
                    style "say_who_window"

                    text who:
                        id "who"

            window:
                id "window"

                has vbox:
                    style "say_vbox"

                text what id "what"

    # If there's a side image, display it above the text.
    if side_image:
        add side_image
    else:
        add SideImage() xalign 0.0 yalign 1.0

    # Use the quick menu.
    use quick_menu


##############################################################################
# Choice
#
# Screen that's used to display in-game menus.
# http://www.renpy.org/doc/html/screen_special.html#choice

screen choice(items):

    window:
        style "menu_window"
        xalign 0.5
        yalign 0.9

        hbox:
            style "menu"
            spacing 70

            for caption, action, chosen in items:

                if action:

                    button:
                        action action
                        style "menu_choice_button"

                        text caption style "menu_choice"

                else:
                    text caption style "menu_caption"
                    
    use quick_menu

init -2:
    $ config.narrator_menu = True

    style menu_window is default

    style menu_choice is button_text:
        clear

    style menu_choice_button is button:
        xminimum int(config.screen_width * 0.75)
        xmaximum int(config.screen_width * 0.75)


##############################################################################
# Input
#
# Screen that's used to display renpy.input()
# http://www.renpy.org/doc/html/screen_special.html#input

screen input(prompt):

    window style "input_window":
        has vbox

        text prompt style "input_prompt"
        input id "input" style "input_text"

    use quick_menu

##############################################################################
# Nvl
#
# Screen used for nvl-mode dialogue and menus.
# http://www.renpy.org/doc/html/screen_special.html#nvl

screen nvl(dialogue, items=None):

    window:
        style "nvl_window"

        has vbox:
            style "nvl_vbox"

        # Display dialogue.
        for who, what, who_id, what_id, window_id in dialogue:
            window:
                id window_id

                has hbox:
                    spacing 10

                if who is not None:
                    text who id who_id

                text what id what_id

        # Display a menu, if given.
        if items:

            vbox:
                id "menu"

                for caption, action, chosen in items:

                    if action:

                        button:
                            style "nvl_menu_choice_button"
                            action action

                            text caption style "nvl_menu_choice"

                    else:

                        text caption style "nvl_dialogue"

    #add SideImage() xalign 0.0 yalign 1.0

    use quick_menu

##############################################################################
# Main Menu
#
# Screen that's used to display the main menu, when Ren'Py first starts
# http://www.renpy.org/doc/html/screen_special.html#main-menu

screen main_menu():

    # This ensures that any other menu screen is replaced.
    tag menu

    # The background of the main menu.
    window:
        style "mm_root"

    # The main menu buttons.

    hbox:
        spacing 50
        xalign 0.5
        ypos 920
        
        button:
            style "mainmenu_choice_button"
            text "Start Game" style "mainmenu_choice"
            action Start()
            
        button:
            style "mainmenu_choice_button"
            text "Load Game" style "mainmenu_choice"
            action ShowMenu("load")
            
        button:
            style "mainmenu_choice_button"
            text "Settings" style "mainmenu_choice"
            action ShowMenu("preferences")
            
        button:
            style "mainmenu_choice_button"
            text "Credits" style "mainmenu_choice"
            action ShowMenu("credits")
            
        button:
            style "mainmenu_choice_button"
            text "Quit" style "mainmenu_choice"
            action Quit(confirm=False)


init -2:

    # Make all the main menu buttons be the same size.
    style mm_button:
        size_group "mm"



##############################################################################
# Navigation
#
# Screen that's included in other screens to display the game menu
# navigation and background.
# http://www.renpy.org/doc/html/screen_special.html#navigation
screen navigation():

    # The background of the game menu.
    window:
        style "gm_root"

    hbox:
        spacing 50
        xalign 0.5
        ypos 920
        
        button:
            style "mainmenu_choice_button"
            text "Return" style "mainmenu_choice"
            action Return()
            
        button:
            style "mainmenu_choice_button"
            text "Save Game" style "mainmenu_choice"
            action ShowMenu("save")
            
        button:
            style "mainmenu_choice_button"
            text "Load Game" style "mainmenu_choice"
            action ShowMenu("load")
            
        button:
            style "mainmenu_choice_button"
            text "Main Menu" style "mainmenu_choice"
            action MainMenu()
            
        button:
            style "mainmenu_choice_button"
            text "Quit" style "mainmenu_choice"
            action Quit(confirm=True)

init -2:

    # Make all game menu navigation buttons the same size.
    style gm_nav_button:
        size_group "gm_nav"
    
        
##############################################################################
# Navigation small
#
# Screen that's included in other screens to display the game menu
# navigation and background.
# http://www.renpy.org/doc/html/screen_special.html#navigation
screen navigation_small():

    # The background of the game menu.
    window:
        style "gm_root"

    hbox:
        spacing 50
        xalign 0.5
        ypos 920
        
        button:
            style "mainmenu_choice_button"
            text "Return" style "mainmenu_choice"
            action Return()
            
        button:
            style "mainmenu_choice_button"
            text "Load Game" style "mainmenu_choice"
            action ShowMenu("load")
            
        button:
            style "mainmenu_choice_button"
            text "Settings" style "mainmenu_choice"
            action ShowMenu("preferences")
            
        button:
            style "mainmenu_choice_button"
            text "Quit" style "mainmenu_choice"
            action Quit(confirm=True)

init -2:

    # Make all game menu navigation buttons the same size.
    style gm_nav_button:
        size_group "gm_nav"


##############################################################################
# Save, Load
#
# Screens that allow the user to save and load the game.
# http://www.renpy.org/doc/html/screen_special.html#save
# http://www.renpy.org/doc/html/screen_special.html#load

# Since saving and loading are so similar, we combine them into
# a single screen, file_picker. We then use the file_picker screen
# from simple load and save screens.

screen file_picker():    
    hbox:
        style "gm_root"
        
        add "images/save_load_bg.png" xanchor 0.5 yanchor 0 xpos 0.5 ypos 144

    $ columns = 3
    $ rows = 1

    # Display a grid of file slots.
    #grid columns rows:
    hbox:
        
        xpos 320
        ypos 400
        
        spacing 50

        # Display ten file slots, numbered 1 - 10.
        for i in range(1, 4):
            button:
                action FileAction(i)

                has vbox spacing 20

                add FileScreenshot(i) size(365,205) ypos 10

                $ file_name = FileSlotName(i, columns * rows)
                $ file_time = FileTime(i, empty=_("Empty Slot"))
                $ save_name = FileSaveName(i)

                text "[file_name]. [file_time!t]\n"
                
    add "images/photos1.png" xpos 315 ypos 390

screen save():
    
    # This ensures that any other menu screen is replaced.
    tag menu

    use navigation
    use file_picker
    
    hbox:
        xpos 770
        ypos 240
        
        text "Save Game" size 90


screen load():

    # This ensures that any other menu screen is replaced.
    tag menu

    use navigation_small
    use file_picker
    
    hbox:
        xpos 770
        ypos 240
        
        text "Load Game" size 90
        
##############################################################################
# Credits

screen credits():
    tag menu

    # The background of the main menu.
    window:
        add "images/credits.jpg"

    # The main menu buttons.

    hbox:
        spacing 50
        xalign 0.5
        ypos 920
        
        button:
            style "mainmenu_choice_button"
            text "Return" style "mainmenu_choice"
            action Return()
            
        button:
            style "mainmenu_choice_button"
            text "Load Game" style "mainmenu_choice"
            action ShowMenu("load")
            
        button:
            style "mainmenu_choice_button"
            text "Settings" style "mainmenu_choice"
            action ShowMenu("preferences")
            
        button:
            style "mainmenu_choice_button"
            text "Credits" style "mainmenu_choice"
            action ShowMenu("credits")
            
        button:
            style "mainmenu_choice_button"
            text "Quit" style "mainmenu_choice"
            action Quit(confirm=False)


init -2:

    # Make all the main menu buttons be the same size.
    style mm_button:
        size_group "mm"


##############################################################################
# Preferences
#
# Screen that allows the user to change the preferences.
# http://www.renpy.org/doc/html/screen_special.html#prefereces

screen preferences():

    tag menu

    # Include the navigation.
    use navigation_small
    
    add "images/prefs.png" xanchor 0.5 yanchor 0 xpos 0.5 ypos 65

    # Put the navigation columns in a three-wide grid.
    #grid 3 1:
        #style_group "prefs"
        #xfill True

    # The left column.
    vbox:
        xalign 0.25
        yalign 0.3
        spacing 45
        
        hbox:
            style_group "pref"
            xalign 0.5

            label _("Display\n\n")

        hbox:
            style_group "pref"
            xalign 0.5

            label _("Skip\n\n")

        hbox:
            style_group "pref"
            xalign 0.5

            label _("After Choices\n")
                
        hbox:
            style_group "pref"
            xalign 0.5

            label _("Music Volume")
        hbox:
            style_group "pref"
            xalign 0.5

            label _("Sound Volume")
    
    # The right column.
    vbox:
        xanchor 0.0
        xpos 900
        yalign 0.3
        spacing 60
        
        hbox:
            spacing 50
            
            button:
                action Preference("display", "window")
                style "mainmenu_choice_button"
                text "Window" style "mainmenu_choice"
                
            button:
                action Preference("display", "fullscreen")
                style "mainmenu_choice_button"
                text "Fullscreen" style "mainmenu_choice"

        hbox:
            spacing 50
            
            button:
                action Preference("skip", "seen")
                style "mainmenu_choice_button"
                text "Seen Messages" style "mainmenu_choice"
                
            button:
                action Preference("skip", "all")
                style "mainmenu_choice_button"
                text "All Messages" style "mainmenu_choice"

        hbox:
            spacing 50
            
            button:
                action Preference("after choices", "stop")
                style "mainmenu_choice_button"
                text "Stop Skipping" style "mainmenu_choice"
                
            button:
                action Preference("after choices", "skip")
                style "mainmenu_choice_button"
                text "Keep Skipping" style "mainmenu_choice"

        hbox:
            style_group "pref"
            xalign 0.5
            bar value Preference("music volume")
        hbox:
            style_group "pref"
            xalign 0.5
            bar value Preference("sound volume")

            #if config.sample_sound:
                #button:
                    #action Play("sound", config.sample_sound)
                    #style "mainmenu_choice_button"
                    #text "Test Sound" style "mainmenu_choice"


init -2:
    style pref_vbox:
        xfill False
        
    style pref_hbox:
        xfill False
        
    style pref_label_text:
        size 44

    style pref_button:
        text_align 0.6 
        xalign 0.6
        
    style pref_button_text:
        size 44

    style pref_slider:
        xmaximum 600
        #xalign 1.0

    #style soundtest_button:
        #xalign 0.6


##############################################################################
# Yes/No Prompt
#
# Screen that asks the user a yes or no question.
# http://www.renpy.org/doc/html/screen_special.html#yesno-prompt

screen yesno_prompt(message, yes_action, no_action):
    window:
        style "gm_root"

    #modal True

    hbox:
        add "images/popup.png" xanchor 0.0 yanchor 0 xpos 410 ypos 200

    vbox:
        yanchor 0
        xanchor 0.5
        ypos 250
        xalign 0.5
        xmaximum 1050
        ymaximum 350

        label _(message):
            text_style "yesno_label_text"
            xalign 0.5
            yalign 0.5
            
        hbox:
            style "menu"
            ypos 400
            spacing 70

            button:
                action yes_action
                style "menu_choice_button"
                text "Yes" style "menu_choice"
                
            button:
                action no_action
                style "menu_choice_button"
                text "No" style "menu_choice"

    # Right-click and escape answer "no".
    key "game_menu" action no_action

init -2:
    #style yesno_button:
        #size_group "yesno"

    style yesno_label_text:
        text_align 0.5 size 44
        layout "subtitle"


##############################################################################
# Quick Menu
#
# A screen that's included by the default say screen, and adds quick access to
# several useful functions.
screen quick_menu():
    
    add "images/quickmenu.png" xanchor 1.0 yanchor 0.0 xpos 1920 ypos 0

    # Add an in-game quick menu.
    vbox:
        xalign 0.993
        yalign 0.02
        
        spacing 4

        #imagebutton _("Back") action Rollback()
        #textbutton _("Q.Save") action QuickSave()
        #textbutton _("Q.Load") action QuickLoad()
        #textbutton _("F.Skip") action Skip(fast=True, confirm=True)
        #textbutton _("Auto") action Preference("auto-forward", "toggle")
        imagebutton idle "images/quit1.png" hover "cross" xpos 2 action Quit(confirm=True)
        imagebutton idle "images/settings1.png" hover "cog" ypos 6 action ShowMenu('preferences')
        imagebutton idle "images/skip1.png" hover "arrows" ypos 4 action Skip()
        imagebutton idle "images/save1.png" hover "disk" ypos 4 action ShowMenu('save')


##############################################################################
# Image maps
#
# All exploration maps here

screen yoursideblur_imagemap:
    imagemap:
        ground "yoursideblur"
        hover "yoursideblurmap"

        hotspot (213, 220, 426, 232) clicked Return("jeans") activate_sound "sounds/clothes.wav"
        hotspot (548, 453, 172, 90) clicked Return("condom") activate_sound "sounds/paper.wav"
        hotspot (0, 0, 591, 216) clicked Return("clothes") activate_sound "sounds/clothes.wav"
        hotspot (625, 163, 167, 57) clicked Return("flyer") activate_sound "sounds/paper.wav"
        hotspot (899, 325, 337, 170) clicked Return("phone") activate_sound "sounds/item.wav"
        hotspot (1239, 28, 681, 476) clicked Return("magazines") activate_sound "sounds/paper.wav"
        
    use quick_menu

screen yourside_imagemap:
    imagemap:
        ground "yourside"
        hover "yoursidemap"

        hotspot (213, 220, 426, 232) clicked Return("jeans") activate_sound "sounds/clothes.wav"
        hotspot (565, 460, 153, 81) clicked Return("condom") activate_sound "sounds/paper.wav"
        hotspot (0, 0, 591, 216) clicked Return("clothes") activate_sound "sounds/clothes.wav"
        hotspot (625, 163, 167, 57) clicked Return("flyer") activate_sound "sounds/paper.wav"
        hotspot (899, 325, 337, 170) clicked Return("phone") activate_sound "sounds/item.wav"
        hotspot (1239, 28, 681, 476) clicked Return("magazines") activate_sound "sounds/paper.wav"
        
    imagebutton idle "images/left1.png" hover "leftbutton" clicked Return('shelfmap') xpos 20 ypos 420 focus_mask True activate_sound "sounds/button.wav"
    imagebutton idle "images/leave_button1.png" hover "leavebutton" clicked Return('leaveattempt') xanchor 0.5 xpos 0.5 ypos 910 focus_mask True activate_sound "sounds/button.wav"
    
    use quick_menu
    
screen yourside_nojeans_imagemap:
    imagemap:
        ground "yourside_nojeans"
        hover "yoursidemap"

        hotspot (0, 0, 591, 216) clicked Return("clothes") activate_sound "sounds/clothes.wav"
        hotspot (625, 163, 167, 57) clicked Return("flyer") activate_sound "sounds/paper.wav"
        hotspot (565, 460, 153, 81) clicked Return("condom") activate_sound "sounds/paper.wav"
        hotspot (899, 325, 337, 170) clicked Return("phone") activate_sound "sounds/item.wav"
        hotspot (1239, 28, 681, 476) clicked Return("magazines") activate_sound "sounds/paper.wav"
        
    imagebutton idle "images/left1.png" hover "leftbutton" clicked Return('shelfmap') xpos 20 ypos 420 focus_mask True activate_sound "sounds/button.wav"
    imagebutton idle "images/leave_button1.png" hover "leavebutton" clicked Return('leaveattempt') xanchor 0.5 xpos 0.5 ypos 910 focus_mask True activate_sound "sounds/button.wav"
    
    use quick_menu
    
screen robinside_imagemap:
    imagemap:
        ground "robinside"
        hover "robinsidemap"

        hotspot (102, 573, 340, 257) clicked Return("wallet") activate_sound "sounds/item.wav"
        hotspot (537, 230, 521, 402) clicked Return("book") activate_sound "sounds/book.wav"
        hotspot (1170, 822, 187, 160) clicked Return("knickers") activate_sound "sounds/clothes.wav"
        hotspot (1560, 496, 232, 399) clicked Return("winebottle") activate_sound "sounds/glass.wav"
        hotspot (1660, 896, 260, 135) clicked Return("sock") activate_sound "sounds/clothes.wav"
        
    imagebutton idle "images/leave_button1.png" hover "leavebutton" clicked Return('leaveattempt') xanchor 0.5 xpos 0.5 ypos 910 focus_mask True activate_sound "sounds/button.wav"
    imagebutton idle "images/right1.png" hover "rightbutton" clicked Return('shelfmap') xanchor 1.0 xpos 1900 ypos 420 focus_mask True activate_sound "sounds/button.wav"
    
    use quick_menu
    
screen robinside_noboxers_imagemap:
    imagemap:
        ground "robinside_noboxers"
        hover "robinsidemap"

        hotspot (102, 573, 340, 257) clicked Return("wallet") activate_sound "sounds/item.wav"
        hotspot (537, 230, 521, 402) clicked Return("book") activate_sound "sounds/book.wav"
        hotspot (1170, 822, 187, 160) clicked Return("knickers") activate_sound "sounds/clothes.wav"
        hotspot (1560, 496, 232, 399) clicked Return("winebottle") activate_sound "sounds/glass.wav"
        
    imagebutton idle "images/leave_button1.png" hover "leavebutton" clicked Return('leaveattempt') xanchor 0.5 xpos 0.5 ypos 910 focus_mask True activate_sound "sounds/button.wav"
    imagebutton idle "images/right1.png" hover "rightbutton" clicked Return('shelfmap') xanchor 1.0 xpos 1900 ypos 420 focus_mask True activate_sound "sounds/button.wav"
    
    use quick_menu
    
screen shelves_imagemap:
    imagemap:
        ground "shelves"
        hover "shelvesmap"

        hotspot (256, 407, 125, 161) clicked Return("photoframe") activate_sound "sounds/item.wav"
        hotspot (440, 139, 276, 399) clicked Return("mirror") activate_sound "sounds/item.wav"
        hotspot (630, 542, 272, 54) clicked Return("laptop") activate_sound "sounds/item.wav"
        hotspot (158, 596, 746, 484) clicked Return("drawers") activate_sound "sounds/item.wav"
        hotspot (979, 342, 211, 63) clicked Return("dvd") activate_sound "sounds/book.wav"
        hotspot (943, 405, 700, 428) clicked Return("books") activate_sound "sounds/item.wav"
        hotspot (1719, 482, 182, 575) clicked Return("guitar") activate_sound "sounds/item.wav"
        hotspot (1495, 127, 142, 219) clicked Return("shirt") activate_sound "sounds/clothes.wav"
        hotspot (957, 926, 260, 154) clicked Return("vinyl") activate_sound "sounds/item.wav"
        
    imagebutton idle "images/left1.png" hover "leftbutton" clicked Return('farmap') xpos 20 ypos 420 focus_mask True activate_sound "sounds/button.wav"
    imagebutton idle "images/leave_button1.png" hover "leavebutton" clicked Return('leaveattempt') xanchor 0.5 xpos 0.5 ypos 910 focus_mask True activate_sound "sounds/button.wav"
    imagebutton idle "images/right1.png" hover "rightbutton" clicked Return('nearmap') xanchor 1.0 xpos 1900 ypos 420 focus_mask True activate_sound "sounds/button.wav"
    
    use quick_menu
    
screen shelves_noshirt_imagemap:
    imagemap:
        ground "shelves_noshirt"
        hover "shelvesmap"

        hotspot (256, 407, 125, 161) clicked Return("photoframe") activate_sound "sounds/item.wav"
        hotspot (440, 139, 276, 399) clicked Return("mirror") activate_sound "sounds/item.wav"
        hotspot (630, 542, 272, 54) clicked Return("laptop") activate_sound "sounds/item.wav"
        hotspot (158, 596, 746, 484) clicked Return("drawers") activate_sound "sounds/item.wav"
        hotspot (979, 342, 211, 63) clicked Return("dvd") activate_sound "sounds/book.wav"
        hotspot (943, 405, 700, 428) clicked Return("books") activate_sound "sounds/item.wav"
        hotspot (1719, 482, 182, 575) clicked Return("guitar") activate_sound "sounds/item.wav"
        hotspot (957, 926, 260, 154) clicked Return("vinyl") activate_sound "sounds/item.wav"
        
    imagebutton idle "images/left1.png" hover "leftbutton" clicked Return('farmap') xpos 20 ypos 420 focus_mask True activate_sound "sounds/button.wav"
    imagebutton idle "images/leave_button1.png" hover "leavebutton" clicked Return('leaveattempt') xanchor 0.5 xpos 0.5 ypos 910 focus_mask True activate_sound "sounds/button.wav"
    imagebutton idle "images/right1.png" hover "rightbutton" clicked Return('nearmap') xanchor 1.0 xpos 1900 ypos 420 focus_mask True activate_sound "sounds/button.wav"
    
    use quick_menu
    
screen frombed_search:
    imagebutton idle "images/left1.png" hover "leftbutton" clicked Return('farmap') xpos 20 ypos 420 focus_mask True activate_sound "sounds/button.wav"
    imagebutton idle "images/up1.png" hover "upbutton" clicked Return('shelfmap') xanchor 0.5 xpos 0.5 ypos 20 focus_mask True activate_sound "sounds/button.wav"
    imagebutton idle "images/leave_button1.png" hover "leavebutton" clicked Return('leaveattempt') xanchor 0.5 xpos 0.5 ypos 910 focus_mask True activate_sound "sounds/button.wav"
    imagebutton idle "images/right1.png" hover "rightbutton" clicked Return('nearmap') xanchor 1.0 xpos 1900 ypos 420 focus_mask True activate_sound "sounds/button.wav"
    
    use quick_menu