/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class Main
extends JFrame
implements ActionListener {
    private boolean hasUnsavedChanges = false;
    private JTable table = null;
    private JTable metaInfoTable = null;
    private Choice languagesCombo = null;
    private Object[][] data = new Object[0][];
    private String[] languages = null;
    private JButton saveButton = null;
    private JButton deleteButton = null;
    private JButton newRowButton = null;
    private JButton insertRowAboveButton = null;
    private JButton insertRowBelowButton = null;
    private JButton removeRowButton = null;
    private JButton translateButton = null;
    private JButton metaInfoButton = null;
    private JButton compareWithBaseLanguageButton = null;
    private JButton newButton = null;
    private TextArea newText = null;
    private String[] currentLanguageMetaInfo = new String[2];
    private List<Map.Entry<String, String>> baseLocaleStrings = new ArrayList<Map.Entry<String, String>>();

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.saveButton) {
            this.saveLanguage();
        } else if (actionEvent.getSource() == this.newRowButton) {
            this.addNewRowToEnd();
        } else if (actionEvent.getSource() == this.insertRowAboveButton) {
            this.insertNewRowAboveSelection();
        } else if (actionEvent.getSource() == this.insertRowBelowButton) {
            this.insertNewRowBelowSelection();
        } else if (actionEvent.getSource() == this.removeRowButton) {
            this.removeSelectedRow();
        } else if (actionEvent.getSource() == this.metaInfoButton) {
            this.showMetaInfoDialog();
        } else if (actionEvent.getSource() == this.newButton) {
            this.copyNewLanguage();
        } else if (actionEvent.getSource() == this.translateButton) {
            this.translateSelectedItem();
        } else if (actionEvent.getSource() == this.deleteButton) {
            this.deleteSelectedLanguage();
        } else if (actionEvent.getSource() == this.compareWithBaseLanguageButton) {
            this.compareWithBaseStrings();
        }
    }

    private void compareWithBaseStrings() {
        int n = 0;
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        for (Map.Entry<String, String> entry : this.baseLocaleStrings) {
            String string = entry.getKey();
            int n2 = this.table.getRowCount();
            boolean bl = false;
            for (int i = 0; i < n2; ++i) {
                String string2 = (String)defaultTableModel.getValueAt(i, 0);
                if (!string.equals(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            defaultTableModel.insertRow(this.table.getRowCount(), new Object[]{string, ""});
            ++n;
        }
        if (n > 0) {
            defaultTableModel.fireTableDataChanged();
            if (n > 1) {
                JOptionPane.showMessageDialog(null, n + " keys from base localization file were added to the end of the table.");
            } else {
                JOptionPane.showMessageDialog(null, n + " key from base localization file was added to the end of the table.");
            }
        } else {
            JOptionPane.showMessageDialog(null, "All keys present.");
        }
    }

    public static boolean deleteDirectory(File file) {
        File[] fileArray;
        if (file.exists() && null != (fileArray = file.listFiles())) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    Main.deleteDirectory(fileArray[i]);
                    continue;
                }
                fileArray[i].delete();
            }
        }
        return file.delete();
    }

    private void deleteSelectedLanguage() {
        String string = this.languagesCombo.getSelectedItem();
        if (string.equals("en")) {
            return;
        }
        File file = new File("../localization/" + string);
        Main.deleteDirectory(file);
        this.populateLanguagesCombo();
        this.languagesCombo.select(0);
        if (this.languagesCombo.getSelectedItem().equals("en")) {
            this.translateButton.setEnabled(false);
            this.compareWithBaseLanguageButton.setEnabled(false);
            return;
        }
    }

    private String getBaseString(String string) {
        for (Map.Entry<String, String> entry : this.baseLocaleStrings) {
            if (!entry.getKey().equals(string)) continue;
            return entry.getValue();
        }
        return null;
    }

    private void translateSelectedItem() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        int n = this.table.getSelectedRow();
        this.table.setEnabled(false);
        if (n < 0) {
            return;
        }
        String string = (String)defaultTableModel.getValueAt(n, 0);
        JFrame jFrame = new JFrame();
        jFrame.setSize(500, 370);
        jFrame.setTitle(string);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Main.this.table.setEnabled(true);
                DefaultTableModel defaultTableModel = (DefaultTableModel)Main.this.table.getModel();
                int n = Main.this.table.getSelectedRow();
                String string = (String)defaultTableModel.getValueAt(n, 1);
                defaultTableModel.setValueAt(Main.this.newText.getText(), n, 1);
                if (!string.equals(Main.this.newText.getText())) {
                    Main.this.hasUnsavedChanges = true;
                    Main.this.checkSaveButtonTitle();
                }
                Main.this.table.setEnabled(true);
            }
        });
        jFrame.setLocationRelativeTo(null);
        String string2 = this.getBaseString(string);
        String string3 = (String)defaultTableModel.getValueAt(n, 1);
        Label label = new Label("en");
        Label label2 = new Label(this.languagesCombo.getSelectedItem());
        TextArea textArea = new TextArea(string2, 7, 20, 1);
        this.newText = new TextArea(string3, 7, 20, 1);
        textArea.setEditable(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.add(label);
        jPanel.add(textArea);
        jPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        jPanel.add(label2);
        jPanel.add(this.newText);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jFrame.getContentPane().add((Component)jPanel, "Center");
        jFrame.setVisible(true);
    }

    private void showMetaInfoDialog() {
        JFrame jFrame = new JFrame();
        jFrame.setSize(400, 330);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DefaultTableModel defaultTableModel = (DefaultTableModel)Main.this.metaInfoTable.getModel();
                String string = Main.this.currentLanguageMetaInfo[0];
                String string2 = Main.this.currentLanguageMetaInfo[1];
                ((Main)Main.this).currentLanguageMetaInfo[0] = (String)defaultTableModel.getValueAt(0, 1);
                ((Main)Main.this).currentLanguageMetaInfo[1] = (String)defaultTableModel.getValueAt(1, 1);
                if (!string.equals(Main.this.currentLanguageMetaInfo[0]) || !string2.equals(Main.this.currentLanguageMetaInfo[1])) {
                    Main.this.hasUnsavedChanges = true;
                    Main.this.checkSaveButtonTitle();
                }
            }
        });
        Container container = jFrame.getContentPane();
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        this.metaInfoTable = new JTable(defaultTableModel);
        this.metaInfoTable.setFillsViewportHeight(true);
        this.metaInfoTable.getTableHeader().setReorderingAllowed(false);
        this.metaInfoTable.setRowHeight(20);
        this.metaInfoTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.metaInfoTable);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.add(jScrollPane);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        container.add((Component)jPanel, "Center");
        defaultTableModel.addColumn("Key");
        defaultTableModel.addColumn("Text");
        this.metaInfoTable.getColumnModel().getColumn(0).setMaxWidth(150);
        this.metaInfoTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        defaultTableModel.setRowCount(0);
        defaultTableModel.addRow(new Object[]{"name", this.currentLanguageMetaInfo[0]});
        defaultTableModel.addRow(new Object[]{"translator", this.currentLanguageMetaInfo[1]});
        jFrame.setVisible(true);
    }

    private void checkSaveButtonTitle() {
        if (this.hasUnsavedChanges) {
            this.saveButton.setText("Save *");
        } else {
            this.saveButton.setText("Save");
        }
    }

    private void addNewRowToEnd() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        defaultTableModel.addRow(new Object[]{"", ""});
        defaultTableModel.fireTableDataChanged();
        this.table.changeSelection(this.table.getRowCount() - 1, 0, false, false);
        this.hasUnsavedChanges = true;
        this.checkSaveButtonTitle();
    }

    private void insertNewRowAboveSelection() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return;
        }
        defaultTableModel.insertRow(n, new Object[]{"", ""});
        defaultTableModel.fireTableDataChanged();
        this.table.changeSelection(n, 0, false, false);
        this.hasUnsavedChanges = true;
        this.checkSaveButtonTitle();
    }

    private void insertNewRowBelowSelection() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return;
        }
        defaultTableModel.insertRow(n + 1, new Object[]{"", ""});
        defaultTableModel.fireTableDataChanged();
        this.table.changeSelection(n + 1, 0, false, false);
        this.hasUnsavedChanges = true;
        this.checkSaveButtonTitle();
    }

    private void removeSelectedRow() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return;
        }
        defaultTableModel.removeRow(n);
        defaultTableModel.fireTableDataChanged();
        if (this.table.getRowCount() > 0) {
            if (n >= this.table.getRowCount()) {
                n = this.table.getRowCount() - 1;
            }
            this.table.changeSelection(n, 0, false, false);
        }
        this.hasUnsavedChanges = true;
        this.checkSaveButtonTitle();
    }

    private void saveLanguage() {
        String string = this.languagesCombo.getSelectedItem();
        int n = this.table.getRowCount();
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        try {
            String string2 = "../localization/" + string + "/strings.dat";
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string2), "UTF-8");
            for (int i = 0; i < n; ++i) {
                String string3 = (String)defaultTableModel.getValueAt(i, 0);
                String string4 = (String)defaultTableModel.getValueAt(i, 1);
                outputStreamWriter.write(string3 + ": " + string4 + "\n");
            }
            outputStreamWriter.close();
            this.hasUnsavedChanges = false;
            this.checkSaveButtonTitle();
        }
        catch (Exception exception) {
            System.err.println("Error: " + exception.getMessage());
        }
        this.saveMetadata(string);
    }

    private void saveMetadata(String string) {
        try {
            String string2 = "../localization/" + string + "/meta.dat";
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string2), "UTF-8");
            outputStreamWriter.write("name: " + this.currentLanguageMetaInfo[0] + "\n");
            outputStreamWriter.write("translator: " + this.currentLanguageMetaInfo[1] + "\n");
            outputStreamWriter.close();
        }
        catch (Exception exception) {
            System.err.println("Error: " + exception.getMessage());
        }
    }

    private void loadLanguageMetaData(String string) {
        String string2;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            string2 = "../localization/" + string + "/meta.dat";
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(string2), "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        bufferedReader = new BufferedReader(inputStreamReader);
        try {
            string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                int n;
                if (string2.length() == 0 || (n = string2.indexOf(":")) == -1) continue;
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                if (string4.length() > 0 && string4.charAt(0) == ' ') {
                    string4 = string4.substring(1);
                }
                if (string3.equals("name")) {
                    this.currentLanguageMetaInfo[0] = string4;
                    continue;
                }
                if (!string3.equals("translator")) continue;
                this.currentLanguageMetaInfo[1] = string4;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            inputStreamReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void populateLanguageData(String string) {
        String string2;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            string2 = "../localization/" + string + "/strings.dat";
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(string2), "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        bufferedReader = new BufferedReader(inputStreamReader);
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        defaultTableModel.setRowCount(0);
        try {
            while ((string2 = bufferedReader.readLine()) != null) {
                int n;
                if (string2.length() == 0 || (n = string2.indexOf(":")) == -1) continue;
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                if (string4.length() > 0 && string4.charAt(0) == ' ') {
                    string4 = string4.substring(1);
                }
                defaultTableModel.addRow(new Object[]{string3, string4});
            }
            this.loadLanguageMetaData(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        defaultTableModel.fireTableDataChanged();
        if (this.table.getRowCount() > 0 && this.table.getSelectedRow() < 0) {
            this.table.changeSelection(0, 0, false, false);
        }
        try {
            inputStreamReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string.equals("en")) {
            this.translateButton.setEnabled(false);
            this.compareWithBaseLanguageButton.setEnabled(false);
        } else {
            this.translateButton.setEnabled(true);
            this.compareWithBaseLanguageButton.setEnabled(true);
            this.loadBaseLocale();
        }
    }

    private void loadBaseLocale() {
        Object object;
        BufferedReader bufferedReader = null;
        try {
            object = new FileInputStream("../localization/en/strings.dat");
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Strings file not found!");
        }
        this.baseLocaleStrings.clear();
        try {
            while ((object = bufferedReader.readLine()) != null) {
                int n;
                if (((String)object).length() == 0 || (n = ((String)object).indexOf(":")) == -1) continue;
                String string = ((String)object).substring(0, n);
                String string2 = ((String)object).substring(n + 1);
                if (string2.length() > 0 && string2.charAt(0) == ' ') {
                    string2 = string2.substring(1);
                }
                AbstractMap.SimpleEntry<String, String> simpleEntry = new AbstractMap.SimpleEntry<String, String>(string, string2);
                this.baseLocaleStrings.add(simpleEntry);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    Main() {
        super("Pioneers Localization Tool");
        this.setBounds(100, 100, 900, 600);
        this.setDefaultCloseOperation(3);
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn("Key");
        defaultTableModel.addColumn("Text");
        Container container = this.getContentPane();
        this.languagesCombo = new Choice();
        this.languagesCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Main.this.populateLanguageData(Main.this.languagesCombo.getSelectedItem());
            }
        });
        this.populateLanguagesCombo();
        this.table = new JTable(defaultTableModel);
        this.table.setFillsViewportHeight(true);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setRowHeight(20);
        this.table.setSelectionMode(0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.deleteButton = new JButton("Delete");
        this.newButton = new JButton("New");
        this.metaInfoButton = new JButton("Meta info");
        this.compareWithBaseLanguageButton = new JButton("Compare with base");
        this.saveButton = new JButton("Save");
        jPanel.add(this.languagesCombo);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel.add(this.deleteButton);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel.add(this.newButton);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel.add(this.metaInfoButton);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel.add(this.compareWithBaseLanguageButton);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.saveButton);
        this.saveButton.setMnemonic(83);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        jPanel2.add(jScrollPane);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 2));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.newRowButton = new JButton("Add row");
        this.insertRowAboveButton = new JButton("Insert above");
        this.insertRowBelowButton = new JButton("Insert below");
        this.removeRowButton = new JButton("Remove selected row");
        this.translateButton = new JButton("Translate");
        this.translateButton.setMnemonic(84);
        jPanel3.add(this.newRowButton);
        jPanel3.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel3.add(this.insertRowAboveButton);
        jPanel3.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel3.add(this.insertRowBelowButton);
        jPanel3.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel3.add(this.removeRowButton);
        jPanel3.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel3.add(this.translateButton);
        container.add((Component)jPanel, "First");
        container.add((Component)jPanel2, "Center");
        container.add((Component)jPanel3, "Last");
        this.table.getColumnModel().getColumn(0).setMaxWidth(380);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(250);
        this.setVisible(true);
        this.saveButton.addActionListener(this);
        this.newRowButton.addActionListener(this);
        this.insertRowAboveButton.addActionListener(this);
        this.insertRowBelowButton.addActionListener(this);
        this.removeRowButton.addActionListener(this);
        this.metaInfoButton.addActionListener(this);
        this.compareWithBaseLanguageButton.addActionListener(this);
        this.newButton.addActionListener(this);
        this.translateButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.populateLanguageData("en");
    }

    private static void copyFolder(File file, File file2) throws IOException {
        if (file.isDirectory()) {
            String[] stringArray;
            if (!file2.exists()) {
                file2.mkdir();
                System.out.println("Directory copied from " + file + "  to " + file2);
            }
            for (String string : stringArray = file.list()) {
                File file3 = new File(file, string);
                File file4 = new File(file2, string);
                Main.copyFolder(file3, file4);
            }
        } else {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
            System.out.println("File copied from " + file + " to " + file2);
        }
    }

    private void populateLanguagesCombo() {
        File file = new File("../localization");
        this.languages = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return new File(file, string).isDirectory();
            }
        });
        this.languagesCombo.removeAll();
        for (String string : this.languages) {
            this.languagesCombo.add(string);
        }
    }

    private void copyNewLanguage() {
        String string = (String)JOptionPane.showInputDialog(this, "New locale to add (abbreviation):", "New", -1, null, null, "");
        if (string != null && string.length() > 0) {
            File file = new File("../localization/en");
            File file2 = new File("../localization/" + string);
            try {
                Main.copyFolder(file, file2);
                this.populateLanguagesCombo();
                this.languagesCombo.select(string);
                this.currentLanguageMetaInfo[0] = "";
                this.currentLanguageMetaInfo[1] = "";
                this.saveMetadata(string);
                this.translateButton.setEnabled(true);
                this.compareWithBaseLanguageButton.setEnabled(true);
                this.loadBaseLocale();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
    }

    public static void main(String[] stringArray) {
        new Main();
    }
}

