local D = {}

function D.show (index)

	DialogManager.CurrentDialogIndex = index

	if index == 1 then
		DialogManager.showDialog({key = "charter_text_1", options = {{key = "continue", id = 1}}})
	elseif index == 2 then
		DialogManager.showDialog({key = "post_charter_text", options = {{key = "continue", id = ConstEndDialog}}})
	end

end

-- Called when choosing an reply option from the list
function D.dismiss (index, identifier)

	if identifier == 1 then
		gGUI.showMessageBox({
							text = DialogManager.translate("msg_hire"),
							title = DialogManager.translate("msg_hire_title"),
							type = MessageBoxType.Confirmation,
							id = 500,
							verticalAlign = VerticalAlignment.Middle
    })
		return
	end

	-- Reply that indicates to end the dialog tree
	if identifier == ConstEndDialog then
		DialogManager.endCurrentDialogTree()
		return
	end

	D.show(DialogManager.CurrentDialogIndex + 1)
end

-- Called when dialog tree is initialized
function D.started ()
	D.show(1)
end

-- Called when dialog tree is terminated
function D.ended()

end


function D.messageBoxDismissed(args)

	if args.id == 500 then

		-- Yes
		if args.button == 2 then
			gVarStore.setBool("barlow_hired", true)

      D.show(2)

			gParty.createShip({
				type = ShipType.Chatellin,
				chartered = true
			})

			return true

		-- No
		elseif args.button == 1 then
			DialogManager.endCurrentDialogTree()
		end
	end

	return false

end


-- Register globally
DialogManager.Dialogs["captainbarlow"].DialogTrees["ask_about_charter"] = D

gLuaHandler.registerDelegateCallbacks(D, Delegates.MessageBox, 0, D.messageBoxDismissed)
