local D = {}

function D.getId ()
	return "captainbarlow"
end

function D.isAvailable ()
	return 	gVarStore.getBool("barlow_in_town") == true and
					gVarStore.getBool("barlow_dismissed") == false and
					Town.getCurrentTownIndex() + 1 == Towns.Marciudad
end

function D.getName ()
	return DialogManager.translate("title", D.getId())
end

function D.getTopics ()

	local topics = {}

	table.insert(topics, "greet")

	if DialogManager.isDialogTreeOpened("greet", D.getId()) == true and gVarStore.getBool("barlow_hired") == false then
		table.insert(topics, "ask_about_charter")
	end

	return topics

end

function D.getTopicTitle (topicKey)
	return nil
end

function D.seasonPassed (args)
	if QuestManager.questCompleted({id="spicerun"}) == false and gGame.getState() == GameState.Town and args.season == Season.Summer and args.year == 1500 then
		print("Summertime - Captain Barlow has arrived!")
		gVarStore.setBool("barlow_in_town", true)
		gGUI.showInfoMessage({key = "captain_barlow_arrival", delay = 0.8});
	end
	return false
end

-- Register globally
DialogManager.Dialogs[D.getId()] = D

gLuaHandler.registerDelegateCallbacks(D, Delegates.PassSeason, 0, D.seasonPassed)
