local D = {}

function D.getId ()
	return "harbormaster2"
end

function D.isAvailable ()
	return (DialogManager.isDialogAvailable(D.getId()) and Town.getCurrentTownIndex() + 1 == Towns.Oldden)
end

function D.getName ()
	return DialogManager.translate("title", D.getId())
end

function D.getTopics ()

	local topics = {}

	table.insert(topics, "greet")

	if DialogManager.isDialogTreeOpened("greet", D.getId()) then
		table.insert(topics, "ask_travel")
	end

	if DialogManager.isDialogTreeOpened("ask_travel", D.getId()) and gVarStore.getInt("ales_bought") ~= 2 then
		table.insert(topics, "buy_ale")
	end

	return topics

end

function D.getTopicTitle (topicKey)

	print("ales_bought = "..gVarStore.getInt("ales_bought"))

	if topicKey == "buy_ale" then

		if gVarStore.getInt("ales_bought") == 0 then
			return DialogManager.translate("buy_ale_1", D.getId())

		elseif gVarStore.getInt("ales_bought") == 1 then
			return DialogManager.translate("buy_ale_2", D.getId())

		end
	else
		return nil
	end
end

-- Register globally
DialogManager.Dialogs[D.getId()] = D
