local D = {}

function D.getId ()
	return "tavernkeeper2"
end

function D.isAvailable ()
	return (--[[ DialogManager.isDialogAvailable(D.getId()) and ]]--
			Town.getCurrentTownIndex() + 1 == Towns.Oldden)
end

function D.getName ()
	return DialogManager.translate("title", D.getId())
end

function D.getTopics ()

	local topics = {}

	table.insert(topics, "greet")

	if DialogManager.isDialogTreeOpened("greet", D.getId()) then

		table.insert(topics, "what_happened")

		if DialogManager.isDialogTreeOpened("what_happened", D.getId()) then
			if gVarStore.getBool("start_supplystore_visited") == true then
				table.insert(topics, "ask_about_store")
			else
				table.insert(topics, "ask_store")
			end
		end

	end

	return topics

end

function D.getTopicTitle (topicKey)
	return nil
end

-- Register globally
DialogManager.Dialogs[D.getId()] = D
