local I = {}

local listElement, selectionIndicatorArrow, selectedHutSize = nil, nil, 1

function I.close ()
	gGUI.scheduleForDeletion(I.window.instance())
	UI.Interfaces["campsite_upgrade"] = nil
	I = nil
end

function I.create ()

	I.window = LuaWindow(gGUI.createWindow({
		width = 200,
		height = 240,
		verticalAlignment = VerticalAlignment.Middle,
		id = "campUpgrd",
		title = "%upgrade_camp_wnd_title"
	}))

	local closeButton = LuaButton(gGUI.createButton({
		parent = I.window.instance(),
		x = (I.window.getWidth() / 2) - 82,
		y = I.window.getHeight() - 13,
		width = 80,
		height = 18,
		title = "%cancel_button",
		id = "closeCampsiteUpgrd",
		bindClose = true
	}))

	closeButton.onClick(I.close)

	local buildButton = LuaButton(gGUI.createButton({
		parent = I.window.instance(),
		x = (I.window.getWidth() / 2) + 2,
		y = I.window.getHeight() - 13,
		width = 80,
		height = 18,
		title = "%upgrade_camp_build_button",
		id = "camp_buildButton",
		bindConfirmation = true
	}))

	buildButton.onClick(I.build)

	--[[LuaImage(gGUI.createImage({
		parent = I.window.instance(),
		x = 32,
		y = 35,
		width = 32,
		height = 32,
		image = gSpriteManager.getSprite(21, SpriteGroup.Object)
	}))]]--

	gGUI.createTextBlock({
		parent = I.window.instance(),
		x = 10,
		y = 20,
		width = 170,
		text = "%hut_build_desc"
	})

	gGUI.createTitleBar({
		parent = I.window.instance(),
		width = I.window.getWidth() - 10,
		y = 100,
		x = 5,
		title = "%hut_build_type"
	})

	local shelterButton = LuaButton(gGUI.createButton({
		parent = I.window.instance(),
		image = gSpriteManager.getSprite(23, SpriteGroup.Object),
		x = 28,
		y = 113,
		width = 32,
		height = 32
	}))

	gGUI.createText({
		parent = I.window.instance(),
		font = 5,
		color = 3,
		x = 10,
		y = 145,
		width = 66,
		height = 10,
		text = "%upgrade_camp_shelter",
		hAlign = HorizontalAlignment.Center
	})

	local smallHutButton = LuaButton(gGUI.createButton({
		parent = I.window.instance(),
		image = gSpriteManager.getSprite(22, SpriteGroup.Object),
		x = 81,
		y = 113,
		width = 32,
		height = 32
	}))

	gGUI.createText({
		parent = I.window.instance(),
		font = 5,
		color = 3,
		x = 66,
		y = 145,
		width = 66,
		height = 10,
		text = "%upgrade_camp_small_hut",
		hAlign = HorizontalAlignment.Center
	})

	local largeHutButton = LuaButton(gGUI.createButton({
		parent = I.window.instance(),
		image = gSpriteManager.getSprite(21, SpriteGroup.Object),
		x = 126,
		y = 111,
		width = 64,
		height = 32
	}))

	gGUI.createText({
		parent = I.window.instance(),
		font = 5,
		color = 3,
		x = 123,
		y = 145,
		width = 66,
		height = 10,
		text = "%upgrade_camp_large_hut",
		hAlign = HorizontalAlignment.Center
	})

	selectionIndicatorArrow = LuaImage(gGUI.createImage({
		parent = I.window.instance(),
		x = 39,
		y = 155,
		width = 9,
		height = 5,
		image = gSpriteManager.getSprite(191, SpriteGroup.GUI)
	}))

	gGUI.createTitleBar({
		parent = I.window.instance(),
		width = I.window.getWidth() - 10,
		y = 160,
		x = 5,
		title = "%title_requirements"
	})

 	listElement = LuaList(gGUI.createList({
		parent = I.window.instance(),
		x = 7,
		y = 172,
		width = I.window.getWidth() - 14,
		visibleRows = 5,
		showSelection = false
	}))

	shelterButton.onClick(function()
			selectionIndicatorArrow.setX(39)
			selectedHutSize = 1
			I.populateList()
	end)

	largeHutButton.onClick(function()
			selectionIndicatorArrow.setX(152)
			selectedHutSize = 3
			I.populateList()
	end)

	smallHutButton.onClick(function()
			selectionIndicatorArrow.setX(94)
			selectedHutSize = 2
			I.populateList()
	end)

	I.populateList()

end

function I.populateList ()

		local listDataSource = LuaListDataSource(listElement.getDataSource())

		listDataSource.removeAllItems()

		local woodNeeded = __ternary(selectedHutSize == 1, 20, __ternary(selectedHutSize == 2, 80, 120))
		local stoneNeeded = __ternary(selectedHutSize == 1, 0, __ternary(selectedHutSize == 2, 15, 30))

	 	local selectedPlayer = LuaPlayer(gParty.getSelectedPlayer())
		local playerParams = LuaPlayerParams(selectedPlayer.getParams())
		local campObject = LuaMapObjCamp(gWorld.staticObjectForID(playerParams.campID()))
		local campInventory = LuaInventory(campObject.getInventory())

		local woodItem = LuaInventoryItem(campInventory.getItemOfType({primary = ItemDefinitions.Wood}))
		local stoneItem = LuaInventoryItem(campInventory.getItemOfType({primary = ItemDefinitions.Stone}))

		-- Shelters don't need constuction skill
		if selectedHutSize > 1 then
			local listItem1 = LuaListDataItem(listDataSource.addItem({ key = "camp_build_requirement_skill" }))
			listItem1:icon(gSpriteManager.getSprite(121, SpriteGroup.GUI))

			if playerParams.hasSkill(Skill.Construction) == true then
				listItem1:accessoryType(ListRowAccessory.CheckmarkDark)
			else
				listItem1:accessoryType(ListRowAccessory.Cross)
			end
		end

		local listItem2 = LuaListDataItem(listDataSource.addItem({ text = string.format(gUtils.translate("camp_build_wood_format"), woodNeeded) }))
		listItem2:icon(gSpriteManager.getSprite(121, SpriteGroup.GUI))

		if woodItem.instance() == nil then
			listItem2:accessoryType(ListRowAccessory.Cross)
		else
			listItem2:accessoryType(ListRowAccessory.CheckmarkDark)
		end

		--[[if stoneNeeded > 0 then
			local listItem3 = LuaListDataItem(listDataSource.addItem({ text = "Gathered "..stoneNeeded.." units of stone" }))
			listItem3:icon(gSpriteManager.getSprite(121, SpriteGroup.GUI))

			if stoneItem.instance() == nil then
				listItem3:accessoryType(ListRowAccessory.Cross)
			else
				listItem3:accessoryType(ListRowAccessory.CheckmarkDark)
			end
		end]]--

end

function I.build ()

	print("Build ...")

 	local selectedPlayer = LuaPlayer(gParty.getSelectedPlayer())
	local playerParams = LuaPlayerParams(selectedPlayer.getParams())
	local campObject = LuaMapObjCamp(gWorld.staticObjectForID(playerParams.campID()))
	local campInventory = LuaInventory(campObject.getInventory())

	local woodNeeded = __ternary(selectedHutSize == 1, 20, __ternary(selectedHutSize == 2, 80, 120))
	local stoneNeeded = __ternary(selectedHutSize == 1, 0, __ternary(selectedHutSize == 2, 15, 30))

	local woodItem = LuaInventoryItem(campInventory.getItemOfType({primary = ItemDefinitions.Wood.index}))

	local enoughWoodToBuild = false

	if woodItem.instance() ~= nil then
		print("woodItem count = ", woodItem.param3())
		if woodItem.param3() >= woodNeeded then
			enoughWoodToBuild = true
		end
	end

	if selectedHutSize > 1 and playerParams.hasSkill(Skill.Construction) == false then
		gGUI.showInformation({ key = "not_proficient_in_construction" })
		return
	end

	if enoughWoodToBuild == false then
		gGUI.showInformation({ key = "not_enough_wood_to_build" })
		return
	end

	campObject.buildHousing(selectedPlayer.instance(), woodNeeded, selectedHutSize)

	I.close()

end

UI.Interfaces["campsite_upgrade"] = I
