local I = {}

function I.close ()
	gGUI.scheduleForDeletion(I.window.instance())
	UI.Interfaces["change_dialog"] = nil
	I = nil
end

function I.create ()

	print("Change dialog window")

	I.window = LuaWindow(gGUI.createWindow({
		width = 130,
		height = 160,
		verticalAlignment = VerticalAlignment.Middle,
		id = "changeDlgWnd",
		title = "%switch_dialog_window_title"
	}))

	I.list = LuaList(gGUI.createList({
		parent = I.window.instance(),
		x = 8,
		y = 19,
		width = 116,
		visibleRows = 8,
		rowHeight = 12,
		showSeparator = false,
		showSelection = false,
		textIndent = -4,
		debugData = 5
	}))

	local closeButton = LuaButton(gGUI.createButton({
		parent = I.window.instance(),
		x = (I.window.getWidth() / 2) - 40,
		y = I.window.getHeight() - 13,
		width = 80,
		height = 18,
		title = "%close_button"
	}))


	-- Bindings
	closeButton.onClick(I.close)

end

function I.fillList ()

	local dataSource = LuaListDataSource(I.list.getDataSource())
	local dialogs = DialogManager.listAllAvailableDialogs()
	local unopenedTopicIcon = gSpriteManager.getSprite(3, SpriteGroup.DialogScreen)
	local openedTopicIcon = gSpriteManager.getSprite(4, SpriteGroup.DialogScreen)

	dataSource.removeAllItems()

	-- Add all characters to list
	for i = 1, #dialogs do
		dataSource.addItem({
			text 			= DialogManager.Dialogs[dialogs[i]].getName(),
			str1 			= dialogs[i],
			accessoryType 	= ListRowAccessory.DisclosureDark,
			icon 			= __ternary(DialogManager.newDialogTopicsAvailable(dialogs[i]), unopenedTopicIcon, openedTopicIcon)
		})
	end
end

function I.onEventGUI (args)
	if args.type == EventGUI.ListItemClicked and I.list.instance() == args.source then
			local listWidget = LuaList(args.source)
			local listDataSource = LuaListDataSource(listWidget.getDataSource())
			local listItem = LuaListDataItem(listDataSource.getItemAtIndex(listWidget.getSelectedRow()))

			DialogManager.changeDialog(listItem.str1())


			I.close()
	end
end

UI.Interfaces["change_dialog"] = I
