local I = {}

function I.create ()

  local player = LuaPlayer(gParty.getSelectedPlayer())
  I.campsite = LuaMapObjCamp(gWorld.getPlayerCampsite(player.instance()))

  if I.campsite.instance() == nil then
    UI.Interfaces["cooking"] = nil
  	I = nil
    return
  end

  if I.campsite.hasFire() == false then
    gGUI.showInformation({ key = "need_fire_to_cook_msg"})
    UI.Interfaces["cooking"] = nil
    I = nil
    return
  end

  local campInventory = LuaInventory(I.campsite.getInventory())
  local rawItems = campInventory.getItemsWithCategory(ItemCategory.Raw)

  if #rawItems == 0 then
    UI.Interfaces["cooking"] = nil
    I = nil
    gGUI.showInformation({ key = "no_foods_to_cook" })
    return
  end


	I.window = LuaWindow(gGUI.createWindow({
		width = 268,
		height = 145,
		verticalAlignment = VerticalAlignment.Middle,
		id = "cookWnd",
		title = "%cooking_wnd_title"
	}))

	I.table = LuaTable(gGUI.createTable({
		parent = I.window.instance(),
		x = 8,
		y = 29,
		visibleRows = 4,
		rowHeight = 16,
		id = "rawFoodTable",
    font = 5
	}))

	-- 231
	I.table.addColumn(100)
	I.table.addColumn(50)

  I.table.onRowSelected(function(row)
    I.populateCuisines()
  end)

  gGUI.createText({
    parent = I.window.instance(),
    text = "%cooking_ingredient",
    x = 10,
    y = 24,
    color = 2,
    font = 5
  })

  gGUI.createText({
    parent = I.window.instance(),
    text = "%cooking_ingredient_amount",
    x = 110,
    y = 24,
    color = 2,
    font = 5
  })

  gGUI.createText({
    parent = I.window.instance(),
    text = "%cooking_cuisine_list",
    x = 166,
    y = 24,
    color = 2,
    font = 5
  })



  I.optionsList = LuaList(gGUI.createList({
    parent = I.window.instance(),
    x = 164,
    y = 30,
    width = 95,
    visibleRows = 4,
    outline = true,
    id = "foodOptions",
		rowHeight = 16,
    showSeparator = false
  }))

  I.optionsList.onItemSelected(function(row, item)
    I.selectFood(row)
  end)

  --[[I.spicesCheckbox = LuaCheckBox(gGUI.createCheckBox({
    parent = I.window.instance(),
    text = "Use spices",
    x = 165,
    y = 84,
    on = true
  }))]]--


	I.table.onReloadData(I.populateRawFoods)

  gGUI.createImage({
    parent = I.window.instance(),
    x = 20,
    y = 112,
    width = 32,
    height = 32,
    sprite = gSpriteManager.getSprite(202, SpriteGroup.GUI)
  })

  gGUI.createText({
    parent = I.window.instance(),
    x = 37,
    y = 102,
    text = "%cooking_food_production_label",
    width = I.window.getWidth() - 20,
    height = 10,
    textAlign = HorizontalAlignment.Left,
    font = 0
  })

  I.foodProductionLabel = LuaText(gGUI.createText({
    parent = I.window.instance(),
    x = 37,
    y = 113,
    text = "4.0 units",
    width = I.window.getWidth() - 20,
    textAlign = HorizontalAlignment.Left,
    height = 10,
    font = 3,
    color = 2
  }))

	local closeButton = LuaButton(gGUI.createButton({
		parent = I.window.instance(),
		x = (I.window.getWidth() / 2) - 113,
		y = I.window.getHeight() - 13,
		width = 100,
		height = 18,
		title = "%close_button",
    id = "xFoodWnd",
    bindClose = true
	}))

	closeButton.onClick(function()
		gGUI.scheduleForDeletion(I.window.instance())
		UI.Interfaces["cooking"] = nil
		I = nil
	end)

	local cookButton = LuaButton(gGUI.createButton({
		parent = I.window.instance(),
		x = (I.window.getWidth() / 2) + 3 - 10,
		y = I.window.getHeight() - 13,
		width = 120,
		height = 18,
		title = "%cooking_start_button",
    id = "startCookingBtn",
    bindConfirmation = true
	}))

  cookButton.onClick(function()
    local foodsListDataSource = LuaListDataSource(I.optionsList.getDataSource())
    local foodListItem = LuaListDataItem(foodsListDataSource.getItemAtIndex(I.optionsList.getSelectedRow()))
    local foodType = foodListItem.iValue1()
    print("foodType = ", foodType)
    I.campsite.startCooking(gParty.getSelectedPlayer(), foodType, I.foodProductionPerTurn[foodType])
		gGUI.scheduleForDeletion(I.window.instance())
		UI.Interfaces["cooking"] = nil
		I = nil
  end)

  I.table.reloadData()

end

function I.populateRawFoods ()

  I.table.removeAllRows()

  local campInventory = LuaInventory(I.campsite.getInventory())
  local rawItems = campInventory.getItemsWithCategory(ItemCategory.Raw)

  for i=1, #rawItems do

    local item = LuaInventoryItem(rawItems[i])
    local itemDefinition = ItemDefinitionIndexes[item.type()]

		-- Item title
		I.table.addItemIVal({
			column = 0,
			text = gUtils.translate(itemDefinition.name),
			icon = gSpriteManager.getSprite(itemDefinition.index, SpriteGroup.Inventory),
			value = item.type()
		})

		-- Amount owned
		I.table.addItemIVal({
			column = 1,
			text = string.format("%.1f", item.param3()),
			textAlignment = HorizontalAlignment.Left
		})

  end

  if #rawItems > 0 then
    if I.table.getSelectedRow() < 0 then
      I.table.setSelectedRow(0)
    elseif I.table.getSelectedRow() >= #rawItems then
      I.table.setSelectedRow(#rawItems - 1)
    end
  end

  I.populateCuisines()

end

function I.populateCuisines ()

  local foodsListDataSource = LuaListDataSource(I.optionsList.getDataSource())
  local rawFoodsListDataSource = LuaListDataSource(LuaList(I.table.getColumn(0)).getDataSource())
  local rawMaterialType = LuaListDataItem(rawFoodsListDataSource.getItemAtIndex(I.table.getSelectedRow())).iValue1()

  foodsListDataSource.removeAllItems()

  if rawMaterialType == ItemDefinitions.FishRaw.index then
    foodsListDataSource.addItem({ key = "food_dried_fish", iValue1 = Foods.DriedFish, icon = gSpriteManager.getSprite(ItemDefinitions.FishDried.index, SpriteGroup.Inventory) })
    foodsListDataSource.addItem({ key = "food_cooked_fish", iValue1 = Foods.CookedFish, icon = gSpriteManager.getSprite(ItemDefinitions.FishCooked.index, SpriteGroup.Inventory) })
  elseif rawMaterialType == ItemDefinitions.Meat.index then
    foodsListDataSource.addItem({ key = "food_dried_meat", iValue1 = Foods.DriedMeat, icon = gSpriteManager.getSprite(ItemDefinitions.DriedMeat.index, SpriteGroup.Inventory) })
    foodsListDataSource.addItem({ key = "food_cooked_meat", iValue1 = Foods.CookedMeat, icon = gSpriteManager.getSprite(ItemDefinitions.MeatCooked.index, SpriteGroup.Inventory) })
  end

  I.optionsList.setSelectedRow(0)
  I.selectFood(0)

end

function I.selectFood (index)
  local foodsListDataSource = LuaListDataSource(I.optionsList.getDataSource())
  local foodListItem = LuaListDataItem(foodsListDataSource.getItemAtIndex(index))
  local foodType = foodListItem.iValue1()
print("foodType = ", foodType)
  I.foodProductionLabel.setText(string.format(gUtils.translate("format_cook_amount"), I.foodProductionPerTurn[foodType]))
end

I.foodProductionPerTurn = {
  6.0,
  3.0,
  7.0,
  4.0
}

UI.Interfaces["cooking"] = I
