local I = {}

function I.create ()

	print("Load dialog options window")

	I.window = LuaWindow(gGUI.createWindow({
		width = 260,
		height = 120,
		verticalAlignment = VerticalAlignment.Bottom,
		id = "dialogOptionsWnd",
		flags = 3
	}))

	I.list = LuaList(gGUI.createList({
		parent = I.window.instance(),
		x = 14,
		y = 12,
		width = 230,
		visibleRows = 8,
		rowHeight = 11,
		showSeparator = false,
		showSelection = false,
		textIndent = -4,
		selectionColor = 3,
		debugData = 6
	}))

end

function I.fillList (options)

	local dialogObject = DialogManager.currentDialog()
	local dataSource = LuaListDataSource(I.list.getDataSource())

	dataSource.removeAllItems()

	local unopenedTopicIcon = gSpriteManager.getSprite(3, SpriteGroup.DialogScreen)
	local openedTopicIcon = gSpriteManager.getSprite(4, SpriteGroup.DialogScreen)

	-- Dialog topics
	if options == nil then

		options = dialogObject.getTopics()

		for i = 1, #options do

			local topicTitle = DialogManager.currentDialog().getTopicTitle(options[i])

			dataSource.addItem({
				text 	= __ternary(topicTitle ~= nil, topicTitle, DialogManager.translate(options[i])),
				icon 	= __ternary(DialogManager.isDialogTreeOpened(options[i]), openedTopicIcon, unopenedTopicIcon),
				str1	= options[i],
				iValue1 = __ternary(options[i].id ~= nil, options[i].id, 0)
			})
		end

		dataSource.addItem({ str1 = "empty" })

		print("converse_dialog_screen = ", gVarStore.getBool("converse_dialog_screen"))

		if gVarStore.getBool("converse_dialog_screen") == true then
			dataSource.addItem({
				key = "dialog_option_switch",
				str1 = "otherdialogs"
			})
		end

		if gVarStore.getBool("journal_shortcut_dialog_screen") == true then
			dataSource.addItem({
				key = "dialog_option_journal",
				str1 = "journal"
			})
		end

		dataSource.addItem({
			key = "dialog_option_leave",
			str1 = "leave"
		})


	-- Provided replies
	else

		for i = 1, #options do
			dataSource.addItem({
				text 	= DialogManager.translate(options[i].key),
				icon 	= unopenedTopicIcon,
				iValue1 = options[i].id
			})
		end

	end

end

function I.onEventGUI (args)

	if args.type == EventGUI.ListItemClicked and I.list.instance() == args.source then

		local dialogObject = DialogManager.currentDialog()

		if DialogManager.CurrentDialogTreeKey == nil then

			local listWidget = LuaList(args.source)
			local listDataSource = LuaListDataSource(listWidget.getDataSource())
			local listItem = LuaListDataItem(listDataSource.getItemAtIndex(listWidget.getSelectedRow()))

			print(listItem, listItem.str1())

			if listItem.str1() == "leave" then
				DialogManager.close()

			elseif listItem.str1() == "journal" then
				Journal.toggle()

			elseif listItem.str1() == "otherdialogs" then
				DialogManager.showChangeDialogWindow()

			elseif listItem.str1() ~= "empty" then
				print("KEY = ", DialogManager.CurrentDialogKey)
				DialogManager.startDialogTree(listItem.str1())
			end

		else
			local listWidget = LuaList(args.source)
			local listDataSource = LuaListDataSource(listWidget.getDataSource())
			local listItem = LuaListDataItem(listDataSource.getItemAtIndex(args.param1))

			DialogManager.dismissDialog(args.param1 + 1, listItem.iValue1())
		end

	end

end


UI.Interfaces["dialog_options"] = I
