local I = {}

function I.close ()
	gGUI.scheduleForDeletion(I.window.instance())
	UI.Interfaces["sailout"] = nil
	I = nil

	if UI.Interfaces["sailout_towns"] ~= nil then
		UI.Interfaces["sailout_towns"].close()
	end
end

function I.create ()

	I.window = LuaWindow(gGUI.createWindow({
		width = 180,
		height = 195,
		verticalAlignment = VerticalAlignment.Middle,
		id = "sailWnd",
		title = "%title_sail_out"
	}))

  gGUI.createImage({
    parent = I.window.instance(),
    image = gSpriteManager.getSprite(7, SpriteGroup.Gfx),
    x = 90,
    y = 60
  })

	local closeButton = LuaButton(gGUI.createButton({
		parent = I.window.instance(),
		x = (I.window.getWidth() / 2) - 77,
		y = I.window.getHeight() - 13,
		width = 65,
		height = 18,
		title = "%close_button"
	}))

	closeButton:onClick(I.close)


  I.continueButton = LuaButton(gGUI.createButton({
		parent = I.window.instance(),
		x = (I.window.getWidth() / 2) - 8,
		y = I.window.getHeight() - 13,
		width = 85,
		height = 18,
		title = "%continue_button"
	}))

  I.continueButton:onClick(I.continue)

  gGUI.createTitleBar({
    parent = I.window.instance(),
    text = "%title_sail_out_where_to",
    y = 105
  })

  I.list = LuaList(gGUI.createList({
    parent = I.window.instance(),
    x = 7,
    y = 118,
    width = 166,
    id = "dests",
    selectionColor = 1,
    rowHeight = 14
  }))

  I.populate()

end

function I.populate ()

  local listDataSource = LuaListDataSource(I.list.getDataSource())

  listDataSource.removeAllItems()

  if gGame.getState() == GameState.Town then
  	listDataSource.addItem({ key = "travel_option_hios", 	str1 = "hios", accessoryType = ListRowAccessory.DisclosureDark })
  	listDataSource.addItem({ key = "travel_option_town", 	str1 = "town", accessoryType = ListRowAccessory.DisclosureDark })
	  listDataSource.addItem({ key = "navigate_seas", 			str1 = "roam", accessoryType = ListRowAccessory.DisclosureDark })
	else
  	listDataSource.addItem({ key = "sail_back_to_town", 	str1 = "town", accessoryType = ListRowAccessory.DisclosureDark })
	  listDataSource.addItem({ key = "navigate_seas", 			str1 = "roam", accessoryType = ListRowAccessory.DisclosureDark })
	end

	I.list.setSelectedRow(0)

end

function I.continue ()
  print("Do something")

	local listDataSource = LuaListDataSource(I.list.getDataSource())
	local listItem = LuaListDataItem(listDataSource.getItemAtIndex(I.list.getSelectedRow()))

	if listItem.str1() == "hios" then
		gTravelScreen.setDestinationId(gUtils.hash(listItem.str1()))
		gTravelScreen.setDestinationName(gUtils.translate("hios_island"))
		gTravelScreen.onComplete(function(destinationId)
			print("Reached destination ", destinationId)
			gGUI.setIsCursorVisible(true)
      gGame.goIntoExplorationMode({x = 474, y = 3930, direction = 4})
		end)
		gGUI.doScreenTransition({id = ConstBeginTravelFromTownTransition, delay = 0.1})
		I.close()

	elseif listItem.str1() == "town" then
		if UI.Interfaces["sailout_towns"] == nil then
			gGUI.loadScriptedInterface("sailout_towns", true)
		end

	elseif listItem.str1() == "roam" then
		if gGame.getState() == GameState.Town then

			if QuestManager.questCompleted({id = "spicerun"}) == false then
				gGUI.showInfoMessage({ key = "complete_quest_in_hand" })
				return
			end

			gGUI.doScreenTransition({id = ConstSailOutOfTownTransition, delay = 0.1})
			I.close()

		else
			if QuestManager.questCompleted({id = "spicerun"}) == false then
				gGUI.showInfoMessage({ key = "complete_quest_in_hand" })
				return
			end

			gGUI.doScreenTransition({id = ConstExitExplorationModeTransition, delay = 0.1})
			I.close()

		end
	end

end

UI.Interfaces["sailout"] = I
