local I = {}

function I.create (symbol)

	I.symbol = symbol

	I.window = LuaWindow(gGUI.createWindow({
		width = 140,
		height = 140,
		verticalAlignment = VerticalAlignment.Middle,
		id = "symDefWnd",
		title = "%define_symbol_wnd_title"
	}))

	local closeButton = LuaButton(gGUI.createButton({
		parent = I.window.instance(),
		x = (I.window.getWidth() / 2) - 40,
		y = I.window.getHeight() - 13,
		width = 80,
		height = 18,
		title = "%done_button"
	}))

	local descText = LuaText(gGUI.createText({
		parent = I.window.instance(),
		x = 10,
		y = 80,
		width = 120,
		text = "%define_symbol_text"
	}))

	local definition = gSymbols.definitionForSymbol(symbol)

	I.definitionTextField = LuaTextField(gGUI.createTextField({
		parent = I.window.instance(),
		x = 10,
		y = 100,
		height = 15,
		width = 120,
		maxLength = 25,
		text = definition
	}))

	I.definitionTextField.setHasFocus(true)

	local spriteIndex = gSymbols.spriteIndexForSymbol(symbol).spriteIndex

	I.symbolImage = LuaImage(gGUI.createImage({
		parent = I.window.instance(),
		x = (I.window.getWidth() / 2) - 16,
		y = 28,
		width = 32,
		height = 32,
		image = gSpriteManager.getSprite(spriteIndex, SpriteGroup.Symbol)
	}))

	closeButton.onClick(function()
		print("Define symbol "..I.symbol.." as "..I.definitionTextField.getText())
		gSymbols.defineSymbol(I.symbol, I.definitionTextField.getText())
		Journal.populateSymbols()
		gGUI.scheduleForDeletion(I.window.instance())
		UI.Interfaces["symbol_define"] = nil
		I = nil
	end)

end

UI.Interfaces["symbol_define"] = I
