local Q = {}

-- General

function Q.getId ()
	return "gettingstarted"
end

function Q.isAvailable ()
	return true
end

function Q.getName ()
	return gUtils.translate("quest_gettingstarted_title")
end

function Q.getDescription ()
	return gUtils.translate("quest_gettingstarted_description")
end


-- Functions related to objectives

local function numberOfExtraObjectives ()
	if gVarStore.getBool("gettingstarted_obj_added") == true then
		return 1
	end
	return 0
end

function Q.getNumberOfObjectives ()
	return (2 + numberOfExtraObjectives())
end

function Q.getObjectiveText (index)

	local extraObjectives = numberOfExtraObjectives()

	if extraObjectives == 1 then
		if index == 1 then
			return gUtils.translate("quest_gettingstarted_obj_extra")
		end
	end

	if index == (extraObjectives + 1) then
		return gUtils.translate("quest_gettingstarted_objective_1")
	elseif index == (extraObjectives + 2) then
		return gUtils.translate("quest_gettingstarted_objective_2")
	end

	return ""

end

function Q.getObjectiveHelpText (index)

	local extraObjectives = numberOfExtraObjectives()

	if extraObjectives == 1 then
		if index == 1 then
			return gUtils.translate("quest_gettingstarted_hint_extra")
		end
	end

	if index == (extraObjectives + 1) then
		return gUtils.translate("quest_gettingstarted_hint_1")
	elseif index == (extraObjectives + 2) then
		return gUtils.translate("quest_gettingstarted_hint_2")
	end

	return ""

end

function Q.isObjectiveCompleted(index)

	local extraObjectives = numberOfExtraObjectives()

	if extraObjectives == 1 then
		if index == 1 then
			if Town.getCurrentTownIndex() == 0 then
				return true
			end
		end
	end

	-- Get some basic equipment
	if index == (extraObjectives + 1) then
		local flaskCount = gTownState.countSupplyTypeTotal(ItemDefinitions.Flask.index)
		if (flaskCount >= gParty.getMemberCount() and flaskCount >= 1)
			-- At least one of each of the following items
			and gTownState.countSupplyTypeTotal(ItemDefinitions.Tent.index) > 0
			and gTownState.countSupplyTypeTotal(ItemDefinitions.Axe.index) > 0
			and gTownState.countSupplyTypeTotal(ItemDefinitions.Flint.index) > 0
			-- and (townState:countSupplyTypeTotal(Items.Bow) > 0 or townState:countSupplyTypeTotal(Items.Crossbow) > 0)
			-- and townState:countSupplyCategoryTotal(ItemCategory.MeleeWeapon) > 0
		then
			return true
		end

	-- Stock up on food and water
	elseif index == (extraObjectives + 2) then
		if gTownState.countSupplyCategoryTotal(ItemCategory.Food) >= 120 and gTownState.countSupplyTypeTotal(ItemDefinitions.FreshWater.index) >= 90 then
			return true
		end
	end

	return false

end


function Q.getNumberOfRewards ()
	return 0
end

function Q.shouldAutoCollectRewards ()
	return true
end

function Q.onComplete ()

end

function Q.onAccepted ()

end

-- Register quest
QuestManager.registerQuest("general", "gettingstarted", Q)
