local Q = {}

-- General

function Q.getId ()
	return "returnsafely"
end

function Q.isAvailable ()
	return gVarStore.getBool("learned_missing_provisioner")
end

function Q.getName ()
	return gUtils.translate("quest_returnsafely_title")
end

function Q.getDescription ()
	return gUtils.translate("quest_returnsafely_description")
end

function Q.getGfx ()
	return {sprite = gSpriteManager.getSprite(10, SpriteGroup.Gfx)}
end

-- Functions related to objectives

function Q.getNumberOfObjectives ()
	return 3
end

function Q.getObjectiveText(index)
	if index == 1 then
		return gUtils.translate("quest_returnsafely_objective_1")
	elseif index == 2 then
		return gUtils.translate("quest_returnsafely_objective_2")
	elseif index == 3 then
		return gUtils.translate("quest_returnsafely_objective_3")
	end

	return ""
end

function Q.getObjectiveHelpText(index)

	if index == 1 then
		return gUtils.translate("quest_returnsafely_hint_1")
	elseif index == 2 then
		return gUtils.translate("quest_returnsafely_hint_2")
	elseif index == 3 then
		return gUtils.translate("quest_returnsafely_hint_3")
	end

	return ""
end

function Q.isObjectiveCompleted(index)

	if index == 1 and gVarStore.getBool("rs_shipwreck") == true or gVarStore.getBool("rs_campsite") == true then
		return true
	elseif index == 2 and gVarStore.getBool("rs_campsite") == true then
		return true
	elseif 	index == 3 and
					gVarStore.getBool("rs_shipwreck") and
					gVarStore.getBool("rs_campsite") and
					gGame.getState() == GameState.Town and
					Town.getCurrentTownIndex() + 1 == Towns.Reval then
		return true
	end

	return false
end


-- Functions related to rewards

function Q.getNumberOfRewards ()
	return 1
end

function Q.getRewardText(index)
	if gGame:getDifficulty() == 0 then
		return gUtils.translate("quest_returnsafely_reward_1_e")

	elseif gGame:getDifficulty() == 1 then
		return gUtils.translate("quest_returnsafely_reward_1_m")

	elseif gGame:getDifficulty() == 2 then
		return gUtils.translate("quest_returnsafely_reward_1_h")
	end
end

function Q.shouldAutoCollectRewards ()
	return true
end

function Q.onComplete ()
	local reputationReward = {150, 100, 75}
	gParty.increaseReputation(reputationReward[gGame.getDifficulty()])
end

function Q.onAccepted ()

	gWorld.addPOI({id = "shipwreck", x = 387, y = 3442})

	local coords = Vector2:new(0, 3396)

	gWorld.beginEditing()

	gWorld.clearTile({x = coords.x + 386, y = coords.y + 45})
	gWorld.clearTile({x = coords.x + 386, y = coords.y + 44})
	gWorld.clearTile({x = coords.x + 386, y = coords.y + 43})
	gWorld.clearTile({x = coords.x + 387, y = coords.y + 42})
	gWorld.clearTile({x = coords.x + 387, y = coords.y + 41})
	gWorld.clearTile({x = coords.x + 386, y = coords.y + 40})
	gWorld.clearTile({x = coords.x + 385, y = coords.y + 39})
	gWorld.clearTile({x = coords.x + 386, y = coords.y + 39})
	gWorld.clearTile({x = coords.x + 385, y = coords.y + 38})
	gWorld.clearTile({x = coords.x + 384, y = coords.y + 37})
	gWorld.clearTile({x = coords.x + 384, y = coords.y + 36})
	gWorld.clearTile({x = coords.x + 385, y = coords.y + 35})
	gWorld.clearTile({x = coords.x + 386, y = coords.y + 35})
	gWorld.clearTile({x = coords.x + 387, y = coords.y + 35})
	gWorld.clearTile({x = coords.x + 388, y = coords.y + 34})
	gWorld.clearTile({x = coords.x + 387, y = coords.y + 33})
	gWorld.clearTile({x = coords.x + 387, y = coords.y + 32})
	gWorld.clearTile({x = coords.x + 386, y = coords.y + 31})
	gWorld.clearTile({x = coords.x + 386, y = coords.y + 30})
	gWorld.clearTile({x = coords.x + 386, y = coords.y + 29})
	gWorld.clearTile({x = coords.x + 387, y = coords.y + 28})
	gWorld.clearTile({x = coords.x + 388, y = coords.y + 27})
	gWorld.clearTile({x = coords.x + 389, y = coords.y + 26})

	gWorld.placeObject({x = coords.x + 386, y = coords.y + 45, type = ObjectCreation.Flag})
	gWorld.placeObject({x = coords.x + 386, y = coords.y + 39, type = ObjectCreation.Flag})
	gWorld.placeObject({x = coords.x + 386, y = coords.y + 29, type = ObjectCreation.Flag})

	if gGame.getDifficulty() == Difficulty.Easy then
		gWorld.placeObject({x = coords.x + 386, y = coords.y + 35, type = ObjectCreation.Flag})
	end

	gWorld.placeObject({x = coords.x + 389, y = coords.y + 26, type = ObjectCreation.Camp})

	gWorld.endEditing()

end

function Q.onReachedPOI (args)
	print("Reached POI", args.id, args.discovered)
	if args.discovered == false then
		gVarStore.setBool("rs_shipwreck", true)
		gGUI.showInfoMessage({ key = "quest_shipwreck_text", delay = 0.4 })
	end
end

function Q.onPartyMoved (args)

	-- print("New coords:", args.newX, args.newY)

	if gVarStore.getBool("rs_campsite") == false then
		local dx = math.abs(args.newX - 389)
		local dy = math.abs(args.newY - 3422)
		if dx <= 1 and dy <= 1 then
			gVarStore.setBool("rs_campsite", true)
			gGame.setViewportUserControllable(false)
			gGame.requestFullScreenUI()
			gGUI.showStoryText({ key = "quest_campsite_found_text", closeTime = 14.5 })
			gGUI.onStoryTextClose(function()
				gGUI.doScreenTransition({id = gUtils.hash("camp_found_1")})
			end)
		end
	end

end

function Q.onEventGUI (args)
	if args.type == EventGUI.TransitionInComplete then
		if args.param1 == gUtils.hash("camp_found_1") then
			local selectedPlayer = LuaPlayer(gParty.getSelectedPlayer())
			local ship = LuaShip(gParty.getVessel(0))
			ship.embark(selectedPlayer.instance())
			gGame.exitExplorationMode()
		end
	end
end

-- Register quest
QuestManager.registerQuest("general", "returnsafely", Q)

gLuaHandler.registerDelegateCallbacks(Q, Delegates.ReachedPOI, 0, Q.onReachedPOI)
gLuaHandler.registerDelegateCallbacks(Q, Delegates.PartyMoved, 0, Q.onPartyMoved)
gLuaHandler.registerDelegateCallbacks(Q, Delegates.EventsGUI, 0, Q.onEventGUI)
