local Q = {}

-- General

function Q.getId ()
	return "spicerun"
end

function Q.isAvailable ()
	if QuestManager.questCompleted({id = "gettingstarted"}) then
		return true
	else
		return false
	end
end

function Q.getName ()
	return gUtils.translate("quest_spicerun_title")
end

function Q.getDescription ()
	return gUtils.translate("quest_spicerun_description")
end


-- Functions related to objectives

function Q.getNumberOfObjectives ()
	return 2
end

function Q.getObjectiveText(index)
	if index == 2 then
		if gGame.getDifficulty() == Difficulty.Easy then
			return gUtils.translate("quest_spicerun_objective_2_e")
		elseif gGame.getDifficulty() == Difficulty.Medium then
			return gUtils.translate("quest_spicerun_objective_2_m")
		elseif gGame.getDifficulty() == Difficulty.Hard then
			return gUtils.translate("quest_spicerun_objective_2_h")
		end
	elseif index == 1 then
		return gUtils.translate("quest_spicerun_objective_1")
	end
	return ""
end

function Q.getObjectiveHelpText(index)
	if index == 2 then
		return gUtils.translate("quest_spicerun_hint_1")
	elseif index == 1 then
		return gUtils.translate("quest_spicerun_hint_2")
	end
	return ""
end

function Q.isObjectiveCompleted(index)

	if index == 2 then

		local spiceToCollect = 25;
		if gGame.getDifficulty() == 1 then
			spiceToCollect = 40
		elseif gGame.getDifficulty() == 2 then
			spiceToCollect = 60
		end

		-- Have we enough spices?
		if gParty.countResource(ItemDefinitions.Herbs.index, Herbs.Spice) >= spiceToCollect then
			return true
		end

	elseif index == 1 then
		return gVarStore.getBool("barlow_hired")
	end

	return false

end


-- Functions related to rewards

function Q.getNumberOfRewards ()
	return 2
end

function Q.getRewardText(index)

	if index == 1 then
		if gGame.getDifficulty() == 0 then
			return gUtils.translate("quest_spicerun_reward_1_e")
		elseif gGame.getDifficulty() == 1 then
			return gUtils.translate("quest_spicerun_reward_1_m")
		elseif gGame.getDifficulty() == 2 then
			return gUtils.translate("quest_spicerun_reward_1_h")
		end
	elseif index == 2 then
		if gGame.getDifficulty() == 0 then
			return gUtils.translate("quest_spicerun_reward_2_e")
		elseif gGame.getDifficulty() == 1 then
			return gUtils.translate("quest_spicerun_reward_2_m")
		elseif gGame.getDifficulty() == 2 then
			return gUtils.translate("quest_spicerun_reward_2_h")
		end
	end
end

function Q.shouldAutoCollectRewards ()
	return false
end

function Q.shouldShowRewardButton ()
	if Town.getCurrentTownIndex()+1 == Towns.Marciudad then
		return true
	end
	return false
end

function Q.onComplete ()

	-- Rewards on EASY
	local spiceToCollect = 25;
	local goldReward = 1500;
	local reputationReward = 100;

	-- Rewards on MEDIUM
	if gGame.getDifficulty() == 1 then
		spiceToCollect = 40
		goldReward = 1000
		reputationReward = 50

	-- Rewards on HARD
	elseif gGame.getDifficulty() == 2 then
		spiceToCollect = 60
		goldReward = 500
		reputationReward = 25
	end

	gParty.removeResource({primary = ItemDefinitions.Herbs.index, secondary = Herbs.Spice, amount = spiceToCollect});
	gParty.increaseTreasure(goldReward)
	gParty.increaseReputation(reputationReward)

	Journal.close()
	gGUI.showStoryText({ key = "spice_quest_completed_text", closeTime = 12.0 })

end

function Q.onAccepted ()

end


-- Register quest
QuestManager.registerQuest("merchant", "spicerun", Q)
