SpriteGroup = {
  Town = 6,
  GUI = 1,
  Object = 2,
  Misc = 3,
  Inventory = 4,
  Map = 0,
  Overworld = 7,
  WorldMap = 8,
  WorldMapTiles = 9,
  Intro = 10,
  Screens = 11,
  BattleScreen = 12,
  Gfx = 13,
  DialogScreen = 14,
  Symbol = 16
}

SoundGroup = {
  UI = 0,
  Environment = 1,
  Object = 2,
  SFX = 3
}

Professions = {
  Soldier = 0,
  Scout = 1,
  Hunter = 2,
  Scholar = 3,
  Craftsman = 4
}

Difficulty = {
  Easy = 0,
  Medium = 1,
  Hard = 2
}

Ship = {
  Built = 1,
  Repaired = 2
}

Herbs = {
  Spice = 1,
  Heal = 2
}

ItemCategory = {
  Tool = 1,
  Weapon = 62,
  Resource = 1024,
  Consumable = 192,
  Combat = 2048,
  BallisticArms = 32,
  MartialArms = 2,
  PoleArms = 4,
  LightArms = 16,
  HeavyArms = 8,
  Food = 64,
  Drink = 128,
  Other = 256,
  Armor = 512,
  Raw = 4096,
  TwoHandedWeapon = 8192,
  MeleeWeapon = 16384
}

Foods = {
  CookedMeat = 1,
  DriedMeat = 2,
  CookedFish = 3,
  DriedFish = 4
}

Delegates = {
  MessageBox = 0,
  PassSeason = 1,
  EndTurn = 2,
  EventsGUI = 3,
  EventsSystem = 4,
  ViewportAnimation = 5,
  ReachedPOI = 6,
  PartyMoved = 7,
  PartyChanged = 8
}

MessageBoxType = {
  Default = 0,
  Confirmation = 1
}

HorizontalAlignment = {
  Left = 0,
  Center = 1,
  Right = 2
}

VerticalAlignment = {
  Top = 10,
  Middle = 11,
  Bottom = 12
}

TownLocation = {
  Harbour = 1,
  Tavern = 2,
  Store = 4,
  Church = 8,
  Blacksmith = 16
}

Season = {
  Spring = 0,
  Summer = 1,
  Fall = 2,
  Winter = 3
}

ShipType = {
  Chatellin = 0
}

GameState = {
  MainMenu = 0,
  Game = 1,
  Town = 2,
  Overworld = 3,
  WorldMap = 4,
  Tutorial = 5,
  WorldGeneration = 6,
  Storybit = 7,
  Journal = 14,
  Combat = 8,
  Travel = 9,
  Dialog = 10,
  Minigame = 15,
  Debug = 16
}

WidgetType = {
  Empty = 10,
  Panel = 11,
  Image = 12,
  Button = 13,
  Text = 14,
  Window = 15,
  Separator = 16,
  ValueBar = 17,
  List = 18,
  MenuBar = 19,
  Menu = 20,
  Table = 21,
  TextField = 22,
  TitleBar = 23,
  CheckBox = 24,
  DropReceiver = 25
}

EventGUI = {
  None = 0,
  ButtonClicked = 1,
  ButtonClickedRight = 2,
  ListItemSelected = 3,
  ListItemClicked = 4,
  ListItemDoubleClicked = 5,
  MenuItemSelected = 6,
  TextClicked = 7,
  CheckBoxToggled = 8,
  MenuDismissed = 9,
  NarrativeClosed = 10,
  ItemDropCompleted = 11,
  ItemDropCancelled = 12,
  TransitionInComplete = 14,
  TransitionOutComplete = 15,
  TimerTrigger = 16,
  TableRowSelected = 17,
  ListScrolled = 18
}

EventSystem = {
  Close = 0,
  Resized = 1,
  LostFocus = 2,
  GainedFocus = 3,
  TextEntered = 4,
  KeyPressed = 5,
  KeyReleased = 6,
  MouseWheelMoved = 7,
  MouseButtonPressed = 8,
  MouseButtonReleased = 9,
  MouseMoved = 10,
  MouseEntered = 11,
  MouseLeft = 12
}

MouseButton = {
  Left = 0,
  Right = 1,
  Middle = 2
}

Origin = {
  TopLet = 0,
  TopCenter = 1,
  TopRight = 2,
  MiddleLeft = 3,
  MiddleCenter = 4,
  MiddleRight = 5,
  BottomLeft = 6,
  BottomCenter = 7,
  BottomRight = 8
}

TextShadow = {
  Border = 3,
  Down = 0,
  DownLeft = 1,
  DownRight = 2
}

ListRowAccessory = {
  None = 0,
  Disclosure = 2,
  DisclosureDark = 3,
  Checkmark = 1,
  CheckmarkDark = 4,
  Cross = 5
}

Transition = {
  DitherIn = 0,
  DitherOut = 1,
  BoxIn = 3,
  BoxOut = 4
}

Attribute = {
  Strength = 0,
  Stamina = 1,
  Agility = 2,
  Intellect = 3,
  Perception = 4
}

Skill = {
  Hunting = 1,
  Fishing = 2,
  Construction = 3,
  Ironworks = 4,
  Carpentry = 25,

  -- Might skills
  MartialArms = 5,
  PoleArms = 6,
  HeavyArms = 7,
  UnarmedCombat = 8,

  -- Agility skills
  LightArms = 9,
  BallisticArms = 10,
  Stealth = 11,
  Acrobatics = 12,
  Swimming = 13,

  -- Intellectual skills
  Cartography = 14,
  Cooking = 15,
  Botany = 16,
  Medical = 17,
  Polyglotism = 18,

  Sailing = 19,
  Hiking = 20,
  Climbing = 21,

  Diplomacy = 22,
  Mercantile = 23,

  Firemaking = 24
}

ObjectCreation = {
  Flag = 1,
  Camp = 2
}

WindowClose = {
  DefaultButton = 0,
  NoButton = 1,
  YesButton = 2
}

GameMode = {
  Story = 0,
  QuickAdventure = 1
}

MouseButton = {
  Left = 0,
  Right = 1,
  Middle = 2
}
