ItemDefinition = { }

local _indexCounter = 0

setmetatable(ItemDefinition, {
    __index = ItemDefinition;
    __tostring = function(a)
		return "ItemDefinition: {"..a.name.."}"
	end;
})

function ItemDefinition:new(_name, _weight, _categories, _param1)
  _indexCounter = _indexCounter + 1
	return setmetatable(
	{
		name 		= _name,
		weight 		= _weight or 0,
		categories 	= _categories or {},
		param1 		= _param1 or 0,
		index 		= _indexCounter
	},
	getmetatable(self))
end

-- Is given category set for this item def.
function ItemDefinition:category (category)
	for k, v in pairs(self.categories) do
		if v == category then return true end
	end
	return false
end

ItemDefinitionIndexes = {}
ItemDefinitions =
{
	Axe = ItemDefinition:new( "item_axe", 4.0, { ItemCategory.Tool, ItemCategory.MartialArms }, 4 ),
	Machete = ItemDefinition:new( "item_machete", 3.0, { ItemCategory.Tool, ItemCategory.MartialArms }, 4 ),
	Flint = ItemDefinition:new( "item_flint", 0.5, { ItemCategory.Other } ),
	FishingRod = ItemDefinition:new( "item_fishing_rod", 1.5, { ItemCategory.Tool } ),
	Saw = ItemDefinition:new( "item_saw", 2.0, { ItemCategory.Tool } ),
	Shovel = ItemDefinition:new( "item_shovel", 4.0, { ItemCategory.Tool } ),
	Pickaxe = ItemDefinition:new( "item_pickaxe", 4.0, { ItemCategory.Tool } ),
	Rope = ItemDefinition:new( "item_rope", 1.0, { ItemCategory.Tool } ),
	Binoculars = ItemDefinition:new( "item_binoculars", 4.0, { ItemCategory.Other } ),

	Knife = ItemDefinition:new( "item_knife", 0.5, { ItemCategory.LightArms, ItemCategory.Tool, ItemCategory.Combat, ItemCategory.Weapon, ItemCategory.MeleeWeapon }, 2 ),
	Sword = ItemDefinition:new( "item_sword", 3.5, { ItemCategory.MartialArms, ItemCategory.Combat, ItemCategory.Weapon, ItemCategory.MeleeWeapon }, 7 ),
	Bow = ItemDefinition:new( "item_bow", 2.0, { ItemCategory.BallisticArms, ItemCategory.Combat, ItemCategory.Weapon, ItemCategory.TwoHandedWeapon }, 4 ),
	Crossbow = ItemDefinition:new( "item_crossbow", 3.0, { ItemCategory.BallisticArms, ItemCategory.Combat, ItemCategory.Weapo, ItemCategory.TwoHandedWeaponn }, 7 ),
	Musket = ItemDefinition:new( "item_musket", 5.0, { ItemCategory.BallisticArms, ItemCategory.Combat, ItemCategory.Weapon, ItemCategory.TwoHandedWeapon }, 13 ),
	GreatSword = ItemDefinition:new( "item_great_sword", 5.0, { ItemCategory.HeavyArms, ItemCategory.Combat, ItemCategory.Weapon, ItemCategory.TwoHandedWeapon  }, 10 ),
	Mace = ItemDefinition:new( "item_mace", 3.0, { ItemCategory.MartialArms, ItemCategory.Combat, ItemCategory.Weapon, ItemCategory.MeleeWeapon }, 9 ),
	Spear = ItemDefinition:new( "item_spear", 3.0, { ItemCategory.PoleArms, ItemCategory.Combat, ItemCategory.Weapon, ItemCategory.MeleeWeapon }, 8 ),
	Halberd = ItemDefinition:new( "item_halberd", 3.5, { ItemCategory.PoleArms, ItemCategory.Combat, ItemCategory.Weapon, ItemCategory.MeleeWeapon }, 8 ),
	Dagger = ItemDefinition:new( "item_dagger", 0.5, { ItemCategory.LightArms, ItemCategory.Combat, ItemCategory.Weapon, ItemCategory.MeleeWeapon }, 3 ),
	BattleAxe = ItemDefinition:new( "item_battle_axe", 4.5, { ItemCategory.HeavyArms, ItemCategory.Combat, ItemCategory.Weapon, ItemCategory.TwoHandedWeapon }, 3 ),

	Tobacco = ItemDefinition:new( "item_tobacco", 0.2, { ItemCategory.Other } ),
	Flask = ItemDefinition:new( "item_flask", 0.1, { ItemCategory.Other } ),
	Tent = ItemDefinition:new( "item_tent", 6.0, { ItemCategory.Other } ),

	FreshWater = ItemDefinition:new( "item_fresh_water", 0.115, { ItemCategory.Drink, ItemCategory.Consumable } ),
	DriedMeat = ItemDefinition:new( "item_dried_meat", 0.1, { ItemCategory.Food, ItemCategory.Consumable } ),
	Bread = ItemDefinition:new( "item_bread", 0.2, { ItemCategory.Food, ItemCategory.Consumable } ),
	Biscuits = ItemDefinition:new( "item_biscuits", 0.28, { ItemCategory.Food, ItemCategory.Consumable } ),

	ArmorLeather = ItemDefinition:new( "item_leather_armor", 1.5, { ItemCategory.Armor, ItemCategory.Combat }, 1 ),
	ArmorScale = ItemDefinition:new( "item_scale_armor", 2.5, { ItemCategory.Armor, ItemCategory.Combat }, 2 ),
	ArmorBrigandine = ItemDefinition:new( "item_brigandine_armor", 3.0, { ItemCategory.Armor, ItemCategory.Combat }, 3 ),
	ArmorCoatOfPlates = ItemDefinition:new( "item_coat_of_plates_armor", 4.0, { ItemCategory.Armor, ItemCategory.Combat }, 5 ),
	ArmorSplinted = ItemDefinition:new( "item_splinted_armor", 3.0, { ItemCategory.Armor, ItemCategory.Combat }, 5 ),
	ArmorMail = ItemDefinition:new( "item_mail_armor", 2.0, { ItemCategory.Armor, ItemCategory.Combat }, 4 ),
	ArmorPlate = ItemDefinition:new( "item_plate_armor", 5.0, { ItemCategory.Armor, ItemCategory.Combat }, 6 ),

	Wood = ItemDefinition:new( "item_wood", 0.2, { ItemCategory.Resource } ),
	Stone = ItemDefinition:new( "item_stone", 0.35, { ItemCategory.Resource } ),
	Meat = ItemDefinition:new( "item_meat", 0.12, { ItemCategory.Resource, ItemCategory.Food, ItemCategory.Raw, ItemCategory.Consumable } ),
	Fur = ItemDefinition:new( "item_fur", 0.05, { ItemCategory.Resource } ),
	Bark = ItemDefinition:new( "item_bark", 0.09, { ItemCategory.Resource } ),
	Berries = ItemDefinition:new( "item_berries", 0.06, { ItemCategory.Resource, ItemCategory.Food, ItemCategory.Consumable } ),
	Herbs = ItemDefinition:new( "item_herbs", 0.03, { ItemCategory.Resource, ItemCategory.Food, ItemCategory.Consumable } ),
  CaveGlowMushroom = ItemDefinition:new( "item_caveglowmushroom", 0.02, { ItemCategory.Resource, ItemCategory.Food, ItemCategory.Raw, ItemCategory.Consumable } ),
  CaveFlowers = ItemDefinition:new( "item_caveflowers", 0.03, { ItemCategory.Resource, ItemCategory.Food, ItemCategory.Consumable } ),
  CaveMoss = ItemDefinition:new( "item_cavemoss", 0.04, { ItemCategory.Resource, ItemCategory.Food, ItemCategory.Consumable } ),

  FishRaw = ItemDefinition:new( "item_raw_fish", 0.09, { ItemCategory.Food, ItemCategory.Raw, ItemCategory.Consumable } ),
  FishCooked = ItemDefinition:new( "item_cooked_fish", 0.12, { ItemCategory.Food, ItemCategory.Consumable } ),
	FishDried = ItemDefinition:new( "item_dried_fish", 0.1, { ItemCategory.Food, ItemCategory.Consumable } ),
  MeatCooked = ItemDefinition:new( "item_cooked_meat", 0.16, { ItemCategory.Food, ItemCategory.Consumable } )
}

-- Add numeric indexes as well
for k,v in pairs(ItemDefinitions) do
	ItemDefinitionIndexes[v.index] = v
end
