Journal = {}

local mainWindow, questsPageButton, statisticsPageButton, symbolsPageButton, descriptionPageButton, objectivesPageButton, rewardsPageButton, symbolsEmptyParent
local questsList, objectivesList, rewardsList, questDescriptionText, noRewardsText, questGraphics, noSymbolsLabel, acceptQuestButton, collectRewardsButton
local leftPageIndex, rightPageIndex = 1, 1
local active, needsClose = false, false
local leftPages, rightPages
local windowTargetY, windowCurrentY

function Journal.toggle ()
	if active == false then
		active = true
		Journal.onInit(0)
	else
		active = false
		Journal.onClear()
	end
end

function Journal.close ()
	if active == true then
		needsClose = true
	end
end

function Journal.isActive ()
	return active
end

function Journal.getSelectedQuest ()
	local questListDataSource = LuaListDataSource(questsList.getDataSource())
	local questKey = LuaListDataItem(questListDataSource.getItemAtIndex(questsList.getSelectedRow())).str1()
	return QuestManager.Quests[questKey]
end

function Journal.onInit (param)

	needsClose = false

	local journalWindowRect = gGUI.getWindowRect({
		height = 287,
		width = 386,
		verticalAlign = VerticalAlignment.Middle,
		fullScreen = true})

	local rootWidget = LuaWidget(gGUI.getRootWidget(GameState.Journal))

	windowTargetY = journalWindowRect.top
	windowCurrentY = windowTargetY + 70

	mainWindow = LuaWindow(gGUI.createWindow({
		parent = rootWidget.instance(),
		x = journalWindowRect.left,
		y = windowCurrentY,
		width = journalWindowRect.width,
		height = journalWindowRect.height,
		noStyle = true
	}))


	-- Book image
	gGUI.createImage({
		parent = mainWindow.instance(),
		image = gSpriteManager.getSprite(111, SpriteGroup.GUI)
	})


	-- Close button
	local closeButton = LuaButton(gGUI.createButton({
		parent = mainWindow.instance(),
		image = gSpriteManager.getSprite(112, SpriteGroup.GUI),
		x = 366,
		y = 250,
		width = 30,
		height = 40
	}))


	-- Page buttons

	questsPageButton = LuaButton(gGUI.createButton({
		parent = mainWindow.instance(),
		image = gSpriteManager.getSprite(113, SpriteGroup.GUI),
		width = 15,
		height = 71
	}))

	if gGame.getMode() == GameMode.QuickAdventure then
		questsPageButton.setIsVisible(false)
	end

	statisticsPageButton = LuaButton(gGUI.createButton({
		parent = mainWindow.instance(),
		image = gSpriteManager.getSprite(179, SpriteGroup.GUI),
		width = 15,
		height = 71
	}))

	symbolsPageButton = LuaButton(gGUI.createButton({
		parent = mainWindow.instance(),
		image = gSpriteManager.getSprite(189, SpriteGroup.GUI),
		width = 15,
		height = 71
	}))



	descriptionPageButton = LuaButton(gGUI.createButton({
		parent = mainWindow.instance(),
		image = gSpriteManager.getSprite(114, SpriteGroup.GUI),
		width = 15,
		height = 71
	}))

	objectivesPageButton = LuaButton(gGUI.createButton({
		parent = mainWindow.instance(),
		image = gSpriteManager.getSprite(115, SpriteGroup.GUI),
		width = 15,
		height = 71
	}))

	rewardsPageButton = LuaButton(gGUI.createButton({
		parent = mainWindow.instance(),
		image = gSpriteManager.getSprite(116, SpriteGroup.GUI),
		width = 15,
		height = 71
	}))





	-- Create "page" container widgets

	leftPages = {}
	rightPages = {}

	local leftPage1 = LuaWidget(gGUI.createWidget({
		parent = mainWindow.instance(),
		x = 24,
		width = 161
	}))

	local leftPage2 = LuaWidget(gGUI.createWidget({
		parent = mainWindow.instance(),
		x = 24,
		width = 161
	}))

	local leftPage3 = LuaWidget(gGUI.createWidget({
		parent = mainWindow.instance(),
		x = 24,
		width = 160
	}))

	symbolsEmptyParent = LuaWidget(gGUI.createWidget({
		parent = leftPage3.instance()
	}))

	local rightPage1 = LuaWidget(gGUI.createWidget({
		parent = mainWindow.instance(),
		x = 201,
		width = 160
	}))

	local rightPage2 = LuaWidget(gGUI.createWidget({
		parent = mainWindow.instance(),
		x = 201,
		width = 160
	}))

	local rightPage3 = LuaWidget(gGUI.createWidget({
		parent = mainWindow.instance(),
		x = 201,
		width = 160
	}))

	table.insert(leftPages, leftPage1)
	table.insert(leftPages, leftPage2)
	table.insert(leftPages, leftPage3)

	table.insert(rightPages, rightPage1)
	table.insert(rightPages, rightPage2)
	table.insert(rightPages, rightPage3)


	acceptQuestButton = LuaButton(gGUI.createButton({
		parent = mainWindow.instance(),
		x = 224,
		y = 253,
		width = 113,
		height = 17,
 		text = "%accept_quest_button",
		backgroundImage = gSpriteManager.getSprite(170, SpriteGroup.GUI)
	}))

	collectRewardsButton = LuaButton(gGUI.createButton({
		parent = mainWindow.instance(),
		x = 224,
		y = 253,
		width = 113,
		height = 17,
 		text = "%collect_reward_button",
		backgroundImage = gSpriteManager.getSprite(170, SpriteGroup.GUI)
	}))

	acceptQuestButton:onClick(function()
		local quest = Journal.getSelectedQuest()
		gSoundManager.playSound(16, SoundGroup.SFX)
		QuestManager.questAccepted({ id = quest.getId(), value = true })
		quest.onAccepted()
		acceptQuestButton.setIsVisible(false)
	end)

	collectRewardsButton:onClick(function()
		local quest = Journal.getSelectedQuest()
		gSoundManager.playSound(14, SoundGroup.SFX)
		quest.onComplete()
		QuestManager.questCompleted({ id = quest.getId(), value = true })
		collectRewardsButton.setIsVisible(false)
	end)



	--[[
		Setup page contents
	]]--

	-- Quests page

	gGUI.createText({
		parent = leftPage1.instance(),
		text = "%journal_title_quests",
		font = 4,
		color = 1,
		y = 20,
		width = 161,
		horizontalAlign = HorizontalAlignment.Center,
		shadow = {color = 3, direction = TextShadow.Down}
	})

	questsList = LuaList(gGUI.createList({
		parent = leftPage1.instance(),
		width = 142,
		x = 9,
		y = 35,
		visibleRows = 20,
		debugData = 3,
		colorIndex = 3,
		selectionColor = 1,
		rowHeight = 13
	}))


	-- Statistics page

	gGUI.createText({
		parent = leftPage2.instance(),
		text = "%journal_title_statistics",
		font = 4,
		color = 1,
		y = 20,
		width = 161,
		horizontalAlign = HorizontalAlignment.Center,
		shadow = {color = 3, direction = TextShadow.Down}
	})

	gGUI.createText({
		parent = leftPage3.instance(),
		text = "%journal_title_symbols",
		font = 4,
		color = 1,
		y = 20,
		width = 161,
		horizontalAlign = HorizontalAlignment.Center,
		shadow = {color = 3, direction = TextShadow.Down}
	})

	gGUI.createText({
		parent = leftPage2.instance(),
		text = "%journal_stat_villages",
		color = 3,
		x = 8,
		y = 30,
		width = 300,
		height = 21,
		horizontalAlign = HorizontalAlignment.Left
	})

	gGUI.createText({
		parent = leftPage2.instance(),
		text = "%journal_stat_temples",
		color = 3,
		x = 8,
		y = 43,
		width = 300,
		height = 21,
		horizontalAlign = HorizontalAlignment.Left
	})

	gGUI.createText({
		parent = leftPage2.instance(),
		text = "%journal_stat_temples_looted",
		color = 3,
		x = 8,
		y = 56,
		width = 300,
		height = 21,
		horizontalAlign = HorizontalAlignment.Left
	})

	gGUI.createText({
		parent = leftPage2.instance(),
		text = "%journal_stat_world",
		color = 3,
		x = 8,
		y = 69,
		width = 300,
		height = 21,
		horizontalAlign = HorizontalAlignment.Left
		})

	gGUI.createText({
		parent = leftPage2.instance(),
		text = "%journal_stat_reputation",
		color = 3,
		x = 8,
		y = 90,
		width = 300,
		height = 21,
		horizontalAlign = HorizontalAlignment.Left
	})

	gGUI.createText({
		parent = leftPage2.instance(),
		text = "%journal_stat_treasure",
		color = 3,
		x = 8,
		y = 103,
		width = 300,
		height = 21,
		horizontalAlign = HorizontalAlignment.Left
	})


	local villageDiscoveredValue = LuaText(gGUI.createText({
		parent = leftPage2.instance(),
		text = "000",
		color = 2,
		x = 55,
		y = 30,
		font = 3,
		width = 100,
		height = 21,
		horizontalAlign = HorizontalAlignment.Right
	}))

	local templesDiscoveredValue = LuaText(gGUI.createText({
		parent = leftPage2.instance(),
		text = "000",
		color = 2,
		x = 55,
		y = 43,
		font = 3,
		width = 100,
		height = 21,
		horizontalAlign = HorizontalAlignment.Right
	}))

	local templesLootedValue = LuaText(gGUI.createText({
		parent = leftPage2.instance(),
		text = "000",
		color = 2,
		x = 55,
		y = 56,
		font = 3,
		width = 100,
		height = 21,
		horizontalAlign = HorizontalAlignment.Right
	}))

	local worldDiscoveredValue = LuaText(gGUI.createText({
		parent = leftPage2.instance(),
		text = "000",
		color = 2,
		x = 55,
		y = 69,
		font = 3,
		width = 100,
		height = 21,
		horizontalAlign = HorizontalAlignment.Right
	}))

	local reputationValue = LuaText(gGUI.createText({
		parent = leftPage2.instance(),
		text = "000",
		color = 1,
		x = 55,
		y = 90,
		font = 3,
		width = 100,
		height = 21,
		horizontalAlign = HorizontalAlignment.Right
	}))

	local treasureValue = LuaText(gGUI.createText({
		parent = leftPage2.instance(),
		text = "000",
		color = 2,
		x = 55,
		y = 103,
		font = 3,
		width = 100,
		height = 21,
		horizontalAlign = HorizontalAlignment.Right
	}))


	-- Symbols page

	noSymbolsLabel = LuaText(gGUI.createText({
		parent = leftPage3.instance(),
		text = "%no_symbols_discovered",
		font = 4,
		color = 3,
		y = 130,
		width = 160,
		horizontalAlign = HorizontalAlignment.Center
	}))



	villageDiscoveredValue:content(function()
		local stats = LuaStatistics(gGame.getStatistics())
		local args = gWorld.getGenerationArguments()
		return string.format(gUtils.translate("format_journal_stats_found"), stats.getVar1(0), args.villages)
		end)

	templesDiscoveredValue:content(function()
		local stats = LuaStatistics(gGame.getStatistics())
		local args = gWorld.getGenerationArguments()
		return string.format(gUtils.translate("format_journal_stats_found"), stats.getVar1(1), args.temples)
		end)

	templesLootedValue:content(function()
		local stats = LuaStatistics(gGame.getStatistics())
		local args = gWorld.getGenerationArguments()
		return string.format(gUtils.translate("format_journal_stats_found"), stats.getVar1(2), args.temples)
	end)

	worldDiscoveredValue:content(function()
		return gWorld.getDiscoveredPercentString()
	end)

	reputationValue:content(function()
		return string.format("%d", gParty.getReputation())
	end)

	treasureValue:content(function()
		return string.format("%d %s", gParty.getTreasure(), gUtils.translate("price_suffix_gold_lc"))
	end)


	-- Description page

	gGUI.createText({
		parent = rightPage1.instance(),
		text = "%journal_title_quest_description",
		font = 4,
		color = 1,
		y = 20,
		width = 158,
		horizontalAlign = HorizontalAlignment.Center,
		shadow = {color = 3, direction = TextShadow.Down}
	})

	questDescriptionText = LuaText(gGUI.createTextBlock({
		parent = rightPage1.instance(),
		text = "Lorem ipsum",
		color = 3,
		y = 35,
		x = 2,
		width = 148
	}))

	questGraphics = LuaImage(gGUI.createImage({
		parent = rightPage1.instance()
	}))


	-- Objectives page

	gGUI.createText({
		parent = rightPage2.instance(),
		text = "%journal_title_quest_objectives",
		font = 4,
		color = 1,
		y = 20,
		width = 158,
		horizontalAlign = HorizontalAlignment.Center,
		shadow = {color = 3, direction = TextShadow.Down}
	})

	objectivesList = LuaList(gGUI.createList({
		parent = rightPage2.instance(),
		width = 159,
		x = 0,
		y = 34,
		visibleRows = 10,
		debugData = 4,
		colorIndex = 3,
		showSelection = false,
		textIndent = -2,
		rowHeight = 12
	}))


	-- Rewards page

	gGUI.createText({
		parent = rightPage3.instance(),
		text = "%journal_title_quest_rewards",
		font = 4,
		color = 1,
		y = 20,
		width = 158,
		horizontalAlign = HorizontalAlignment.Center,
		shadow = {color = 3, direction = TextShadow.Down}
	})

	rewardsList = LuaList(gGUI.createList({
		parent = rightPage3.instance(),
		width = 160,
		x = 0,
		y = 34,
		visibleRows = 10,
		debugData = 4,
		colorIndex = 3,
		selectionColor = 0,
		textIndent = -2,
		rowHeight = 12
	}))

	noRewardsText = LuaText(gGUI.createText({
		parent = rightPage3.instance(),
		text = "%no_rewards",
		font = 4,
		color = 3,
		y = 130,
		width = 158,
		horizontalAlign = HorizontalAlignment.Center
	}))

	-- Callbacks

	objectivesList:onItemSelected(function(index, item)
		local quest = Journal.getSelectedQuest()
		gGUI.showMessageBox({
			text = quest.getObjectiveHelpText(index+1),
			title = quest.getObjectiveText(index+1),
			verticalAlign = VerticalAlignment.Middle
		})
	end)

	descriptionPageButton.onClick(function()
		Journal.showPages(1, 1)
	end)

	objectivesPageButton.onClick(function()
		Journal.showPages(1, 2)
	end)

	rewardsPageButton.onClick(function()
		Journal.showPages(1, 3)
	end)

	questsPageButton.onClick(function()
		Journal.showPages(1, rightPageIndex)
	end)

	statisticsPageButton.onClick(function()
		Journal.showPages(2, 0)
	end)

	symbolsPageButton.onClick(function()
		Journal.showPages(3, 0)
	end)

	closeButton.onClick(function()
		needsClose = true
	end)

	-- Show last selected pages
	Journal.showPages(leftPageIndex, rightPageIndex)

end

function Journal.onUpdate (frameTime)
	if needsClose == true then
		needsClose = false
		Journal.toggle()
	else
		if windowCurrentY > windowTargetY then
			windowCurrentY = windowCurrentY - 200 * frameTime
			if windowCurrentY < windowTargetY then
				windowCurrentY = windowTargetY
			end
			mainWindow.setY(windowCurrentY)
		end
	end
end

function Journal.onDraw ()

	local screenSize = gGUI.getScreenSize()

	-- Fill background
	gGame.fillRect({
		width = screenSize.x,
		height = screenSize.y,
		colorIndex = 3
	})

	-- Background gfx (repeat horizontally)

	local bgSprite = gSpriteManager.getSprite(183, SpriteGroup.GUI)

	gGame.drawSprite(bgSprite, {
		x = 0,
		y = (screenSize.y / 2) - 120
	})

end

function Journal.onClear ()
	local rootWidget = LuaWidget(gGUI.getRootWidget(GameState.Journal))
	rootWidget.removeChildren()
end

function Journal.showPages(_leftPageIndex, _rightPageIndex)

	if _leftPageIndex == 1 and gGame.getMode() == GameMode.QuickAdventure then
		_leftPageIndex = 2
	end

	leftPageIndex = _leftPageIndex
	rightPageIndex = _rightPageIndex

	if leftPageIndex == 1 and rightPageIndex == 0 then
		rightPageIndex = 1
	end

	acceptQuestButton.setIsVisible(false)
	collectRewardsButton.setIsVisible(false)

	rightPages[1].setIsVisible(false)
	rightPages[2].setIsVisible(false)
	rightPages[3].setIsVisible(false)

	-- Symbols page
	if leftPageIndex == 3 then

		questsPageButton.setX(4)
		questsPageButton.setY(22)
		statisticsPageButton.setX(4)
		statisticsPageButton.setY(100)
		symbolsPageButton.setX(6)
		symbolsPageButton.setY(180)

		leftPages[1].setIsVisible(false)
		leftPages[2].setIsVisible(false)
		leftPages[3].setIsVisible(true)

		objectivesPageButton.setIsVisible(false)
		rewardsPageButton.setIsVisible(false)
		descriptionPageButton.setIsVisible(false)

		Journal.populateSymbols()

	-- Statistics page
	elseif leftPageIndex == 2 then

		questsPageButton.setX(4)
		questsPageButton.setY(22)
		statisticsPageButton.setX(6)
		statisticsPageButton.setY(100)
		symbolsPageButton.setX(2)
		symbolsPageButton.setY(184)

		leftPages[1].setIsVisible(false)
		leftPages[2].setIsVisible(true)
		leftPages[3].setIsVisible(false)

		objectivesPageButton.setIsVisible(false)
		rewardsPageButton.setIsVisible(false)
		descriptionPageButton.setIsVisible(false)

	-- Quests page
	elseif leftPageIndex == 1 then

		questsPageButton.setX(6)
		questsPageButton.setY(20)
		statisticsPageButton.setX(2)
		statisticsPageButton.setY(102)
		symbolsPageButton.setX(2)
		symbolsPageButton.setY(184)

		leftPages[1].setIsVisible(true)
		leftPages[2].setIsVisible(false)
		leftPages[3].setIsVisible(false)

		objectivesPageButton.setIsVisible(true)
		rewardsPageButton.setIsVisible(true)
		descriptionPageButton.setIsVisible(true)

		local y1, y2, y3, x1, x2, x3 = 15, 94, 167, 364, 367, 370;
		local yOffset = 2;

		-- Description page
		if rightPageIndex == 0 or rightPageIndex == 1 then

			descriptionPageButton.setX(x1)
			descriptionPageButton.setY(y1)
			objectivesPageButton.setX(x2)
			objectivesPageButton.setY(y2 + yOffset)
			rewardsPageButton.setX(x3)
			rewardsPageButton.setY(y3 + yOffset)

			objectivesPageButton.bringToFront()
			rewardsPageButton.bringToFront()
			descriptionPageButton.bringToFront()

			if rightPageIndex == 1 then
				rightPages[1].setIsVisible(true)
			end

		-- Objectives page
		elseif rightPageIndex == 2 then

			descriptionPageButton.setX(x3)
			descriptionPageButton.setY(y1 + yOffset)
			objectivesPageButton.setX(x1)
			objectivesPageButton.setY(y2)
			rewardsPageButton.setX(x2)
			rewardsPageButton.setY(y3 + yOffset)

			descriptionPageButton.bringToFront()
			rewardsPageButton.bringToFront()
			objectivesPageButton.bringToFront()

			rightPages[2].setIsVisible(true)

		-- Rewards page
		elseif rightPageIndex == 3 then

			descriptionPageButton.setX(x2)
			descriptionPageButton.setY(y1 + yOffset)
			objectivesPageButton.setX(x3)
			objectivesPageButton.setY(y2 + yOffset)
			rewardsPageButton.setX(x1)
			rewardsPageButton.setY(y3)

			descriptionPageButton.bringToFront()
			objectivesPageButton.bringToFront()
			rewardsPageButton.bringToFront()

			rightPages[3].setIsVisible(true)

		end

		-- Journal.populateQuestSources()
		Journal.populateQuests()
		-- Journal.showQuestInfoForCurrentPage()

	end




end

function Journal.populateSymbols ()

	local row = 0
	local column = 0
	local cellWidth = leftPages[3].getWidth() / 2
	local cellHeight = 50

	print(cellWidth, cellHeight)

	local symCount = gSymbols.countDiscoveredSymbols()

	if symCount == 0 then
		noSymbolsLabel.setIsVisible(true)
	else
		noSymbolsLabel.setIsVisible(false)
	end

	symbolsEmptyParent.removeChildren()

	for i=0, symCount-1 do

		local symbol = gSymbols.getDiscoveredSymbol(i)
		local spriteIndex = gSymbols.spriteIndexForSymbol(symbol).spriteIndex
		local definition = gSymbols.definitionForSymbol(symbol)

		if string.len(definition) == 0 then
			definition = "?"
		end

		local symbolImageButton = LuaButton(gGUI.createButton({
			parent = symbolsEmptyParent.instance(),
			image = gSpriteManager.getSprite(spriteIndex, SpriteGroup.Symbol),
			x = ((cellWidth / 2) + (column * cellWidth)) - 16,
			y = 16 + ((cellHeight / 2) + (row * cellHeight)),
			width = 32,
			height = 32
		}))

		symbolImageButton.onClick(function()
			if UI.Interfaces['symbol_define'] == nil then
				gGUI.loadScriptedInterface("symbol_define")
				UI.Interfaces['symbol_define'].create(symbol)
			end
		end)

		local symbolMeaning = LuaText(gGUI.createText({
			parent = symbolsEmptyParent.instance(),
			x = column * cellWidth,
			y = symbolImageButton.getY() + 35,
			width = cellWidth,
			height = 10,
			horizontalAlign = HorizontalAlignment.Center,
			colorIndex = 2,
			text = definition
		}))

		column = column + 1

		if column == 2 then
			row = row + 1
			column = 0
		end

	end


end

function Journal.populateQuestSources ()


end

function Journal.populateQuests ()

	local questListDataSource = LuaListDataSource(questsList.getDataSource())
	questListDataSource.removeAllItems()

	for j=1, QuestManager.SourcesCount do
		local questSource = QuestManager.Sources[QuestManager.SourcesKeys[j]]
		for i=1, questSource.QuestsCount do
			local quest = questSource.Quests[i]
			if quest.isAvailable() then
				questListDataSource.addItem({text = quest.getName(), str1 = quest.getId()})
			end
		end
	end

	questsList.setSelectedRow(gVarStore.getInt("selectedQuestIndex"))

	if questsList.getSelectedRow() < 0 and questListDataSource.countItems() > 0 then
		questsList.setSelectedRow(0)
	elseif questsList.getSelectedRow() >= questListDataSource.countItems() then
		questsList.setSelectedRow(questListDataSource.countItems() - 1)
	end

	Journal.showQuestInfoForCurrentPage()
end

function Journal.showQuestInfoForCurrentPage ()

	local questListDataSource = LuaListDataSource(questsList.getDataSource())

	acceptQuestButton.setIsVisible(false)
	collectRewardsButton.setIsVisible(false)

	if questListDataSource.countItems() == 0 then
		return
	end

	gVarStore.setInt("selectedQuestIndex", questsList.getSelectedRow())

	local questKey = LuaListDataItem(questListDataSource.getItemAtIndex(questsList.getSelectedRow())).str1()
	local quest = QuestManager.Quests[questKey]

	if quest.isAvailable() then
		if QuestManager.questAccepted({id = questKey}) == false then
			acceptQuestButton.setIsVisible(true)
		elseif 	QuestManager.objectivesCompleted(quest) and
						QuestManager.questCompleted({id = questKey}) == false and
						quest.shouldAutoCollectRewards() == false and
 						quest.shouldShowRewardButton ~= nil and
						quest.shouldShowRewardButton() == true then
			collectRewardsButton.setIsVisible(true)
		end
	end

	-- Description
	if rightPageIndex == 1 then

		questDescriptionText.setText(quest.getDescription());
		if quest.getGfx ~= nil then
			local questGfx = quest.getGfx()
			local pos = Vector2:new(80, 240)

			if questGfx.x ~= nil then
				pos.x = pos.x + questGfx.x
			end

			if questGfx.y ~= nil then
				pos.y = pos.y + questGfx.y
			end

			questGraphics.setX(pos.x)
			questGraphics.setY(pos.y)
			questGraphics.setSprite(questGfx.sprite)
		else
			questGraphics.setSprite(nil)
		end

	-- Objectives
	elseif rightPageIndex == 2 then
		local listDataSource = LuaListDataSource(objectivesList:getDataSource())
		listDataSource:removeAllItems()
		for i=1, quest.getNumberOfObjectives() do
			local listItem = LuaListDataItem(listDataSource:addItem({text = quest.getObjectiveText(i)}))
			listItem:icon(gSpriteManager.getSprite(121, SpriteGroup.GUI))

			local objectiveComplete = false

			-- If quest is completed it's safe to save the objective has been met as well
			-- Even if it isn't any more ... we don't care about it here.
			-- This is a care free area.
			-- Breathe in slowly.
			if QuestManager.questCompleted({id = quest.getId()}) == true then
				objectiveComplete = true
			else
				objectiveComplete = quest.isObjectiveCompleted(i)
			end

			if objectiveComplete == true then
				listItem:accessoryType(ListRowAccessory.CheckmarkDark)
			end
		end

	-- Rewards
	elseif rightPageIndex == 3 then
		if quest.getNumberOfRewards() == 0 then
			rewardsList.setIsVisible(false)
			noRewardsText.setIsVisible(true)
		else
			rewardsList.setIsVisible(true)
			noRewardsText.setIsVisible(false)
			local listDataSource = LuaListDataSource(rewardsList:getDataSource())
			listDataSource:removeAllItems()
			for i=1, quest.getNumberOfRewards() do
				local listItem = LuaListDataItem(listDataSource:addItem({text = quest.getRewardText(i)}))
				listItem:icon(gSpriteManager.getSprite(121, SpriteGroup.GUI))
			end
		end
	end
end


-- Called on every GUI event (button click, list selection, etc.)
function Journal.onEventGUI (args)

	if Journal.isActive() == false then
		return false
	end

	local widget = LuaWidget(args.source)
	local parentWidget = nil

	if args.source ~= nil then
		if widget.getParent() ~= nil then
			parentWidget = LuaWidget(widget.getParent())
		end
	end

	if args.type == EventGUI.ButtonClicked then
		print("Button clicked!")
	elseif args.type == EventGUI.ListItemSelected then
		if widget.instance() == questsList.instance() then
			Journal.showQuestInfoForCurrentPage()
		end
	end

	return false
end

-- Called on mouse clicks, key presses etc.
function Journal.onEventSystem (args)

	return false
end

gLuaHandler.registerDelegateCallbacks(Journal, Delegates.EventsGUI, 0, Journal.onEventGUI)
gLuaHandler.registerDelegateCallbacks(Journal, Delegates.EventsSystem, 0, Journal.onEventSystem)
