MinigameFire = {}

local averageClickTime = 0.0
local totalClickTime = 0.0
local lastClickTime = -1.0
local timeCounter = 0.0
local totalClicks = 0
local spacePressed = false

function MinigameFire.onInit (param)

  averageClickTime = 0.0
  totalClickTime = 0.0
  lastClickTime = -1.0
  timeCounter = 0.0
  totalClicks = 0

  local rootWidget = LuaWidget(gGUI.getRootWidget(GameState.Minigame))

  -- gLuaHandler.registerDelegateCallbacks(MinigameFire, Delegates.EventsGUI, 0, MinigameFire.onEventGUI)
  -- gLuaHandler.registerDelegateCallbacks(MinigameFire, Delegates.EventsSystem, 0, MinigameFire.onEventSystem)

	MinigameFire.window = LuaWindow(gGUI.createWindow({
    parent = rootWidget.instance(),
		width = 200,
		height = 90,
		verticalAlignment = VerticalAlignment.Middle,
		id = "fireGameWnd",
		title = "%fiddling_about_with_sticks"
	}))

	local cancelButton = LuaButton(gGUI.createButton({
		parent = MinigameFire.window.instance(),
		x = MinigameFire.window.getWidth() / 2 - 50,
		y = MinigameFire.window.getHeight() - 13,
		width = 100,
		height = 18,
		title = "%cancel_button"
	}))

  cancelButton.onClick(function()
    gGame.endCurrentMiniGame()
  end)

  MinigameFire.progressBar = LuaProgressBar(gGUI.createProgressBar({
    parent = MinigameFire.window.instance(),
		x = 38,
		y = 30,
    value = 40.0,
		width = MinigameFire.window.getWidth() - 76
	}))

  gGUI.createImage({
    parent = MinigameFire.window.instance(),
    x = 20,
    y = 32,
    width = 32,
    height = 32,
    sprite = gSpriteManager.getSprite(203, SpriteGroup.GUI)
  })

  gGUI.createImage({
    parent = MinigameFire.window.instance(),
    x = MinigameFire.window.getWidth() - 20,
    y = 32,
    width = 32,
    height = 32,
    sprite = gSpriteManager.getSprite(202, SpriteGroup.GUI)
  })

  gGUI.createText({
    parent = MinigameFire.window.instance(),
    text = "%fire_minigame_text",
    textAlign = HorizontalAlignment.Center,
    y = 50,
    x = 10,
    width = MinigameFire.window.getWidth() - 20,
    height = 20
  })

end

function MinigameFire.onUpdate (frameTime)

  timeCounter = timeCounter + frameTime

  -- print(MinigameFire.calculateAverageClickRate())

  local clickTime = math.min(timeCounter - lastClickTime, 0.5)

  local val = MinigameFire.progressBar.getCurrentValue()
  val = val + ((averageClickTime - 3.0) * frameTime)
  MinigameFire.progressBar.setCurrentValue(val)
  averageClickTime = averageClickTime - (frameTime * 2)

  if val > 99 then
    gParty.enableCampfire(true)
    local player = LuaPlayer(gParty.getSelectedPlayer())
    gSoundManager.playSound(42, SoundGroup.SFX)
    if player.levelUpSkill(Skill.Firemaking, 30) == false then
      gGUI.showInformation({ key = "fire_started_msg", delay = 0.5})
    end
    gGame.endCurrentMiniGame()
  end

end

function MinigameFire.onDraw ()

  --[[local screenSize = gGUI.getScreenSize()

	-- Fill background
	gGame.fillRect({
		width = screenSize.x,
		height = screenSize.y,
		colorIndex = 0
	})

	local bgSprite = gSpriteManager.getSprite(188, SpriteGroup.GUI)

	gGame.drawSprite(bgSprite, {
		x = 0,
		y = (screenSize.y / 2) - 250
	})]]--


end

function MinigameFire.onClear ()
  gLuaHandler.unregisterDelegateCallbacks(MinigameFire)
end

-- Called on every GUI event (button click, list selection, etc.)
function MinigameFire.onEventGUI (args)

  print("GUI event");

	return false
end

-- Called on mouse clicks, key presses etc.
function MinigameFire.onEventSystem (args)

  if args.type == EventSystem.KeyPressed then
    if args.key.code == 57 then
      if spacePressed == false then
        MinigameFire.handleSpaceBar()
        return false
      end
    elseif args.key.code == 36 then
      gGame.endCurrentMiniGame()
      return false
    end
  elseif args.type == EventSystem.KeyReleased then
    if args.key.code == 57 then
      if spacePressed == true then
        spacePressed = false
        return false
      end
    end
  end

	return true
end

function MinigameFire.handleSpaceBar ()

  spacePressed = true

  gSoundManager.playSound(40, SoundGroup.SFX)

  if lastClickTime < 0 then
    totalClickTime = 1.0
    totalClicks = 1
  else
    local clickTime = math.min(timeCounter - lastClickTime, 0.5)
    totalClickTime = totalClickTime + clickTime
    if clickTime <= 0.12 then
      totalClickTime = totalClickTime * 0.95
    end
  end

  local player = LuaPlayer(gParty.getSelectedPlayer())
  local playerParams = LuaPlayerParams(player.getParams())

  local staminaAttr = playerParams.getAttribute(Attribute.Stamina)
  local energyLost = (0.3 - staminaAttr * 0.0012)

  player.decreaseEnergy(energyLost)


  totalClicks = totalClicks + 1
  lastClickTime = timeCounter
  averageClickTime = 1.0 / (totalClickTime / totalClicks)

end
