-- Some simple custom data types

Rect = {} 

setmetatable(Rect, {
    __index = Rect;
    __tostring = function(a)
		return "Rect: {"..a.left..", "..a.top..", "..a.width..", "..a.height.."}"
	end;
})

function Rect:new(prmLeft, prmTop, prmWidth, prmHeight)
    return setmetatable(
	{
		left = prmLeft or 0,
		top = prmTop or 0,
		width = prmWidth or 0,
		height = prmHeight or 0
	},
	getmetatable(self))
end 

Rect.containsPoint = function(self, p)
	if p.x >= self.left and p.y >= self.top and p.x <= (self.left + self.width) and p.y <= (self.top + self.height) then
		return true
	end
	return false
end




Vector2 = {} 

setmetatable(Vector2, {
    __index = Vector2;
	__add = function(a,b) return Vector2:new(a.x + b.x, a.y + b.y) end;
	__sub = function(a,b) return Vector2:new(a.x - b.x, a.y - b.y) end;
    __tostring = function(a)
		return "Vector2: {"..a.x..", "..a.y.."}"
	end;
})

function Vector2:new(prmX, prmY)
    return setmetatable(
	{
		x = prmX or 0,
		y = prmY or 0
	},
	getmetatable(self))
end




function __ternary(cond, T, F)
    if cond then return T else return F end
end

Towns = { Marciudad = 1, Reval = 2, Oldden = 3 }
