#include "rsa.h"

static unsigned char modulus[] = {
		0xb6, 0x1e, 0x19, 0x20, 0x91, 0xf9, 0x0a, 0x8f, 0x76, 0xa6, 0xea, 0xaa, 0x9a, 0x3c, 0xe5, 0x8c, 0x86, 0x3f,
		0x39, 0xae, 0x25, 0x3f, 0x03, 0x78, 0x16, 0xf5, 0x97, 0x58, 0x54, 0xe0, 0x7a, 0x9a, 0x45, 0x66, 0x01,
		0xe7, 0xc9, 0x4c, 0x29, 0x75, 0x9f, 0xe1, 0x55, 0xc0, 0x64, 0xed, 0xdf, 0xa1, 0x11, 0x44, 0x3f, 0x81,
		0xef, 0x1a, 0x42, 0x8c, 0xf6, 0xcd, 0x32, 0xf9, 0xda, 0xc9, 0xd4, 0x8e, 0x94, 0xcf, 0xb3, 0xf6, 0x90,
		0x12, 0x0e, 0x8e, 0x6b, 0x91, 0x11, 0xad, 0xda, 0xf1, 0x1e, 0x7c, 0x96, 0x20, 0x8c, 0x37, 0xc0, 0x14,
		0x3f, 0xf2, 0xbf, 0x3d, 0x7e, 0x83, 0x11, 0x41, 0xa9, 0x73
};

static unsigned char privkey[] = {
		0x77, 0x54, 0x55, 0x66, 0x8f, 0xff, 0x3c, 0xba, 0x30, 0x26, 0xc2, 0xd0, 0xb2, 0x6b, 0x80,
		0x85, 0x89, 0x59, 0x58, 0x34, 0x11, 0x57, 0xae, 0xb0, 0x3b, 0x6b, 0x04, 0x95, 0xee, 0x57, 0x80, 0x3e,
		0x21, 0x86, 0xeb, 0x6c, 0xb2, 0xeb, 0x62, 0xa7, 0x1d, 0xf1, 0x8a, 0x3c, 0x9c, 0x65, 0x79, 0x07, 0x76,
		0x70, 0x96, 0x1b, 0x3a, 0x61, 0x02, 0xda, 0xbe, 0x5a, 0x19, 0x4a, 0xb5, 0x8c, 0x32, 0x50, 0xae, 0xd5,
		0x97, 0xfc, 0x78, 0x97, 0x8a, 0x32, 0x6d, 0xb1, 0xd7, 0xb2, 0x8d, 0xcc, 0xcb, 0x2a, 0x3e, 0x01, 0x4e,
		0xdb, 0xd3, 0x97, 0xad, 0x33, 0xb8, 0xf2, 0x8c, 0xd5, 0x25, 0x05, 0x42, 0x51
};

void rsa_decrypt(unsigned char *input, unsigned char *output)
{
    unsigned char buf[RSA_BYTES];
    size_t outlen;
    
    mpz_t N; mpz_init(N);
    mpz_t D; mpz_init(D);
    mpz_t in_mpz; mpz_init(in_mpz);
    mpz_t out_mpz; mpz_init(out_mpz);
    
    mpz_import(N, RSA_BYTES, 1, 1, 1, 0, modulus);
    mpz_import(D, RSA_BYTES, 1, 1, 1, 0, privkey);
    mpz_import(in_mpz, RSA_BYTES, 1, 1, 1, 0, input);
    
    mpz_powm(out_mpz, in_mpz, D, N);
    
    
    mpz_export(buf, &outlen, 1, 1, 1, 0, out_mpz);
    
    for (int i = 0; i < RSA_BYTES - outlen; i++)
    {
        output[i] = 0x00;
    }
    memcpy(output + (RSA_BYTES - outlen), buf, outlen);
}

void rsa_encrypt(unsigned char *input, unsigned char *output)
{
    unsigned char buf[RSA_BYTES];
    size_t outlen;
    
    mpz_t N; mpz_init(N);
    mpz_t in_mpz; mpz_init(in_mpz);
    mpz_t out_mpz; mpz_init(out_mpz);
    
    mpz_import(N, RSA_BYTES, 1, 1, 1, 0, modulus);
    mpz_import(in_mpz, RSA_BYTES, 1, 1, 1, 0, input);
    
    mpz_powm_ui(out_mpz, in_mpz, 0x10001, N);
    
    
    mpz_export(buf, &outlen, 1, 1, 1, 0, out_mpz);
    
    for (int i = 0; i < RSA_BYTES - outlen; i++)
    {
        output[i] = 0x00;
    }
    memcpy(output + (RSA_BYTES - outlen), buf, outlen);
}