/*
 * Decompiled with CFR 0.152.
 */
package clientPKSM;

import clientPKSM.Client;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class MainWindow {
    private JFrame frmPksmClient;
    private JTextField txtHost;
    private File[] files;
    private String host;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    MainWindow window = new MainWindow();
                    window.frmPksmClient.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public MainWindow() {
        this.initialize();
    }

    private void initialize() {
        this.frmPksmClient = new JFrame();
        this.frmPksmClient.setTitle("servepkx");
        this.frmPksmClient.setBounds(100, 100, 486, 401);
        this.frmPksmClient.setDefaultCloseOperation(3);
        this.frmPksmClient.getContentPane().setLayout(null);
        this.txtHost = new JTextField();
        this.txtHost.setBounds(150, 29, 191, 20);
        this.frmPksmClient.getContentPane().add(this.txtHost);
        this.txtHost.setColumns(10);
        JLabel lblIpAddress = new JLabel("IP Address:");
        lblIpAddress.setBounds(39, 32, 84, 14);
        this.frmPksmClient.getContentPane().add(lblIpAddress);
        JButton btnConfirm = new JButton("Confirm IP Address");
        btnConfirm.setBounds(150, 80, 191, 52);
        this.frmPksmClient.getContentPane().add(btnConfirm);
        btnConfirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainWindow.this.txtHost.getText().isEmpty()) {
                    JOptionPane.showMessageDialog(MainWindow.this.frmPksmClient, "You MUST enter a valid IP address!", "Error", 0);
                } else {
                    MainWindow.this.host = MainWindow.this.txtHost.getText();
                    JOptionPane.showMessageDialog(MainWindow.this.frmPksmClient, "The following IP Address is currently set\nHost: " + MainWindow.this.host);
                }
            }
        });
        JButton btnSelectFiles = new JButton("Select .pk6/.pk7 files");
        btnSelectFiles.setBounds(150, 159, 191, 52);
        this.frmPksmClient.getContentPane().add(btnSelectFiles);
        btnSelectFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setMultiSelectionEnabled(true);
                fc.setDragEnabled(true);
                fc.setFileSelectionMode(0);
                fc.showOpenDialog(MainWindow.this.frmPksmClient);
                MainWindow.this.files = fc.getSelectedFiles();
            }
        });
        JButton btnSendFiles = new JButton("Send .pk6/.pk7 files");
        btnSendFiles.setBounds(150, 240, 191, 52);
        this.frmPksmClient.getContentPane().add(btnSendFiles);
        JLabel lblPksmClientV = new JLabel("servepkx v1.0 - Made by Slownic. To use with PKSM, by Bernardo Giordano.");
        lblPksmClientV.setBounds(20, 338, 450, 14);
        this.frmPksmClient.getContentPane().add(lblPksmClientV);
        btnSendFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Client client = new Client(MainWindow.this.host);
                String result = "The following files have been sent:\n";
                int i = 0;
                while (i < MainWindow.this.files.length) {
                    client.sendPKM(MainWindow.this.files[i]);
                    result = String.valueOf(result) + "\n" + MainWindow.this.files[i].getAbsolutePath();
                    ++i;
                }
                JOptionPane.showMessageDialog(MainWindow.this.frmPksmClient, result, "Files sent successfully!", 1);
            }
        });
    }
}

