
function chestlid(angle)
  --box
  local box = {{-0.5, -0.4}, {0.5, -0.4}, {0.5, 0.4}, {-0.5, 0.4}, {-0.5, -0.4}}

  opencap(0, box);
  extrude(0, 0.6, box)
  
  --sort the box out
  mutate(function(x, y, z) y,z = z,y return x,y,z end)
  flip()

  --make lid
  push()
  local lid = {{-0.4, 0}, {-0.25, 0.3}, {0, 0.4}, {0.25, 0.3}, {0.4, 0}}
  opencap(-0.5, lid)
  extrude(-0.5, 0.5, lid)
  closecap(0.5, lid)

  --sort the lid out
  flip()
  rotate({0,1,0}, 90)
  transform{0,0,0.4}
  rotate({1,0,0}, angle)
  transform{0,0.6,-0.4}

  -- merge and colour
  merge()
  setparams{0.8,0.2,0.0}

  -- make interior
  duplicate()
  flip()
  setparams{0.4,0.0,0.1}
  merge()

  -- add lock
  push()
  local lock = {{-0.1, 0}, {0.1, 0}, {0.1, -0.1}, {0, -0.2}, {-0.1, -0.1}, {-0.1, 0}}
  opencap(0, lock)
  transform{0,0.6,0.41}
  setparams{0.9,0.9,0.2}
  merge()  
end

function chest()
  chestlid(-120)
end

function chestclosed()
  chestlid(0)
end

function glow()
  properties("particles/dot", 12, 0.1)

  initcolor({1,0,0},{1,0,1})
  initsize(0.2,0.3)
  positionbox({-1.0,2.0,-1.0}, {1.0,2.5,1.0})
  velocitytarget(3, {0, -0.4, 0})
  velocitybox({-0.1, 0, -0.1}, {0.1, 0, 0.1})

  movement{0, 2, 0}
  easealpha({0, 0.5, 0.9, 1.0}, 0.3)
end

