
function crystal()
  local cross = {{0, -0.5}, {0.3, -0.25}, {0.3, 0.25}, {0, 0.5}}
  
  for i=0,359,60 do
    extrude(i, i + 60, cross)
  end

  wind()
  setparams{0.7,0.3,0.8}
end

function diamond()
  local cross = {{0, -0.5}, {0.4, 0}, {0, 0.5}}

  for i=0,359,90 do
    extrude(i, i + 90, cross)
  end

  wind()
  setparams{0.9,0.9,0.9}
end

function basebeams()
  properties("particles/beams", 10, 0.4)

  initsize(0.5,1.0)
  initroll(-30,30)
  initlifespan(1.5)
  
  easealpha({0, 0.5, 0.6, 1.0}, 0.75)
  tendsize(0,1,4)
  rotation(5, true)
end

function beams()
  basebeams()
  initcolor({0.9,0.2,0.9},{1,0.3,1})
end

function fakebeams()
  basebeams()
  initcolor({0.9,0.9,0.9},{1,1,1})
end

function burst()
  properties("particles/star", 100, 0.0, 1.0)

  initcolor({0.5,0.1,0.5}, {0.7,0.2,0.7})
  initsize(1.0,1.5)
  initlifespan(2.0, 4.0)
  initroll(0, 360)

  positionsphere(0.8)
  velocitytarget(-4)
  velocitybox({-2,-2,-2},{2,2,2})

  movement{0,0,0}
  tendsize(0.4,1.0,0.0)
end

