
function key()
  --handle
  local cross = {{0.2, -0.1}, {0.4, -0.1}, {0.4, 0.1}, {0.2, 0.1}, {0.2, -0.1}}

  for n=0,359,45 do
    extrude(n, n + 45, cross)
  end
  wind()
  rotate({1,0,0}, 90)

  --body
  push()

  local body = {{0.3, 0.1}, {1.0, 0.1}, {1.0, -0.4}, {0.8, -0.4}, {0.8, -0.1}, {0.7, -0.1}, {0.7, -0.4}, {0.5, -0.4}, {0.5, -0.1}, {0.3, -0.1}, {0.3, 0.1}}
  opencap(-0.1, body)
  extrude(-0.1, 0.1, body)
  closecap(0.1, body)

  flip()
  merge()

  transform{-0.35, 0.0, 0}
  setparams{1.0,0.875,0.25}
end

function glow()
  properties("particles/twinkle", 1, 0.4)

  initcolor{1,1,1}
  initsize(0.4,0.5)
  initroll(0, 360)
  initlifespan(0.7,1.2)
  positionsphere(0,0.8)

  detach()
  easealpha({0, 0.3, 0.4, 1.0}, 0.6)
end

function collapse()
  properties("particles/triangle", 20, 0, 0.2)

  initcolor({1,0.75,0.1}, {1,0.875,0.25})
  initsize(0.5, 0.7)
  initlifespan(0.5, 0.75)
  initroll(0, 360)
  positionbox({-0.3, -0.3, -0.3}, {0.3, 0.3, 0.3})
  velocitybox({-1.5, -0.75, -1.5}, {1.5, 0.75, 1.5})

  movement{0, 0, 0}
  tendalpha(0.4, 1.0, 0.0)
  rotation(230)
end


