
function book()
  local w = 1.3
  local h = 0.9
  local binding = {{-w, -h}, {w, -h}, {w, h}, {-w, h}, {-w, -h}}
  
  extrude(-0.05, 0.0, binding)
  closecap(0.0, binding)
  rotate({1,0,0}, -90)
  setparams{0.1, 0.3, 0.2}
  
  push()
  local pages = {{1.0, 0}, {0.6, 0.3}, {0.2, 0.25}, {0, 0.1},
                 {-0.2, 0.25}, {-0.6, 0.3}, {-1.0, 0}, {1.0, 0}}

  opencap(-0.7, pages)
  extrude(-0.7, 0.7, pages)
  closecap(0.7, pages)
  
  setparams{1.0, 1.0, 0.9}
  merge()
end

function plinth()
  local a = 0.6
  local b = 0.4
  local base = {{-a, -a}, {a, -a}, {a, a}, {-a, a}, {-a, -a}}
  local top = {{-b, -b}, {b, -b}, {b, b}, {-b, b}, {-b, -b}}

  opencap(-0.2, base)
  extrude(-0.2, 0.0, base, top)
  closecap(0.0, top)

  rotate({1,0,0}, -90)

  setparams{0.55,0.55,0.59}
end

