function ring()
  local cross = {{0.1, 0.0}, {0.2, -0.1}, {0.3, 0.0}, {0.2, 0.1}, {0.1, 0.0}}

  for i=0,359,60 do
    extrude(i, i + 60, cross)
  end

  wind()
  rotate({1,0,0}, 90)
  setparams{0.9,0.7,0.1}

  push()

  local diamond = {{0.1, -0.2}, {0.2, 0.0}, {0.0, 0.1}}
  
  for i=0,359,90 do
    extrude(i, i + 90, diamond)
  end

  wind()
  transform{0,0.4,0}
  setparams{0.95,0.95,1.0}

  merge()
end

function play()
  properties("particles/circle", 4, 0.5)

  initcolor({1,1,1})
  initalpha(0.4)
  initsize(0.2)
  initroll(0,360)
  initlifespan(0.8)

  detach()
  tendalpha(0.25,1,0)
  tendsize(0,1,4)
end
