function handle()
  local handle = {{2,0}, {3,-1}, {4,0}, {3, 1}, {2, 0}}
  extrude(0, 40, handle)
  extrude(40, 100, handle)
  extrude(100, 160, handle)
  extrude(160, 210, handle)
  wind()

  mutate(function(x, y, z) x,y,z = -z,-x,y return x,y,z end)
  scale{0.08, 0.08, 0.08}
end

function jar()
  local cross = { {0,0}, {0.55,0}, {0.6, 0.1}, {0.5,0.6}, {0.6,0.8} }
  for i=0,359,60 do
    extrude(i, i + 60, cross)
  end

  wind()

  push()
  handle()
  rotate({0,0,1}, 5)
  transform{-0.57,0.4,0}
  merge()

  push()
  handle()
  rotate({0,0,1}, 5)
  rotate({0,1,0}, 180)
  transform{0.57,0.4,0}
  merge()

  setparams{0.6,0.9,1.0}

  push()
  local inside = { {0.6,0.8}, {0.4,0.7}, {0.4,0.2} }
  for i=0,359,60 do
    extrude(i, i + 60, inside)
  end
  wind()
  setparams{0.0,0.1,0.04}
  merge()
end

function glow()
  properties("particles/dot", 50, 0.012)
  initcolor({0.2,0.25,0.2}, {0.2,0.75,0.2})
  initsize(1.25, 1.5)
  initlifespan(0.5)
  positionbox({-0.3, -0.1, -0.3}, {0.3, -0.1, 0.3})
  velocitybox({0, 2, 0})

  movement{0, 10, 0}
  easealpha({0, 0.2, 0.6, 1.0}, 0.08)
  tendsize(0.2, 1.0, 0.1)
end

function sparkle()
  properties("particles/star", 20, 0.04)
  initcolor({0.2,0.25,0.2}, {0.2,0.75,0.2})
  initsize(0.5, 0.6)
  initroll(0, 360)
  initlifespan(0.5)
  positionbox({-0.4, 0, -0.4}, {0.4, 0, 0.4})
  velocitybox({0, 2, 0})

  movement{0, 15, 0}
  easealpha({0, 0.04, 0.1, 1.0}, 0.8)
end

function burnout()
  properties("particles/dot", 50, 0.0, 0.2)
  initcolor({0.2,0.25,0.2}, {0.2,0.75,0.2})
  initsize(0.6, 0.8)
  initlifespan(0.5, 0.8)
  initalpha(0.4)
  positionbox({-0.1, -0.5, -0.1}, {0.1, 1.0, 0.1})
  velocitybox({-3, 0, -3}, {3, 0, 3})

  movement{0, 10, 0}
  tendsize(0.2, 1.0, 0.0)
end

function shatter()
  properties("particles/triangle", 50, 0.0, 0.2)
  initcolor({0.5,0.9,1.0}, {0.7,1.0,1.0})
  initsize(0.6, 0.8)
  initlifespan(0.5, 0.8)
  initroll(0, 360)
  positionbox({-0.1, -0.5, -0.1}, {0.1, 1.0, 0.1})
  velocitybox({-5, -4, -5}, {5, 4, 5})

  movement{0, -2, 0}
  tendalpha(0.4, 1.0, 0.0)
  rotation(230)
end

