-- oobleck spin permute

local metal = { ["7"] = "panel_ul", ["8"] = "panel_u", ["9"] = "panel_ur",
                ["4"] = "panel_l",  ["5"] = "panel_c", ["6"] = "panel_r",
                ["1"] = "panel_dl", ["2"] = "panel_d", ["3"] = "panel_dr",
                ["<"] = "panel_fs", [">"] = "panel_bs",
                E = "panel_k1", F = "panel_k2", B = "panel_k3",
                o = "block", ["="] = "girder_h", ["|"] = "girder_v",
                w = "warning", [":"] = "back", ["'"] = "back_d", ["-"] = "ledge" }

local water = { w = "water", ["^"] = "water_s", b = "buoy" }

function start(wet)
  ApplyTiles(metal, 0, 0, [[
o==================o
|..................|
|..................|
|..................|
7889.........789...|
4556.........456...|
1223.........123...|
9o.................|
6|.................|
6|.................|
3|.....o7889owwwwwwo
9|.....|4556|789789|
6|.....|4556|456456|
6|.....|1223|123123|
3o=====o7889|788889|
]])

  if wet then
    ApplyTiles(water, 0, 1, [[
.wwwwwwwwwwwwwwwwww.
.wwwwwwwwwwwwwwwwww.
.wwwwwwwwwwwwwwwwww.
....wwwwwwwww...www.
....wwwwwwwww...www.
....wwwwwwwww...www.
..wwwwwwwwwwwwwwwww.
..wwwwwwwwwwwwwwwww.
..wwwwwwwwwwwwwwwww.
..wwwww.............
..wwwww.............
..wwwww.............
..wwwww.............
]])
  else
    ApplyTiles(water, 0, 10, [[
..^^^^^.............
..wwwww.............
..wwwww.............
..wwwww.............
]])
  end

  Spawn("player", 2.5, 3)
  Spawn("chest", 8.9, 9.5, "tarts")
  Spawn("key", 11.2, 9.5)
  Spawn("lock", 14.5, 8.5)
  Spawn("generic", 17.5, 9.5)
end

function tarts(wet)
  ApplyTiles(metal, 0, 0, [[
o===========12231223
|...........78897889
|...........45564556
|...........45564556
|wwwww......12231223
o====o......o======o
|...........|......|
|...........|......|
|...........|......|
|...........o......|
|..............o...|
|..............|...|
o..............|...|
897889..7889o==o===o
564556..4556|79|789|
]])

  if wet then
    ApplyTiles(water, 0, 1, [[
.wwwwwbbwwww........
.wwwwwbbwwww........
.wwwwwbbwwww........
......bbwwww........
......bbwwww........
.wwwwwbbwwww.wwwwww.
.wwwwwbbwwww.wwwwww.
.wwwwwbbwwww.wwwwww.
.wwwwwbbwwww.wwwwww.
.wwwwwbbwwwwwww.www.
.wwwwwbbwwwwwww.www.
.wwwwwbbwwwwwww.www.
......bb............
......bb............
]])
  else
    ApplyTiles(water, 0, 13, [[
......bb............
......bb............
]])
  end

  Spawn("player", 3.2, 3)
  Spawn("chest", 9.9, 12.5, "start")
  Spawn("box", 17.5, 12.5)
  Spawn("crystal", 2.5, 7.5)
end

tiles = "tiles/city"
pattern = "backgrounds/tech"
dark = { 0.1, 0.02, 0.04 }
light = { 0.24, 0.07, 0.10 }

