-- oobleck medium water

local metal = { ["7"] = "panel_ul", ["8"] = "panel_u", ["9"] = "panel_ur",
                ["4"] = "panel_l",  ["5"] = "panel_c", ["6"] = "panel_r",
                ["1"] = "panel_dl", ["2"] = "panel_d", ["3"] = "panel_dr",
                ["<"] = "panel_fs", [">"] = "panel_bs",
                E = "panel_k1", F = "panel_k2", B = "panel_k3",
                o = "block", ["="] = "girder_h", ["|"] = "girder_v",
                w = "warning", [":"] = "back", ["'"] = "back_d", ["-"] = "ledge" }

local water = { w = "water", ["^"] = "water_s", b = "buoy" }

function start()
  ApplyTiles(metal, 0, 0, [[
56................12
23................78
89................45
56................12
23......7889......78
=o......1223......45
:|................12
'|................o=
:|................|'
'|................|'
:|................|'
'|................|'
:|................|'
'o================o'
:':':':':':':':':':'
]])

  ApplyTiles(water, 0, 8, [[
..^^^^^^^^^^^^^^^^..
..wwwwwwwwwwwwwwww..
..wwwwwwwwwwwwwwww..
..wwwwwwwwwwwwwwww..
..wwwwwwwwwwwwwwww..
]])

  Spawn("player", 10, 3)
  Spawn("chest", 6.2, 12.5, "trough")
  Spawn("chest", 13.8, 12.5, "sponge")
end

function trough(wet)
  ApplyTiles(metal, 0, 0, [[
556|:':':':':':':|45
223|'''''''''''''|12
889o=============o==
556|.............|:'
556|.............|''
223|.............|:'
===|..........o==o==
889|..........|:'|:'
556|..........|''|''
556|..........|:'|:'
223|..........|''o==
===|..........|:'|:'
:':|..........|''|''
'''o======owwwo:'|:'
:':|:':':'|:':|''|''
]])

  if wet then
    ApplyTiles(water, 0, 3, [[
....wwwwwwwbbbwww...
....wwwwwwwbbbwww...
....wwwwwwwbbbwww...
....wwwwwwwbbb......
....wwwwwwwwww......
....wwwwwwwwww......
....wwwwwwwwww......
....wwwwwwwwww......
....wwwwwwwwww......
....wwwwwwwwww......
]])
  else
    ApplyTiles(water, 0, 9, [[
...........bbb......
...........bbb......
...........bbb......
...........bbb......
]])
  end

  Spawn("player", 6, 12)
  Spawn("generic", 15.2, 5.5)
  Spawn("chest", 12.5, 12.5, "twist")
end

function sponge(wet)
  ApplyTiles(metal, 0, 0, [[
89122231222312223122
56.......78889788897
56.......45556455564
56.......455E6455564
23.......455E6455564
==o=o....12223122231
:'|'|............o==
==o=o............|:'
:':'|............|''
''''|.........o==o==
====o.........|:':':
:':'|.........|'''''
''''|.........|:':':
:':'|.........|'''''
''''o=====owwwo:':':
]])

  if wet then
    ApplyTiles(water, 0, 5, [[
.....^^^^...........
.....wwwwwwbbbwww...
.....wwwwwwbbbwww...
.....wwwwwwbbbwww...
.....wwwwwwbbb......
.....wwwwwwwww......
.....wwwwwwwww......
.....wwwwwwwww......
.....wwwwwwwww......
]])
  else
    ApplyTiles(water, 0, 10, [[
...........bbb......
...........bbb......
...........bbb......
...........bbb......
]])
  end

  Spawn("player", 7.4, 13)
  Spawn("crystal", 15.5, 7.5)
end

function twist(wet)
  ApplyTiles(metal, 0, 0, [[
889|:':':':':':'|:':
556|''''''''''''|'''
556|:':':':':':'|:':
223|''''''''''''|'''
889o============o:':
556|............|'''
556|............|===
223|............|788
889|............|455
556|............|455
556o============o122
223|797979797979|788
889|1<><><><><>3|455
556|7><><><><><9|455
556|1<><><><><>3|122
]])

  if wet then
  ApplyTiles(water, 0, 5, [[
....wwwwwwwwwwww....
....wwwwwwwwwwww....
....wwwwwwwwwwww....
....wwwwwwwwwwww....
....wwwwwwwwwwww....
]])
  end

  Spawn("player", 10, 9)
  Global("box", 7.5, 9.5)
end

tiles = "tiles/city"
pattern = "backgrounds/tech"
dark = { 0.1, 0.02, 0.04 }
light = { 0.24, 0.07, 0.10 }

