-- oobleck jar global

local metal = { ["7"] = "panel_ul", ["8"] = "panel_u", ["9"] = "panel_ur",
                ["4"] = "panel_l",  ["5"] = "panel_c", ["6"] = "panel_r",
                ["1"] = "panel_dl", ["2"] = "panel_d", ["3"] = "panel_dr",
                ["<"] = "panel_fs", [">"] = "panel_bs",
                E = "panel_k1", F = "panel_k2", B = "panel_k3",
                o = "block", ["="] = "girder_h", ["|"] = "girder_v",
                w = "warning", [":"] = "back", ["'"] = "back_d", ["-"] = "ledge" }

local water = { w = "water", ["^"] = "water_s", b = "buoy" }

local black = { o = "black", ["<"] = "black_ul", [">"] = "black_ur",
                s = "black_s", ["-"] = "black_ledge" }

local crazy = { o = "black", ["-"] = "black_ledge",
                z = "glitch_tunnel", ["#"] = "glitch_check", ["?"] = "glitch_ugly",
                ["1"] = "glitch_static1", ["2"] = "glitch_static2", ["3"] = "glitch_static3",
                ["4"] = "glitch_static4", ["5"] = "glitch_static5" }

function start()
  ApplyTiles(metal, 0, 0, [[
556..............455
556..............455
223..............122
89................78
56................45
56................45
23................12
=o................o=
9|................|7
6|789..........789|4
6|456..........456|4
3|123..........123|1
=o================o=
'|:':':':':':':':'|:
'|''''''''''''''''|'
]])

  Spawn("player", 7.6, 11)
  Spawn("chest", 12.4, 11.5, "splasher")
  Spawn("chest", 3.5, 8.5, "victory")
  Spawn("chest", 16.5, 8.5, "pedestal")
end

function victory(wet)
  ApplyTiles(metal, 0, 0, [[
79............|:':':
46............|:':':
46............|'''''
13............|====o
79....79......|....|
46....46......|====|
46....46......|....|
13....13......|====|
oowwwwoo......o....|
||7889||...........|
||4556||...........|
||1223||...........|
oo====oo======o====o
89788978897889|7889|
56455645564556|4556|
]])

  if wet then
    ApplyTiles(water, 0, 0, [[
..wwwwwwwwwwww......
..wwwwwwwwwwww......
..wwwwwwwwwwww......
..wwwwwwwwwwww......
..wwww..wwwwww.wwww.
..wwww..wwwwww......
..wwww..wwwwww.wwww.
..wwww..wwwwww......
........wwwwww.wwww.
........wwwwwwwwwww.
........wwwwwwwwwww.
........wwwwwwwwwww.
]])
  end

  Spawn("player", 3.5, 7)
  Spawn("yield", 9.8, 11)
  Spawn("lock", 14.5, 10.5)
  Spawn("crystal", 17, 10.5)
end

function pedestal(wet)
  ApplyTiles(metal, 0, 0, [[
9o============o'''''
3|............|:':':
9|............|'''''
3|............|:':':
9|............|'''''
3|............o===o=
9|.....7889.......|7
3|.....4556.......|4
=o.....4556.......|4
7889...1223.......|1
4556...7889.......|7
1223...4556.......|4
88978894556.......|4
55645561223wwwwwwwo1
55645567889788978897
]])

  if wet then
    ApplyTiles(water, 0, 1, [[
..wwwwwwwwwwww......
..wwwwwwwwwwww......
..wwwwwwwwwwww......
..wwwwwwwwwwww......
..wwwwwwwwwwww......
..wwwww....bbbbwww..
..wwwww....bbbbwww..
..wwwww....bbbbwww..
....www....bbbbwww..
....www....wwwwwww..
....www....wwwwwww..
...........wwwwwww..
]])
  else
    ApplyTiles(water, 0, 9, [[
...........bbbb.....
...........bbbb.....
...........bbbb.....
...........bbbb.....
]])
  end

  Spawn("player", 5.5, 11)
  Spawn("key", 16.5, 12.5)
end

function splasher(wet)
  ApplyTiles(metal, 0, 0, [[
13................79
79................13
13................79
79................13
13................o=
=o................|7
9|................|4
6|................|4
6|7889........7889|4
6|4556........4556|4
6|4556........45F6|4
3|1223........1223|1
====o==========o====
:':'|:':':':':'|:':'
''''|''''''''''|''''
]])

  if wet then
  ApplyTiles(water, 0, 0, [[
..wwwwwwwwwwwwwwww..
..wwwwwwwwwwwwwwww..
..wwwwwwwwwwwwwwww..
..wwwwwwwwwwwwwwww..
..wwwwwwwwwwwwwwww..
..wwwwwwwwwwwwwwww..
..wwwwwwwwwwwwwwww..
..wwwwwwwwwwwwwwww..
......wwwwwwww......
......wwwwwwww......
......wwwwwwww......
......wwwwwwww......
]])
else
  ApplyTiles(water, 0, 8, [[
......^^^^^^^^......
......wwwwwwww......
......wwwwwwww......
......wwwwwwww......
]])
end

  Spawn("player", 3.8, 7)
  Global("generic", 16.2, 7.5)
end

function glitch()
  ApplyTiles(crazy, 0, 0, [[
1.4233o??oozzzooo.#o
.2.2o1ooozzzzoooo#o#
3.5oo.oooo.......?#o
3412oooooo.......#o#
ooo.oozooo.......?#o
oo#oo3oo.........#o#
1o#oo............?#o
1o#o........zzooo?oo
oo#.........zzozo?5o
o2...???o....zooo?41
.#...o??o...zzzo.?52
oo.##zz?#zoo.oooo?4o
?#.ooozoooo.oo.oooo3
?o.ozoozo.oo.oooo?3o
?oo2o3o4o4o.zzzooo12
]])

  Spawn("player", 15, 6)
end

function reject()
  ApplyTiles(black, 0, 0, [[
oooooooooooooooooooo
oooooooooooooooooooo
oo<...........o...>o
oo.................o
oo.................o
oo.................o
oo--oo........oooooo
oo..oo........oooooo
oo..oo........oosooo
oo--oo........oooooo
oo..oo........oooooo
oo..oo........oosooo
oooooooooooooooooooo
oooooooooooooooooooo
oooooooooooooooooooo
]])

  Spawn("player", 3, 11)
  Spawn("chest", 8, 11.5, "skyward")
  Global("fan", 12, 11.5)
  Spawn("lock", 14.5, 4.5)
  Spawn("diamond", 17, 3.8)
end

function skyward()
  ApplyTiles(black, 0, 0, [[
ooo....ooooooooooooo
o<...............>oo
o.................oo
o.................oo
o.................oo
ooo----ooooo......oo
ooo....ososo......oo
oooooooooooo......oo
oo................oo
oo................oo
oo................oo
oo................oo
oo................oo
oooooooooooooooooooo
oooooooooooooooooooo
]])

  Spawn("player", 9.6, 12)
  Spawn("generic", 15.1, 12.5)
  Spawn("key", 5, 6.5)
end

tiles = "tiles/city"
pattern = "backgrounds/tech"
dark = { 0.1, 0.02, 0.04 }
light = { 0.24, 0.07, 0.10 }

