-- oobleck jar global

local metal = { ["7"] = "panel_ul", ["8"] = "panel_u", ["9"] = "panel_ur",
                ["4"] = "panel_l",  ["5"] = "panel_c", ["6"] = "panel_r",
                ["1"] = "panel_dl", ["2"] = "panel_d", ["3"] = "panel_dr",
                ["<"] = "panel_fs", [">"] = "panel_bs",
                E = "panel_k1", F = "panel_k2", B = "panel_k3",
                o = "block", ["="] = "girder_h", ["|"] = "girder_v",
                w = "warning", [":"] = "back", ["'"] = "back_d", ["-"] = "ledge" }

local water = { w = "water", ["^"] = "water_s", b = "buoy" }

local black = { o = "black", ["<"] = "black_ul", [">"] = "black_ur",
                s = "black_s", ["-"] = "black_ledge" }

local crazy = { o = "black", ["-"] = "black_ledge",
                z = "glitch_tunnel", ["#"] = "glitch_check", ["?"] = "glitch_ugly",
                ["1"] = "glitch_static1", ["2"] = "glitch_static2", ["3"] = "glitch_static3",
                ["4"] = "glitch_static4", ["5"] = "glitch_static5" }

function start()
  ApplyTiles(metal, 0, 0, [[
22231222379122231222
o========46========o
|........46........|
o========13........o
|.........|........|
|.........|........|
|........79........|
|........46........|
|........46........|
|........13........|
owwww789....789wwwwo
7889|456....4E6|7889
4556|123....123|4556
4556|79------79|4556
1223|13......13|1223
]])

  Spawn("player", 6.6, 9)
  Global("key", 9.3, 5.5)
  Global("chest", 3.2, 9.5, "doormat")
  Spawn("chest", 16.8, 9.5, "crypt")
end

function doormat()
  ApplyTiles(metal, 0, 0, [[
|.............|....|
|.............o====o
|..................|
|..................|
|..................|
|.......789........|
|.......456........|
|.......123.......oo
owwwo.............|7
7889|............oo1
4556|....o.......|79
4556|....|......oo1<
1223|....|......|791
7889|oooo|=====oo1<9
4556|....|'''''|791<
]])

  Spawn("player", 6.8, 11)
  Spawn("yield", 11.8, 12)
  Spawn("box", 3.3, 7.5)

  ApplyTiles(metal, 5, 13, "----") -- patch in under-player drop
end

function crypt()
  ApplyTiles(metal, 0, 0, [[
owwwwwwwwwwwo===o455
|...........|'''|455
|...........|:''|122
|...........|'''o==o
|...........|:':':'|
|...........|''''''|
o====o......|:':':'|
|....|......|''''''|
o=o==o......o======o
..|..|.............|
==o==o.............|
.....|.............|
=====owwwwwwo======o
88889|788889|788889|
55556|4555B6|455556|
]])

  Spawn("player", 2.2, 5)
  Spawn("generic", 4.8, 5.5)
  Spawn("lock", 13.1, 10.5)
  Spawn("lock", 14.3, 10.5)
  Spawn("lock", 15.5, 10.5)
  Spawn("crystal", 17.5, 10.5)
end

function glitch()
  ApplyTiles(crazy, 0, 0, [[
o##oo521...54o?oo.??
##o.o43...3215oo.o.o
o#oo5o21....432oo.o.
.#o.o43......15ooo.o
.#ooz1.......4o2o14.
.#z#oo2.......3o?zzo
###o4o.......ooooooo
oz#ooo.........ooz?z
z.?oo...........o#o.
ozoo...........oozzo
o#ooo...........o2oo
zozo............ozo?
ozoz............?o?o
zozo##?###zzo???z?o?
oz5#?##4z?#z?oo??o1o
]])

  Spawn("player", 6.4, 12)
end

function reject()
  ApplyTiles(black, 0, 0, [[
oooooooooooooooooooo
o<...............>oo
o.................oo
o---o.............oo
o...o.............oo
o...o.............oo
ooooo.............oo
ooooo.............oo
ooooo.............oo
ooooo.............oo
ooooo....ooooooooooo
ooooo....ooooooooooo
ooooo....oosoosoosoo
ooooo....ooooooooooo
oooooooooooooooooooo
]])

  ApplyTiles(water, 0, 10, [[
.....^^^^...........
.....wwww...........
.....wwww...........
.....wwww...........
]])

  Spawn("player", 2.5, 5)
  Spawn("chest", 10.7, 9.5, "drylock")
  Global("fan", 13.4, 9.5)
  Spawn("chest", 16.2, 9.5, "trip")
end

function drylock(wet)
  ApplyTiles(black, 0, 0, [[
oooooooooooooooooooo
oooooooooooooooooooo
oooooooooooooooooooo
ooooo..........ooooo
oo<oo..........oo>oo
ooooo..........ooooo
oosoo..........oo.oo
ooooo..........ooooo
oosoo..........oosoo
ooooo..........ooooo
oosoo..........oosoo
ooooo..........ooooo
oooooooooooooooooooo
oooooooooooooooooooo
oooooooooooooooooooo
]])

  if wet then
    ApplyTiles(water, 0, 3, [[
.....wwwwbbbbbb.....
.....wwwwbbbbbb.....
.....wwwwbbwwww.....
.....wwwwbbwwww.....
.....wwwwbbwwww.....
.....wwwwwwwwww.....
.....wwwwwwwwww.....
.....wwwwwwwwww.....
.....wwwwwwwwww.....
]])
  else
    ApplyTiles(water, 0, 7, [[
.........bbbbbb.....
.........bbbbbb.....
.........bb.........
.........bb.........
.........bb.........
]])
  end

  Spawn("player", 7.2, 11)
  Spawn("generic", 12.8, 11.5)
end

function trip(wet)
  ApplyTiles(black, 0, 0, [[
oooooooooooooooooooo
o.........oooooooooo
o.........oooooooooo
o.........o........o
o...ooooooo........o
o...oooooso........o
o......oooo...o....o
o......oooo...o....o
oooo..........o....o
oooo..........oooooo
oooo..........oossoo
ooooooo....ooooooooo
ooooooo....ooooooooo
ooooooo....ooooooooo
oooooooooooooooooooo
]])

  if wet then
    ApplyTiles(water, 0, 1, [[
.wwwwwwww...........
.wwwwwwww...........
.wwwwwwww..bbbwwwww.
.www.......bbbwwwww.
.www.......bbbwwwww.
.wwwbbb....bbb.wwww.
.wwwbbb....bbb.wwww.
....bbbwwwwbbb.wwww.
....bbbwwwwbbb......
....bbbwwwwbbb......
....bbbwwwwbbb......
....bbbwwwwbbb......
....bbbwwwwbbb......
....bbb....bbb......
]])
  else
    ApplyTiles(water, 0, 11, [[
....bbb....bbb......
....bbb....bbb......
....bbb....bbb......
....bbb....bbb......
]])
  end

  Spawn("player", 8.5, 13)
  Spawn("key", 17, 8.5)
  Spawn("generic", 5, 3.5)
  Spawn("lock", 6.5, 2.5)
  Spawn("diamond", 8.5, 2.5)
end

tiles = "tiles/city"
pattern = "backgrounds/tech"
dark = { 0.1, 0.02, 0.04 }
light = { 0.24, 0.07, 0.10 }

