-- oobleck room mixup

local metal = { ["7"] = "panel_ul", ["8"] = "panel_u", ["9"] = "panel_ur",
                ["4"] = "panel_l",  ["5"] = "panel_c", ["6"] = "panel_r",
                ["1"] = "panel_dl", ["2"] = "panel_d", ["3"] = "panel_dr",
                ["<"] = "panel_fs", [">"] = "panel_bs",
                E = "panel_k1", F = "panel_k2", B = "panel_k3",
                o = "block", ["="] = "girder_h", ["|"] = "girder_v",
                w = "warning", [":"] = "back", ["'"] = "back_d", ["-"] = "ledge" }

function start()
  ApplyTiles(metal, 0, 0, [[
12223.........122231
====o.........o=====
8889............7888
5556............4555
55B6............4555
5556............4555
2223............1222
===o............o===
...|............|...
...|............|...
...|............|...
...|............|...
===o============o===
88978889788897888978
55645556455564555645
]])

  Spawn("player", 10, 11)
  Spawn("chest", 7, 11.5, "climb")
  Spawn("chest", 13, 11.5, "bin")
end

function bin()
  ApplyTiles(metal, 0, 0, [[
12237889788978891223
9788>2231223122<8897
31223788978897912231
====o1223122313o====
''''|..........|:':'
:':'|..........|''''
''''|..........|:':'
====o..........|''''
89789..........|:':'
56456..........|''''
23123..........|''''
====o====owwwwwo====
78978978978978897897
45645645645645564564
12312312312312231231
]])

  Spawn("player", 8, 10)
  Spawn("generic", 12, 10.5)
end

function climb()
  ApplyTiles(metal, 0, 0, [[
o|...............123
o|...............789
o|...............123
o|...............789
o|...............123
o|...............789
o|789789.........123
o|123123.........o==
o|789789.........|..
o|123123.........|..
o|789789.........|..
o|123123.........|..
=|=====o=========o==
'|:':':':':':':':':'
'|''''''''''''''''''
]])

  Spawn("player", 13.8, 11)
  Spawn("box", 9.1, 11.5)
  Spawn("chest", 5, 5.5, "peak")
end

function peak()
  ApplyTiles(metal, 0, 0, [[
913|.............o=o
<9o|.............|.|
1<9|.............|.|
913|.............|.|
<9o|.............|.|
1<9|.............|.|
913|........78889|.|
<9o|........45556|.|
1<9|........455F6|.|
913|........455B6|.|
<9o|........12223|.|
1<9o=============o=o
91<9o79o79o79o79o79o
<91<91<91<91<91<91<9
1<91<91<91<91<91<91<
]])

  Spawn("player", 6.8, 10)
  Spawn("crystal", 14.5, 3.5)
end

tiles = "tiles/city"
pattern = "backgrounds/tech"
dark = { 0.1, 0.02, 0.04 }
light = { 0.24, 0.07, 0.10 }

