-- oobleck simple water

local metal = { ["7"] = "panel_ul", ["8"] = "panel_u", ["9"] = "panel_ur",
                ["4"] = "panel_l",  ["5"] = "panel_c", ["6"] = "panel_r",
                ["1"] = "panel_dl", ["2"] = "panel_d", ["3"] = "panel_dr",
                ["<"] = "panel_fs", [">"] = "panel_bs",
                E = "panel_k1", F = "panel_k2", B = "panel_k3",
                o = "block", ["="] = "girder_h", ["|"] = "girder_v",
                w = "warning", [":"] = "back", ["'"] = "back_d", ["-"] = "ledge" }

local water = { w = "water", ["^"] = "water_s", b = "buoy" }

function start()
  ApplyTiles(metal, 0, 0, [[
456..............|45
123..............|45
789..............|12
456..............|78
123..............|45
789..............|45
456..............|12
123..........owwwo==
789..........|...|78
456..........|...|45
123..........|...|12
==o==========o===o==
:'|':':':':':':':':'
''|'''''''''''''''''
:'|':':':':':':':':'
]])

  Spawn("player", 8, 10)
  Spawn("chest", 5.3, 10.5, "puddle")
  Spawn("box", 11.1, 10.5)
  Spawn("chest", 15, 6.5, "hubris")
end

function puddle(wet)
  ApplyTiles(metal, 0, 0, [[
45556.............13
12223.............79
====o.............13
78889.............79
45556.............13
45556.........owww79
12223.........|797>3
o===o.........|1313o
||............|79'''
||............|13:':
||......o=====o79'''
||......||79797>3:':
||......||131313''''
||......||79:':':':'
|o======o|13''''''''
]])

  if wet then
    ApplyTiles(water, 0, 1, [[
.....^^^^^^^^^^^^^..
.....wwwwwwwwwwwww..
.....wwwwwwwwwwwww..
.....wwwwwwwwwwwww..
.....wwwwwwwww......
.....wwwwwwwww......
.....wwwwwwwww......
..wwwwwwwwwwww......
..wwwwwwwwwwww......
..wwwwww............
..wwwwww............
..wwwwww............
..wwwwww............
]])
  else
    ApplyTiles(water, 0, 10, [[
..^^^^^^............
..wwwwww............
..wwwwww............
..wwwwww............
]])
  end

  Spawn("player", 11, 9)
  Spawn("crystal", 16, 2.5)
end

function hubris(wet)
  ApplyTiles(metal, 0, 0, [[
:':':':':':':':':':'
''''''''''''''''''''
==o==============o==
79|..............|79
13|..............|13
9o|..............|o7
<9|..............|7>
13|........79....|13
9o|........46....|o7
<9|........46....|7>
13|........13....|13
==o========oowwwwo==
89788978897889788978
564556455645564EF645
564B5645564556455645
]])

  if wet then
    ApplyTiles(water, 0, 3, [[
...wwwwwwwwwwwwww...
...wwwwwwwwwwwwww...
...wwwwwwwwwwwwww...
...wwwwwwwwwwwwww...
...wwwwwwww..wwww...
...wwwwwwww..wwww...
...wwwwwwww..wwww...
...wwwwwwww..wwww...
]])
  end

  Spawn("player", 6.2, 10)
  Spawn("generic", 15, 10.5)
end

tiles = "tiles/city"
pattern = "backgrounds/tech"
dark = { 0.1, 0.02, 0.04 }
light = { 0.24, 0.07, 0.10 }

