-- Global object confusion/introduction

local castle = { o = "brick", n = "brick_u", u = "brick_d", ["["] = "brick_l", ["]"] = "brick_r",
                 x = "wall", ["="] = "trim", ["#"] = "bars",
                 [":"] = "chain_u", ["'"] = "chain_d", ["*"] = "pillar_u", ["|"] = "pillar_d"}

function start()
  ApplyTiles(castle, 0, 0, [[
xxxxu............nxx
xxxxn............u[]
xxxxu..............*
xxxxn..............|
[][]u..............|
*..................|
|...............====
|...............n[][
==========......uxxx
xxxxxxxxxn......nxxx
xxxxxxxxxun.....uxxx
xxxxxxxxxxu.....nxxx
xxxxxxxxxxn=====uxxx
xxxxxxxxxxu[][][]xxx
xxxxxxxxxxnxxxxxnxxx
]])

  Spawn("crystal", 2.5, 6.5)
  Spawn("lock", 4.2, 6.5)
  Spawn("player", 7.8, 7)
  Spawn("chest", 13.2, 11.5, "hole")
  Spawn("key", 17.5, 5.5)
end

function hole()
  ApplyTiles(castle, 0, 0, [[
xxxxn####nxxxxxxn...
xxxxu####uxxxxxxu...
xxxxn####nxxxxxxn...
xxxxu####uxxxxxxu...
][][][][][][][][][][
xxxn...:..:...nxxxxx
xxxu...:..'...uxxxxx
xxxn...'......nxxxxx
xxxu..........uxxxxx
xxxn..........nxxxxx
xxxu==========uxxxxx
][][][][][][][][][][
xxxxxxn.*.*.*.*.*.nx
xxxxxxu.|.|.|.|.|.ux
xxxxxxn.|.|.|.|.|.nx
]])

  Spawn("player", 7, 9)
  Global("box", 11.2, 9.5)

  Spawn("record", 4.7, 9.5, "sounds/voices/d1")
end

tiles = "tiles/castle"
pattern = "backgrounds/tubes"
dark = {0.06, 0.01, 0.09}
light = {0.17, 0.06, 0.18}

