--- Global chest water jump

local castle = { o = "brick", n = "brick_u", u = "brick_d", ["["] = "brick_l", ["]"] = "brick_r",
                 x = "wall", ["="] = "trim", ["#"] = "bars",
                 [":"] = "chain_u", ["'"] = "chain_d", ["*"] = "pillar_u", ["|"] = "pillar_d" }

local water = { w = "water", ["^"] = "watersurface", ["#"] = "waterbars",
                 [":"] = "waterchain_u", ["'"] = "waterchain_d", ["*"] = "waterpillar_u", ["|"] = "waterpillar_d",
                ["7"] = "buoyul", ["8"] = "buoyu", ["9"] = "buoyur",
                ["4"] = "buoyl", ["5"] = "buoyc", ["6"] = "buoyr",
                ["1"] = "buoydl", ["2"] = "buoyd", ["3"] = "buoydr" }

local glitch = { o = "glitch", ["/"] = "glitchd", s = "glitchsymbol", ["-"] = "glitchledge" }

function start()
  ApplyTiles(castle, 0, 0, [[
xxn...............|.
xxu...............|.
xxn...............|.
xxu..............n[]
xxn..............uxx
xxu..............nxx
xxn..............uxx
xxu..............nxx
xxn..............uxx
[]u=======.......n[]
xxxxxxxxxn.......uxx
xxxxxxxxxu[].....nxx
xxxxxxxxxxxn.....uxx
xxxxxxxxxxxu[][][]xx
xxxxxxxxxxxxxxxxxxxx
]])

  ApplyTiles(water, 0, 9, [[
..........^^^^^^^...
..........wwwwwww...
............wwwww...
............wwwww...
]])

  Spawn("player", 5.2, 8)
  Spawn("chest", 8.5, 8.5, "dichotomy")

  Spawn("record", 16.2, 12.5, "sounds/voices/d10")
end

function dichotomy(wet)
  ApplyTiles(castle, 0, 0, [[
xxxxn.........uxxxxx
xxxxu.........nxxxxx
xxxxn.........uxxxxx
xxxxu.........nxxxxx
xxxxn.........uxxxxx
[][]u.........[][][]
*.*................n
|.|................u
|.|................n
|.|......==========u
|.|......nxxxxxxxxxx
|.|....[]uxxxxxxxxxx
|.|....[]nxxxxxxxxxx
=========uxxxxxxxxxx
[][][][][]xxxxxxxxxx
]])

  if wet then
    ApplyTiles(water, 0, 2, [[
.....^^^^^^^^^......
.....wwwwwwwww......
.....wwwwwwwww......
.....wwwwwwwww......
*w*wwwwwwwwwwwwwwww.
|w|wwwwwwwwwwwwwwww.
|w|wwwwwwwwwwwwwwww.
|w|wwwwww...........
|w|wwwwww...........
|w|wwww.............
|w|wwww.............
]])
  end

  Spawn("player", 4.9, 12)
  Global("chest", 11.5, 8.5, "pass")
  Spawn("lock", 15.5, 7.5)
  Spawn("chest", 17.5, 8., "gasket")
end

function pass(wet)
  ApplyTiles(castle, 0, 0, [[
###nxn..:........nxx
###uxu..'........uxx
[][]xn...........nxx
xxxxxu.........[]uxx
xxxxxn.........[]nxx
xxxxxu......=====uxx
[][][]......nxxxxxxx
xxn.:.......uxxxxxxx
xxu.:.......nxxxxxxx
xxn.'.......uxxxxxxx
xxu.........nxxxxxxx
xxn.........uxxxxxxx
xxu.........nxxxxxxx
xxn=========uxxxxxxx
xxu[][][][][]xxxxxxx
]])

  if wet then
    ApplyTiles(water, 0, 3, [[
......^^^^^^^^^.....
......wwwwwwwww.....
......wwwwww........
......wwwwww........
...w:wwwwwww........
...w:wwwwwww........
...w'wwwwwww........
...wwwwwwwww........
...wwwwwwwww........
...wwwwwwwww........
]])
end

  Spawn("player", 5.1, 12)
  Spawn("key", 13.8, 4.5)
end

function gasket(wet)
  ApplyTiles(castle, 0, 0, [[
xn.....u[][]xn####nx
xu.........nxu####ux
xn.........uxn####nx
xu.........nxu####ux
xn.........uxn####nx
]u======...[]u====u[
xxxxxxxn...nxxxxxxxx
xxxxxxxu...uxxxxxxxx
xxxxxxxn...nxxxxxxxx
xxxxxxxu...u[][][][]
xxxxxxxn.........[][
xxxxxxxu.........o[]
xxxxxxxn.........[][
xxxxxxxu[][][][][][]
xxxxxxxxxxxxxxxxxxxx
]])

  if wet then
    ApplyTiles(water, 0, 0, [[
..wwwww.......####..
..wwwwww789...####..
..wwwwww456...####..
..wwwwww456...####..
..wwwwww456...####..
........123.........
........www.........
........www.........
........www.........
........www.........
........wwwwwwwww...
........wwwwwwwww...
........wwwwwwwww...
]])
  else
    ApplyTiles(water, 0, 8, [[
........789.........
........456.........
........456.........
........456.........
........123.........
]])
  end

  Spawn("player", 5.3, 4)
  Spawn("crystal", 15.5, 11.5)
end

function reject()
  ApplyTiles(glitch, 0, 0, [[
oooooooooooooooooooo
oo/.......ooo/....oo
oo........ooo.....oo
oo........ooo.....oo
oo........ooo.....oo
ooooooo...ooo.....oo
ooooooo...ooo.....oo
oooosoo.........oooo
ooooooo.........oooo
oooosoo.........ooso
ooooooo---------oooo
ooooooo.........ooso
ooooooo.........oooo
ooooooo.........oooo
ooooooo.........oooo
]])

  Spawn("player", 3.6, 4)
  Spawn("chest", 17, 6.5, "distraction")
end

function distraction()
  ApplyTiles(glitch, 0, 0, [[
oooooooooooooooooooo
ooooo......ooooooooo
ooooo......oooooosoo
ooooo......ooooooooo
ooooo......oooosoooo
oooooooo...ooooooooo
oooooooo...oosoooooo
oooooooo...ooooooooo
oooooooo...ooooooooo
ooo/............oooo
ooo.............oooo
ooo.............oooo
ooo..........ooooooo
ooo..........ooooooo
oooooooooooooooooooo
]])

  Spawn("player", 6.5, 4)
  Spawn("chest", 14.5, 11.5, "triplex")

  Spawn("record", 5.7, 13.5, "sounds/voices/d10r")
end

function triplex()
  ApplyTiles(glitch, 0, 0, [[
oooooooooooooooooooo
ooosoo/...........oo
oooooo............oo
oooooo............oo
oo................oo
oo................oo
oo................oo
oo...ooooo........oo
oo.......o........oo
oo.......o........oo
oo.......ooooooooooo
oooooo..........oooo
oooooo..........ooso
ooosoo..........oooo
oooooooooooooooooooo
]])

  Spawn("player", 13.7, 13)
  Global("fan", 7.4, 13.5)
  Spawn("diamond", 16.5, 2.5)
end

tiles = "tiles/castle"
pattern = "backgrounds/tubes"
dark = {0.06, 0.01, 0.09}
light = {0.17, 0.06, 0.18}

