-- Trade global for chest

local castle = { o = "brick", n = "brick_u", u = "brick_d", ["["] = "brick_l", ["]"] = "brick_r",
                 x = "wall", ["="] = "trim", ["#"] = "bars",
                 [":"] = "chain_u", ["'"] = "chain_d", ["*"] = "pillar_u", ["|"] = "pillar_d"}

function start()
  ApplyTiles(castle, 0, 0, [[
xxxxxu......::......
xxxxxn......::...n[]
xxxxxu......:'...uxx
xx[][][]n...:....nxx
xxn.....u...:....uxx
xxu.....n...'....nxx
xxn.....u........uxx
xxu..............nxx
xxn..........====uxx
xxu..........nxxxnxx
xxn===...====uxxxuxx
xxuxxn...nxxxxxxxnxx
][]xxu===uxxxxxxxuxx
xxxxx[][][][][][]nxx
xxxxxxxxxn..*.*..uxx
]])

  Spawn("player", 7.5, 2)
  Spawn("chest", 4.5, 9.5, "keyroom")
  Spawn("chest", 7.5, 11.5, "boxroom")
  Spawn("chest", 11.5, 9.5, "combined")

  Spawn("record", 15.7, 7.5, "sounds/voices/d5")
end

function keyroom()
  ApplyTiles(castle, 0, 0, [[
xxu........:..nxxxxx
xxn........:..uxxxxx
xxu........:..nxxxxx
xxn........:..uxxxxx
xxu........'..[][]xx
xxn...........::.nxx
[]u[]n........:'.uxx
xxxxxu........:..nxx
xxxxxn........'..uxx
xxxxxu...........nxx
xxxxxn...........uxx
xxxxxu========...nxx
][][][][][][]n...uxx
xn###nxxxxxxxu[][][]
xu###uxxxxxxxn......
]])

  Spawn("player", 10.2, 10)
  Global("key", 4.5, 5.5)
end

function boxroom()
  ApplyTiles(castle, 0, 0, [[
xxxxxu.:.:.:.:.uxxxx
xxxxxn.:.:.:.'.nxxxx
xxxxxu.:.:.:...uxxxx
xxxxx[][][][][][][]n
][][]n.........n###u
xn###u.........u###n
xu###n.........n###u
xn###u.........u[][]
]u[][][][][][][]xxxx
xxxxxxxxxn.....nxxxx
xxxxxxxxxu.....uxxxx
[][][][][].....nxxxx
..*...*..n.....uxxxx
..|...|..u[][][]xxxx
..|...|..nxxxxxnxxxx
]])

  Spawn("player", 7.5, 7)
  Spawn("box", 12.5, 7.5)
end

function combined()
  ApplyTiles(castle, 0, 0, [[
xn........u.....:.'.
xu........n.....'...
[]........u.........
.*........*.......n[
.|........|.......ux
.|........|.......nx
.|........|.......ux
.|........|.......nx
.|........|.......ux
.|........[][]....nx
=======...........ux
][][][]...........nx
xxxxxxn...........ux
xxxxxxu===========nx
xxxxxx[][][][][][]ux
]])

  Spawn("player", 4.5, 9)
  Spawn("lock", 11.5, 11.5)
  Spawn("crystal", 12.5, 7.5)
end

tiles = "tiles/castle"
pattern = "backgrounds/tubes"
dark = {0.06, 0.01, 0.09}
light = {0.17, 0.06, 0.18}

