-- Global objects crossing instances

local castle = { o = "brick", n = "brick_u", u = "brick_d", ["["] = "brick_l", ["]"] = "brick_r",
                 x = "wall", ["="] = "trim", ["#"] = "bars",
                 [":"] = "chain_u", ["'"] = "chain_d", ["*"] = "pillar_u", ["|"] = "pillar_d"}

function start()
  ApplyTiles(castle, 0, 0, [[
....................
][]n................
xxxu................
xxxn..............[]
xxxu...[][].......nx
xxxn...nxxn.......ux
xxxu===uxxu.......nx
xxxxxxxxxxn....n[]ux
xxxn[][]xxu....uxxxx
xxxu###nxxn....nxxxx
xxxn###uxxu====uxxxx
xxxu###nxxxxxxxxxxxx
][][][]u[][]nxxx[][]
.:....:.....uxxxn...
.:....'.....nxxxu...
]])

  Spawn("player", 5.5, 5)
  Spawn("chest", 13.5, 9.5, "maisonette")
end

function maisonette()
  ApplyTiles(castle, 0, 0, [[
xu.............|...|
xn.............|...|
xu.............|...|
xn.............o...|
xu.................|
[].................|
xn.................|
xu....o============[
xn...............nxx
xu...............uxx
x[]..............nxx
x[]..............uxx
x[]..............nxx
xn===============uxx
xu[][][][][][][][]xx
]])

  Spawn("player", 7, 12)
  Global("box", 10.5, 12.5)
  Global("key", 13.1, 12.5)
  Spawn("crystal", 17.5, 1.5)
  Spawn("lock", 15.5, 5.5)
  Spawn("chest", 8.4, 6.5, "cellar")
end

function cellar()
  ApplyTiles(castle, 0, 0, [[
xu###u.....nxu......
xn###n.....uxn......
xu###u.....nxu......
][][][][][]u[][][][]
xxxxxn..:..:.....*..
][][]u..:..'.....|..
.....*..:........|..
.....|..'........|..
.....|...........|..
.....|........n[][][
.....|........uxxxxx
[][][][][][]n[][][][
xxxxxxxxxxxxu[].#.#.
[][][][][]xxn.#.#.#.
.........nxxu.#.#.#.
]])

  Spawn("player", 15.5, 8)

  Spawn("record", 7.9, 10.5, "sounds/voices/d6")
end

tiles = "tiles/castle"
pattern = "backgrounds/tubes"
dark = {0.06, 0.01, 0.09}
light = {0.17, 0.06, 0.18}

